/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.tile;

import buildcraft.api.tiles.IDebuggable;
import com.yogpc.qp.Config;
import com.yogpc.qp.item.ItemQuarryDebug;
import com.yogpc.qp.tile.HasInv;
import com.yogpc.qp.tile.IChunkLoadTile;
import com.yogpc.qp.tile.IDebugSender;
import java.util.List;
import java.util.Objects;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import scala.Symbol;

@Optional.Interface(iface="buildcraft.api.tiles.IDebuggable", modid="BuildCraftAPI|tiles")
public abstract class APacketTile
extends TileEntity
implements IDebuggable {
    public static final BinaryOperator<String> combiner = (s, s2) -> s + ", " + s2;
    public static final Function<String, TextComponentString> toComponentString = TextComponentString::new;
    public static final Predicate<Object> nonNull = Objects::nonNull;
    public static final Consumer<IChunkLoadTile> requestTicket = IChunkLoadTile::requestTicket;
    private final ITextComponent displayName;
    protected final boolean machineDisabled;
    protected final boolean isDebugSender = this instanceof IDebugSender;

    protected APacketTile() {
        if (this instanceof HasInv) {
            HasInv hasInv = (HasInv)((Object)this);
            this.displayName = new TextComponentTranslation(hasInv.func_70005_c_(), new Object[0]);
        } else if (this.isDebugSender) {
            IDebugSender sender = (IDebugSender)((Object)this);
            this.displayName = new TextComponentTranslation(sender.getDebugName(), new Object[0]);
        } else {
            this.displayName = new TextComponentString("APacketTile");
        }
        this.machineDisabled = Config.content().disableMapJ().get(this.getSymbol());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.func_145839_a(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public ITextComponent func_145748_c_() {
        return this.displayName;
    }

    protected abstract Symbol getSymbol();

    public void getDebugInfo(List<String> left, List<String> right, EnumFacing side) {
        left.add(((Object)((Object)this)).getClass().getName());
        left.add(ItemQuarryDebug.tileposToString(this).func_150265_g());
        if (this.isDebugSender) {
            IDebugSender sender = (IDebugSender)((Object)this);
            sender.getMessage().stream().map(ITextComponent::func_150261_e).forEach(left::add);
        }
    }
}

