/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.tile;

import buildcraft.api.mj.MjCapabilityHelper;
import buildcraft.api.tiles.IDebuggable;
import cofh.api.energy.IEnergyReceiver;
import com.yogpc.qp.Config;
import com.yogpc.qp.item.ItemQuarryDebug;
import com.yogpc.qp.tile.APacketTile;
import com.yogpc.qp.tile.EnergyDebug;
import com.yogpc.qp.tile.EnergyUsage;
import com.yogpc.qp.tile.IDebugSender;
import com.yogpc.qp.tile.MjReciever;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModAPIManager;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.InterfaceList(value={@Optional.Interface(iface="cofh.api.energy.IEnergyReceiver", modid="cofhapi|energy"), @Optional.Interface(iface="buildcraft.api.tiles.IDebuggable", modid="BuildCraftAPI|tiles"), @Optional.Interface(iface="ic2.api.energy.tile.IEnergySink", modid="ic2")})
public abstract class APowerTile
extends APacketTile
implements ITickable,
IEnergyStorage,
IEnergyReceiver,
IEnergySink,
IDebuggable {
    double all;
    double maxGot;
    double max;
    double got;
    private boolean ic2ok = false;
    public boolean bcLoaded;
    public final boolean ic2Loaded;
    private Object helper;
    protected final EnergyDebug debug = new EnergyDebug(this);
    protected boolean outputEnergyInfo = true;

    public APowerTile() {
        this.bcLoaded = ModAPIManager.INSTANCE.hasAPI("BuildCraftAPI|core");
        this.ic2Loaded = Loader.isModLoaded((String)"ic2");
        if (this.bcLoaded) {
            this.helper = MjReciever.mjCapabilityHelper(this);
        }
    }

    public void func_73660_a() {
        this.postLoadEvent();
        this.all += this.got;
        if (!this.func_145831_w().field_72995_K && this.isWorking()) {
            this.debug.getAndTick(this.got);
        }
        this.got = 0.0;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.postUnLoadEvent();
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.postUnLoadEvent();
    }

    private void postLoadEvent() {
        if (!this.func_145831_w().field_72995_K && !this.ic2ok) {
            if (this.ic2Loaded) {
                try {
                    this.ic2load();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            this.ic2ok = true;
        }
    }

    private void postUnLoadEvent() {
        if (this.ic2ok && !this.func_145831_w().field_72995_K) {
            if (this.ic2Loaded) {
                try {
                    this.ic2unload();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            this.ic2ok = false;
        }
    }

    protected final BlockPos[] getNeighbors(EnumFacing facing) {
        return new BlockPos[]{this.field_174879_c.func_177972_a(facing), this.field_174879_c.func_177972_a(facing.func_176735_f()), this.field_174879_c.func_177972_a(facing.func_176746_e())};
    }

    public final boolean isOutputEnergyInfo() {
        return this.outputEnergyInfo;
    }

    public final void toggleOutputEnergyInfo() {
        this.outputEnergyInfo = !this.outputEnergyInfo;
    }

    protected final void startWork() {
        this.debug.start();
    }

    protected final void finishWork() {
        this.debug.finish();
    }

    protected abstract boolean isWorking();

    @Optional.Method(modid="ic2")
    public final void ic2load() {
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
    }

    @Optional.Method(modid="ic2")
    public final void ic2unload() {
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
    }

    public void func_145839_a(NBTTagCompound nbttc) {
        super.func_145839_a(nbttc);
        this.setStoredEnergy(nbttc.func_74769_h("storedEnergy"));
        this.configure(nbttc.func_74769_h("MAX_receive"), nbttc.func_74769_h("MAX_stored"));
        this.outputEnergyInfo = !nbttc.func_74764_b("outputEnergyInfo") || nbttc.func_74767_n("outputEnergyInfo");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbttc) {
        nbttc.func_74780_a("storedEnergy", this.all);
        nbttc.func_74780_a("MAX_stored", this.max);
        nbttc.func_74780_a("MAX_receive", this.maxGot);
        nbttc.func_74757_a("outputEnergyInfo", this.outputEnergyInfo);
        return super.func_189515_b(nbttc);
    }

    public final double useEnergy(double min, double amount, boolean real, EnergyUsage usage) {
        if (Config.content().noEnergy()) {
            this.debug.use(amount, !real, usage);
            return amount;
        }
        double res = 0.0;
        if (this.all >= min) {
            if (this.all <= amount) {
                res = this.all;
                if (real) {
                    this.all = 0.0;
                }
            } else {
                res = amount;
                if (real) {
                    this.all -= amount;
                }
            }
        }
        this.debug.use(res, !real, usage);
        return res;
    }

    final double getEnergy(double a, boolean real) {
        if (Config.content().noEnergy()) {
            return 0.0;
        }
        double ret = Math.min(Math.min(this.maxGot - this.got, this.max - this.all - this.got), a);
        if (real) {
            this.got += ret;
        }
        return ret;
    }

    public final double getStoredEnergy() {
        return this.all;
    }

    public final void setStoredEnergy(double all) {
        this.all = all;
    }

    public final double getMaxStored() {
        return this.max;
    }

    public final void configure(double maxRecieve, double maxstored) {
        this.maxGot = maxRecieve;
        this.max = maxstored;
        if (Config.content().noEnergy()) {
            this.all = maxstored;
        }
    }

    @Optional.Method(modid="ic2")
    public final double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
        double mj = amount / 2.5;
        this.got += mj;
        return 0.0;
    }

    @Optional.Method(modid="ic2")
    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing side) {
        return this.canReceive();
    }

    @Optional.Method(modid="ic2")
    public final double getDemandedEnergy() {
        return Math.min(this.maxGot - this.got, this.max - this.all - this.got) * 2.5;
    }

    @Optional.Method(modid="ic2")
    public final int getSinkTier() {
        return 4;
    }

    @Optional.Method(modid="cofhapi|energy")
    public final int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return this.receiveEnergy(maxReceive, simulate);
    }

    @Optional.Method(modid="cofhapi|energy")
    public final int getEnergyStored(EnumFacing from) {
        return this.getEnergyStored();
    }

    @Optional.Method(modid="cofhapi|energy")
    public final int getMaxEnergyStored(EnumFacing from) {
        return this.getMaxEnergyStored();
    }

    @Optional.Method(modid="cofhapi|energy")
    public final boolean canConnectEnergy(EnumFacing from) {
        return this.canReceive();
    }

    public final int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        int i = (int)this.getEnergy((double)maxReceive / 10.0, !simulate) * 10;
        if (maxReceive > 0 && i == 0 && this.max - this.all > 0.0 && this.max - this.all < 1.0) {
            return 1;
        }
        return i;
    }

    public final int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public final int getEnergyStored() {
        return (int)(this.all * 10.0);
    }

    public final int getMaxEnergyStored() {
        return (int)(this.max * 10.0);
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getDebugInfo(List<String> left, List<String> right, EnumFacing side) {
        left.add(((Object)((Object)this)).getClass().getName());
        left.add(ItemQuarryDebug.tileposToString(this).func_150265_g());
        left.add(ItemQuarryDebug.energyToString(this).func_150265_g());
        if (this.isDebugSender) {
            IDebugSender sender = (IDebugSender)((Object)this);
            sender.getMessage().stream().map(ITextComponent::func_150261_e).forEach(left::add);
        }
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (this.bcLoaded && this.hasMJCapability(capability, facing)) {
            return true;
        }
        return capability == CapabilityEnergy.ENERGY || super.hasCapability(capability, facing);
    }

    @Optional.Method(modid="BuildCraftAPI|core")
    private boolean hasMJCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return ((MjCapabilityHelper)this.helper).hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        Object o;
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this);
        }
        if (this.bcLoaded && (o = this.getMjCapability(capability, facing)) != null) {
            return (T)o;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Optional.Method(modid="BuildCraftAPI|core")
    private <T> Object getMjCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return ((MjCapabilityHelper)this.helper).getCapability(capability, facing);
    }
}

