/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.tile;

import buildcraft.api.mj.IMjConnector;
import buildcraft.api.mj.IMjReadable;
import buildcraft.api.mj.IMjReceiver;
import com.yogpc.qp.Config;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.tile.APowerTile;
import java.lang.reflect.Constructor;
import javax.annotation.Nonnull;
import net.minecraftforge.fml.common.ModAPIManager;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="buildcraft.api.mj.IMjReceiver", modid="BuildCraftAPI|core"), @Optional.Interface(iface="buildcraft.api.mj.IMjReadable", modid="BuildCraftAPI|core")})
public class MjReciever
implements IMjReceiver,
IMjReadable {
    private final APowerTile tile;
    private static final Constructor<?> CONSTRUCTOR;

    public static Object mjCapabilityHelper(APowerTile tile) {
        if (CONSTRUCTOR == null) {
            return null;
        }
        try {
            return CONSTRUCTOR.newInstance(new MjReciever(tile));
        }
        catch (ReflectiveOperationException e) {
            if (Config.content().debug()) {
                QuarryPlus.LOGGER.error(MjReciever.class.getSimpleName(), (Throwable)e);
            }
            return null;
        }
    }

    @Optional.Method(modid="BuildCraftAPI|core")
    public static double getMJfrommicro(long microJoules) {
        return (double)microJoules / 1000000.0;
    }

    public MjReciever(APowerTile tile) {
        this.tile = tile;
    }

    @Optional.Method(modid="BuildCraftAPI|core")
    public long getStored() {
        return (long)(this.tile.getStoredEnergy() * 1000000.0);
    }

    @Optional.Method(modid="BuildCraftAPI|core")
    public long getCapacity() {
        return (long)(this.tile.getMaxStored() * 1000000.0);
    }

    @Optional.Method(modid="BuildCraftAPI|core")
    public long getPowerRequested() {
        return (long)(Math.min(this.tile.maxGot - this.tile.got, this.tile.getMaxStored() - this.tile.getStoredEnergy() - this.tile.got) * 1000000.0);
    }

    @Optional.Method(modid="BuildCraftAPI|core")
    public long receivePower(long microJoules, boolean simulate) {
        return (long)((double)microJoules - this.tile.getEnergy(MjReciever.getMJfrommicro(microJoules), !simulate) * 1000000.0);
    }

    @Optional.Method(modid="BuildCraftAPI|core")
    public boolean canConnect(@Nonnull IMjConnector other) {
        return true;
    }

    static {
        Constructor<?> temp;
        boolean b = ModAPIManager.INSTANCE.hasAPI("BuildCraftAPI|core");
        if (b) {
            try {
                temp = Class.forName("buildcraft.api.mj.MjCapabilityHelper").getConstructor(Class.forName("buildcraft.api.mj.IMjConnector"));
            }
            catch (ReflectiveOperationException e) {
                if (Config.content().debug()) {
                    QuarryPlus.LOGGER.error(MjReciever.class.getSimpleName(), (Throwable)e);
                }
                temp = null;
            }
        } else {
            temp = null;
        }
        CONSTRUCTOR = temp;
    }
}

