/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp;

import com.yogpc.qp.Config;
import com.yogpc.qp.tile.APowerTile;
import com.yogpc.qp.tile.DetailDataCollector;
import com.yogpc.qp.tile.EnergyUsage;
import com.yogpc.qp.tile.TileMiningWell;
import net.minecraft.block.state.IBlockState;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class PowerManager {
    private static double QuarryWork_CF;
    private static double QuarryWork_CS;
    private static double MiningWell_CF;
    private static double MiningWell_CS;
    private static long QuarryWork_BP;
    private static double QuarryWork_CE;
    private static double QuarryWork_CU;
    private static long QuarryWork_XR;
    private static long QuarryWork_MS;
    private static long FrameBuild_BP;
    private static double FrameBuild_CE;
    private static double FrameBuild_CU;
    private static long FrameBuild_XR;
    private static long FrameBuild_MS;
    private static long MiningWell_BP;
    private static double MiningWell_CE;
    private static double MiningWell_CU;
    private static long MiningWell_XR;
    private static long MiningWell_MS;
    private static long Laser_BP;
    private static double Laser_CE;
    private static double Laser_CU;
    private static long Laser_XR;
    private static long Laser_MS;
    private static double Laser_CF;
    private static double Laser_CS;
    private static double Refinery_CE;
    private static double Refinery_CU;
    private static long Refinery_XR;
    private static long Refinery_MS;
    private static long PumpFrame_BP;
    private static double PumpFrame_CU;
    private static long PumpDrain_BP;
    private static double PumpDrain_CU;
    private static long MoveHead_BP;
    private static double MoveHead_CU;
    private static long FillerWork_BP;
    private static final int length;

    private static double get(ConfigCategory c, String name, double def) {
        if (c.containsKey(name)) {
            Property prop = c.get(name);
            if (prop.getType() == null) {
                prop = new Property(prop.getName(), prop.getString(), Property.Type.DOUBLE);
                prop.setComment(c.getQualifiedName().substring(length) + "." + name);
                c.put(name, prop);
            }
            prop.setMinValue(1.0E-9).setMaxValue(2.0E9).setDefaultValue(def);
            return prop.getDouble(def);
        }
        Property prop = new Property(name, Double.toString(def), Property.Type.DOUBLE);
        prop.setComment(c.getQualifiedName().substring(length) + "." + name);
        prop.setMinValue(1.0E-9).setMaxValue(2.0E9).setDefaultValue(def);
        c.put(name, prop);
        return prop.getDouble(def);
    }

    static void loadConfiguration(Configuration cg) throws RuntimeException {
        ConfigCategory powerSetting = cg.getCategory("general.PowerSetting");
        powerSetting.setComment("Quarry PowerSetting (min = 1e-9, Max = 2,000,000,000 = 2 billion)");
        String cn = "general.PowerSetting.";
        String cn2 = "general.PowerSetting.Quarry.";
        ConfigCategory c = cg.getCategory(cn2 + "BreakBlock");
        long micro = 1000000L;
        QuarryWork_BP = (long)((double)micro * PowerManager.get(c, "BasePower", 40.0));
        QuarryWork_CE = PowerManager.get(c, "EfficiencyCoefficient", 1.3);
        QuarryWork_CU = PowerManager.get(c, "UnbreakingCoefficient", 1.0);
        QuarryWork_CF = PowerManager.get(c, "FortuneCoefficient", 1.3);
        QuarryWork_CS = PowerManager.get(c, "SilktouchCoefficient", 2.0);
        QuarryWork_XR = (long)((double)micro * PowerManager.get(c, "BaseMaxRecieve", 300.0));
        QuarryWork_MS = (long)((double)micro * PowerManager.get(c, "BaseMaxStored", 15000.0));
        c = cg.getCategory(cn2 + "BreakBlock" + "." + "MoveHead");
        MoveHead_BP = (long)((double)micro * PowerManager.get(c, "BasePower", 200.0));
        MoveHead_CU = PowerManager.get(c, "UnbreakingCoefficient", 1.0);
        c = cg.getCategory(cn2 + "MakeFrame");
        FrameBuild_BP = (long)((double)micro * PowerManager.get(c, "BasePower", 25.0));
        FrameBuild_CE = PowerManager.get(c, "EfficiencyCoefficient", 1.3);
        FrameBuild_CU = PowerManager.get(c, "UnbreakingCoefficient", 1.0);
        FrameBuild_XR = (long)((double)micro * PowerManager.get(c, "BaseMaxRecieve", 100.0));
        FrameBuild_MS = (long)((double)micro * PowerManager.get(c, "BaseMaxStored", 15000.0));
        cn2 = "general.PowerSetting.Pump.";
        c = cg.getCategory(cn2 + "DrainLiquid");
        PumpDrain_BP = (long)((double)micro * PowerManager.get(c, "BasePower", 10.0));
        PumpDrain_CU = PowerManager.get(c, "UnbreakingCoefficient", 1.0);
        c = cg.getCategory(cn2 + "MakeFrame");
        PumpFrame_BP = (long)((double)micro * PowerManager.get(c, "BasePower", 25.0));
        PumpFrame_CU = PowerManager.get(c, "UnbreakingCoefficient", 1.0);
        c = cg.getCategory("general.PowerSetting.MiningWell");
        MiningWell_BP = (long)((double)micro * PowerManager.get(c, "BasePower", 40.0));
        MiningWell_CE = PowerManager.get(c, "EfficiencyCoefficient", 1.3);
        MiningWell_CU = PowerManager.get(c, "UnbreakingCoefficient", 1.0);
        MiningWell_CF = PowerManager.get(c, "FortuneCoefficient", 1.3);
        MiningWell_CS = PowerManager.get(c, "SilktouchCoefficient", 2.0);
        MiningWell_XR = (long)((double)micro * PowerManager.get(c, "BaseMaxRecieve", 100.0));
        MiningWell_MS = (long)((double)micro * PowerManager.get(c, "BaseMaxStored", 1000.0));
        c = cg.getCategory("general.PowerSetting.Laser");
        Laser_BP = (long)((double)micro * PowerManager.get(c, "BasePower", 4.0));
        Laser_CE = PowerManager.get(c, "EfficiencyCoefficient", 2.0);
        Laser_CU = PowerManager.get(c, "UnbreakingCoefficient", 0.1);
        Laser_CF = PowerManager.get(c, "FortuneCoefficient", 1.05);
        Laser_CS = PowerManager.get(c, "SilktouchCoefficient", 1.1);
        Laser_XR = (long)((double)micro * PowerManager.get(c, "BaseMaxRecieve", 100.0));
        Laser_MS = (long)((double)micro * PowerManager.get(c, "BaseMaxStored", 1000.0));
        c = cg.getCategory("general.PowerSetting.Refinery");
        Refinery_CE = PowerManager.get(c, "EfficiencyCoefficient", 1.2);
        Refinery_CU = PowerManager.get(c, "UnbreakingCoefficient", 1.0);
        Refinery_XR = (long)((double)micro * PowerManager.get(c, "BaseMaxRecieve", 6.0));
        Refinery_MS = (long)((double)micro * PowerManager.get(c, "BaseMaxStored", 1000.0));
        c = cg.getCategory("general.PowerSetting.Filler");
        FillerWork_BP = (long)((double)micro * PowerManager.get(c, "BasePower", 40.0));
    }

    public static void configure0(APowerTile pp) {
        pp.configure(0L, pp.getMaxStored());
    }

    private static void configure(APowerTile pp, double CE, int efficiencyLevel, int unbreakingLevel, double CU, long maxReceive, long maxStored, int pump2) {
        pp.configure((long)((double)maxReceive * Math.pow(CE, efficiencyLevel) / ((double)unbreakingLevel * CU + 1.0)), (long)((double)maxStored * Math.pow(CE, efficiencyLevel) / ((double)unbreakingLevel * CU + 1.0) + (pump2 > 0 ? (double)(65536L * PumpDrain_BP) / ((double)pump2 * PumpDrain_CU + 1.0) + (double)(1020L * PumpFrame_BP) / ((double)pump2 * PumpFrame_CU + 1.0) : 0.0)));
    }

    public static void configureQuarryWork(APowerTile pp, int efficiencyLevel, int unbreakingLevel, int pump2) {
        PowerManager.configure(pp, QuarryWork_CE, efficiencyLevel, unbreakingLevel, QuarryWork_CU, QuarryWork_XR, QuarryWork_MS, pump2);
    }

    public static void configureMiningWell(APowerTile pp, int efficiencyLevel, int unbreakingLevel, int pump2) {
        PowerManager.configure(pp, MiningWell_CE, efficiencyLevel, unbreakingLevel, MiningWell_CU, MiningWell_XR, MiningWell_MS, pump2);
    }

    public static void configureLaser(APowerTile pp, int efficiencyLevel, int unbreakingLevel) {
        PowerManager.configure(pp, Laser_CE, efficiencyLevel, unbreakingLevel, Laser_CU, Laser_XR, Laser_MS, 0);
    }

    public static void configureFrameBuild(APowerTile pp, int efficiencyLevel, int unbreakingLevel, int pump2) {
        PowerManager.configure(pp, FrameBuild_CE, efficiencyLevel, unbreakingLevel, FrameBuild_CU, FrameBuild_XR, FrameBuild_MS, pump2);
    }

    public static void configureRefinery(APowerTile pp, int efficiencyLevel, int unbreakingLevel) {
        PowerManager.configure(pp, Refinery_CE, efficiencyLevel, unbreakingLevel, Refinery_CU, Refinery_XR, Refinery_MS, 0);
    }

    public static boolean useEnergy(APowerTile pp, long energy, EnergyUsage usage) {
        if (pp.useEnergy(energy, energy, false, usage) != energy) {
            return false;
        }
        pp.useEnergy(energy, energy, true, usage);
        pp.collector.get().addData(new DetailDataCollector.Common(usage, energy));
        return true;
    }

    public static boolean useEnergyBreak(APowerTile pp, float hardness, int enchantMode, int unbreaking, boolean replacer, IBlockState state) {
        if (enchantMode == -2) {
            return true;
        }
        long pw = (long)(PowerManager.calcEnergyBreak(pp, hardness, enchantMode, unbreaking) * (replacer ? 1.1 : 1.0));
        if (pp.useEnergy(pw, pw, false, EnergyUsage.BREAK_BLOCK) != pw) {
            return false;
        }
        pp.useEnergy(pw, pw, true, EnergyUsage.BREAK_BLOCK);
        pp.collector.get().addData(new DetailDataCollector.Break(state, hardness, pw));
        return true;
    }

    private static double calcEnergyBreak(APowerTile pp, float hardness, int enchantMode, int unbreaking) {
        double CSP;
        double CU;
        long BP;
        if (pp instanceof TileMiningWell) {
            BP = MiningWell_BP;
            CU = MiningWell_CU;
            CSP = enchantMode < 0 ? MiningWell_CS : Math.pow(MiningWell_CF, enchantMode);
        } else {
            BP = QuarryWork_BP;
            CU = QuarryWork_CU;
            CSP = enchantMode < 0 ? QuarryWork_CS : Math.pow(QuarryWork_CF, enchantMode);
        }
        return (double)((float)BP * hardness) * CSP / ((double)unbreaking * CU + 1.0);
    }

    public static long calcEnergyBreak(float hardness, int enchantMode, int unbreaking) {
        long BP = QuarryWork_BP;
        double CU = QuarryWork_CU;
        double CSP = enchantMode < 0 ? QuarryWork_CS : Math.pow(QuarryWork_CF, enchantMode);
        return (long)((double)((float)BP * hardness) * CSP / ((double)unbreaking * CU + 1.0));
    }

    public static boolean useEnergyPump(APowerTile pp, int U, long liquidsCount, long framesToBuild) {
        long pw = PowerManager.calcEnergyPumpDrain(U, liquidsCount, framesToBuild);
        if (pp.useEnergy(pw, pw, false, EnergyUsage.PUMP_FLUID) != pw) {
            return false;
        }
        pp.useEnergy(pw, pw, true, EnergyUsage.PUMP_FLUID);
        pp.collector.get().addData(new DetailDataCollector.Pump(liquidsCount, U, framesToBuild, pw));
        return true;
    }

    public static long calcEnergyPumpDrain(int unbreaking, long liquids, long frames) {
        return (long)((double)(PumpDrain_BP * liquids) / ((double)unbreaking * PumpDrain_CU + 1.0) + (double)(PumpFrame_BP * frames) / ((double)unbreaking * PumpFrame_CU + 1.0));
    }

    private static boolean useEnergy(APowerTile pp, long BP, int U, double CU, int E, double CE, EnergyUsage usage) {
        long pw = (long)((double)BP / Math.pow(CE, E) / ((double)U * CU + 1.0));
        if (pp.useEnergy(pw, pw, false, usage) != pw) {
            return false;
        }
        pp.useEnergy(pw, pw, true, usage);
        pp.collector.get().addData(new DetailDataCollector.Common(usage, pw));
        return true;
    }

    public static boolean useEnergyFrameBuild(APowerTile pp, int U) {
        return PowerManager.useEnergy(pp, FrameBuild_BP, U, FrameBuild_CU, 0, 1.0, EnergyUsage.FRAME_BUILD);
    }

    public static boolean useEnergyRefinery(APowerTile pp, long BP, int U, int E) {
        return PowerManager.useEnergy(pp, BP, U, Refinery_CU, E, Refinery_CE, EnergyUsage.REFINERY);
    }

    public static double useEnergyQuarryHead(APowerTile pp, double dist, int U) {
        double bp = (double)MoveHead_BP / 1000000.0;
        double pw = !Config.content().fastQuarryHeadMove() ? Math.min(2.0 + (double)pp.getStoredEnergy() / 500.0 / 1000000.0, (dist / 2.0 - 0.05) * bp / ((double)U * MoveHead_CU + 1.0)) : (dist / 2.0 - 0.05) * bp / ((double)U * MoveHead_CU + 1.0);
        long used = pp.useEnergy(0L, (long)(pw * 1000000.0), true, EnergyUsage.MOVE_HEAD);
        pw = (double)used / 1000000.0;
        pp.collector.get().addData(new DetailDataCollector.Common(EnergyUsage.MOVE_HEAD, used));
        return pw * ((double)U * MoveHead_CU + 1.0) / bp + 0.05;
    }

    public static long simulateEnergyLaser(APowerTile pp, int U, int F2, boolean S, int E) {
        long pw = (long)((double)Laser_BP * Math.pow(Laser_CF, F2) * Math.pow(Laser_CE, E) / ((double)U * Laser_CU + 1.0));
        if (S) {
            long used = pp.useEnergy(0L, (long)((double)pw * Laser_CS), false, EnergyUsage.LASER);
            return (long)((double)used / Laser_CS * ((double)U * Laser_CU + 1.0) / Math.pow(Laser_CF, F2));
        }
        long used = pp.useEnergy(0L, pw, false, EnergyUsage.LASER);
        return (long)((double)used * ((double)U * Laser_CU + 1.0) / Math.pow(Laser_CF, F2));
    }

    public static void useEnergyLaser(APowerTile pp, long power, int U, int F2, boolean S, boolean simulate) {
        long pw = (long)((double)power * Math.pow(Laser_CF, F2) * (S ? Laser_CS : 1.0) / ((double)U * Laser_CU + 1.0));
        pp.useEnergy(pw, pw, !simulate, EnergyUsage.LASER);
        if (!simulate) {
            pp.collector.get().addData(new DetailDataCollector.Common(EnergyUsage.LASER, pw));
        }
    }

    public static long calcEnergyAdvSearch(int unbreakingLevel, int targetY) {
        return (long)((double)(MoveHead_BP * (long)targetY) / (MoveHead_CU * (double)unbreakingLevel + 1.0) / 4.0);
    }

    public static boolean useEnergyFillerWork(APowerTile filler, boolean simulate) {
        boolean result;
        long pw = FillerWork_BP;
        boolean bl = result = filler.useEnergy(pw, pw, !simulate, EnergyUsage.FILLER) == pw;
        if (result && !simulate) {
            filler.collector.get().addData(new DetailDataCollector.Common(EnergyUsage.FILLER, pw));
        }
        return result;
    }

    static {
        length = "general.".length();
    }
}

