/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.block;

import com.yogpc.qp.Config;
import com.yogpc.qp.QuarryPlusI;
import com.yogpc.qp.block.ADismCBlock;
import com.yogpc.qp.compat.InvUtils;
import com.yogpc.qp.tile.TileMarker;
import com.yogpc.qp.version.VersionUtil;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockMarker
extends Block
implements ITileEntityProvider {
    protected static final AxisAlignedBB STANDING_AABB = new AxisAlignedBB(0.35, 0.0, 0.35, 0.65, 0.65, 0.65);
    protected static final AxisAlignedBB DOWN_AABB = new AxisAlignedBB(0.35, 0.35, 0.35, 0.65, 1.0, 0.65);
    protected static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.35, 0.35, 0.35, 0.65, 0.65, 1.0);
    protected static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.35, 0.35, 0.0, 0.65, 0.65, 0.65);
    protected static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.35, 0.35, 0.35, 1.0, 0.65, 0.65);
    protected static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.0, 0.35, 0.35, 0.65, 0.65, 0.65);
    public final ItemBlock itemBlock;

    public BlockMarker() {
        super(Material.field_151594_q);
        this.func_149715_a(0.5f);
        this.func_149663_c("markerplus");
        this.setRegistryName("quarryplus", "markerplus");
        this.func_149647_a(QuarryPlusI.creativeTab());
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)ADismCBlock.FACING, (Comparable)EnumFacing.UP));
        this.field_149758_A = true;
        this.itemBlock = new ItemBlock((Block)this);
        this.itemBlock.setRegistryName("quarryplus", "markerplus");
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)ADismCBlock.FACING)) {
            case UP: {
                return STANDING_AABB;
            }
            case DOWN: {
                return DOWN_AABB;
            }
            case EAST: {
                return EAST_AABB;
            }
            case WEST: {
                return WEST_AABB;
            }
            case NORTH: {
                return NORTH_AABB;
            }
            case SOUTH: {
                return SOUTH_AABB;
            }
        }
        return STANDING_AABB;
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        return this.canPlaceAt(worldIn, pos, side) || this.canPlaceAt(worldIn, pos, EnumFacing.UP);
    }

    private boolean canPlaceAt(World worldIn, BlockPos pos, EnumFacing facing) {
        BlockPos blockpos = pos.func_177972_a(facing.func_176734_d());
        return worldIn.isSideSolid(blockpos, facing, true);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity entity;
        if (!worldIn.field_72995_K && (entity = worldIn.func_175625_s(pos)) instanceof TileMarker) {
            TileMarker marker = (TileMarker)entity;
            if (marker.link != null) {
                marker.link.removeConnection(false);
            }
        }
        worldIn.func_175713_t(pos);
        super.func_180663_b(worldIn, pos, state);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        if (this.canPlaceAt(world, pos, facing)) {
            return this.func_176223_P().func_177226_a((IProperty)ADismCBlock.FACING, (Comparable)facing);
        }
        return this.func_176223_P().func_177226_a((IProperty)ADismCBlock.FACING, (Comparable)EnumFacing.UP);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ADismCBlock.FACING});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)ADismCBlock.FACING, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)ADismCBlock.FACING)).func_176745_a();
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        Optional.ofNullable((TileMarker)worldIn.func_175625_s(pos)).ifPresent(TileMarker::G_updateSignal);
        this.dropTorchIfCantStay(state, worldIn, pos);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176213_c(worldIn, pos, state);
        this.dropTorchIfCantStay(state, worldIn, pos);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (!worldIn.field_72995_K) {
            Optional.ofNullable((TileMarker)worldIn.func_175625_s(pos)).ifPresent(TileMarker.requestTicket);
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (InvUtils.isDebugItem(playerIn, hand)) {
            return true;
        }
        if (!worldIn.field_72995_K) {
            Item item = playerIn.func_184586_b(hand).func_77973_b();
            TileMarker marker = (TileMarker)worldIn.func_175625_s(pos);
            if (marker != null) {
                if (Config.content().disableMapJ().get(TileMarker.SYMBOL).booleanValue()) {
                    VersionUtil.sendMessage(playerIn, (ITextComponent)new TextComponentString("Marker is disabled."), true);
                    return true;
                }
                if (item == QuarryPlusI.itemTool() && playerIn.func_184586_b(hand).func_77952_i() == 0) {
                    TileMarker.Link l = marker.link;
                    if (l == null) {
                        return true;
                    }
                    VersionUtil.sendMessage(playerIn, (ITextComponent)new TextComponentTranslation("chat.markerarea", new Object[0]));
                    String sb = "x:" + l.xMin + " y:" + l.yMin + " z:" + l.zMin + " - x:" + l.xMax + " y:" + l.yMax + " z:" + l.zMax;
                    VersionUtil.sendMessage(playerIn, (ITextComponent)new TextComponentString(sb));
                    return true;
                }
                marker.S_tryConnection();
            }
        }
        return true;
    }

    public TileMarker createNewTileEntity(World w, int m) {
        return new TileMarker();
    }

    private void dropTorchIfCantStay(IBlockState state, World worldIn, BlockPos pos) {
        if (state.func_177230_c() != this || !this.canPlaceAt(worldIn, pos, (EnumFacing)state.func_177229_b((IProperty)ADismCBlock.FACING))) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }
}

