/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.block;

import com.yogpc.qp.Config;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.QuarryPlusI;
import com.yogpc.qp.block.ADismCBlock;
import com.yogpc.qp.compat.BuildcraftHelper;
import com.yogpc.qp.compat.InvUtils;
import com.yogpc.qp.tile.TilePlacer;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import scala.Symbol;

public class BlockPlacer
extends ADismCBlock {
    public static final Symbol SYMBOL = Symbol.apply((String)"PlacerPlus");

    public BlockPlacer() {
        super(Material.field_151573_f, "placerplus", ItemBlock::new);
        this.func_149711_c(3.5f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(worldIn, pos, state, rand);
        if (!worldIn.field_72995_K && !Config.content().disableMapJ().get(SYMBOL).booleanValue()) {
            Optional.ofNullable((TilePlacer)worldIn.func_175625_s(pos)).ifPresent(TilePlacer::updateTick);
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, POWERED});
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (!worldIn.field_72995_K) {
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)placer)), 2);
        }
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos p_193383_3_, EnumFacing side) {
        return state.func_177229_b((IProperty)FACING) != side ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        boolean flag = worldIn.func_175640_z(pos);
        if (flag != (Boolean)state.func_177229_b((IProperty)POWERED)) {
            state = state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(flag));
            TileEntity entity = worldIn.func_175625_s(pos);
            if (entity != null) {
                entity.func_145829_t();
                worldIn.func_180501_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(flag)), 2);
                entity.func_145829_t();
                worldIn.func_175690_a(pos, entity);
            }
            if (flag) {
                this.func_180650_b(worldIn, pos, state, worldIn.field_73012_v);
            }
        }
    }

    @Override
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ)) {
            return true;
        }
        ItemStack stack = playerIn.func_184586_b(hand);
        if (BuildcraftHelper.isWrench(playerIn, hand, stack, new RayTraceResult(new Vec3d((double)hitX, (double)hitY, (double)hitZ), facing, pos))) {
            return InvUtils.setNewState(worldIn, pos, state.func_177231_a((IProperty)FACING));
        }
        if (!playerIn.func_70093_af()) {
            if (Config.content().debug()) {
                QuarryPlus.LOGGER.info("Placer touched " + hand + " Item : " + stack);
            }
            playerIn.openGui((Object)QuarryPlus.INSTANCE, QuarryPlusI.guiIdPlacer(), worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        return false;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        InvUtils.dropAndUpdateInv(worldIn, pos, (TilePlacer)worldIn.func_175625_s(pos), (Block)this);
        super.func_180663_b(worldIn, pos, state);
    }

    public TilePlacer createNewTileEntity(World worldIn, int meta) {
        return new TilePlacer();
    }

    public int func_176201_c(IBlockState state) {
        boolean powered = (Boolean)state.func_177229_b((IProperty)POWERED);
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        return facing.func_176745_a() | (powered ? 8 : 0);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)(meta & 7))).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf((meta & 8) == 8));
    }

    @Override
    protected boolean canRotate() {
        return true;
    }

    @Override
    protected boolean validFacing(EnumFacing facing) {
        return true;
    }
}

