/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.tile;

import buildcraft.api.mj.MjCapabilityHelper;
import buildcraft.api.tiles.IDebuggable;
import cofh.redstoneflux.api.IEnergyReceiver;
import com.yogpc.qp.Config;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.item.ItemQuarryDebug;
import com.yogpc.qp.tile.APacketTile;
import com.yogpc.qp.tile.DetailDataCollector;
import com.yogpc.qp.tile.EnergyDebug;
import com.yogpc.qp.tile.EnergyUsage;
import com.yogpc.qp.tile.IDebugSender;
import com.yogpc.qp.tile.MjReceiver;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.Event;

@Optional.InterfaceList(value={@Optional.Interface(iface="cofh.redstoneflux.api.IEnergyReceiver", modid="redstoneflux"), @Optional.Interface(iface="buildcraft.api.tiles.IDebuggable", modid="buildcraftlib"), @Optional.Interface(iface="ic2.api.energy.tile.IEnergySink", modid="ic2")})
public abstract class APowerTile
extends APacketTile
implements ITickable,
IEnergyStorage,
IEnergyReceiver,
IEnergySink,
IDebuggable {
    public static final long MJToMicroMJ = 1000000L;
    public static final String NBT_STORED_ENERGY = "storedEnergy";
    public static final String NBT_MAX_STORED = "MAX_stored";
    public static final String NBT_MAX_RECEIVE = "MAX_receive";
    public static final String NBT_OUTPUT_ENERGY_INFO = "outputEnergyInfo";
    long all;
    long maxGot;
    long max;
    long got;
    private boolean ic2ok = false;
    public boolean bcLoaded;
    public final boolean ic2Loaded;
    private Object helper;
    protected final EnergyDebug debug = new EnergyDebug(this);
    public final DetailDataCollector collector = DetailDataCollector.getInstance(this);
    protected boolean outputEnergyInfo = true;
    private static final long EUtoMicroJ = 400000L;
    private static final long FEtoMicroJ = 100000L;

    public APowerTile() {
        this.bcLoaded = Loader.isModLoaded((String)"buildcraftlib");
        this.ic2Loaded = Loader.isModLoaded((String)"ic2");
        if (this.bcLoaded) {
            this.helper = MjReceiver.mjCapabilityHelper(this);
        }
        this.startListener.add(this.debug::start);
        this.finishListener.add(this.debug::finish);
        this.finishListener.add(this.collector::finish);
    }

    public void func_73660_a() {
        this.postLoadEvent();
        this.all += this.got;
        if (!this.func_145831_w().field_72995_K && this.isWorking()) {
            this.debug.getAndTick(this.got);
        }
        this.got = 0L;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.postUnLoadEvent();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && this.isWorking()) {
            this.finishWork();
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.postUnLoadEvent();
    }

    private void postLoadEvent() {
        if (!this.func_145831_w().field_72995_K && !this.ic2ok) {
            if (this.ic2Loaded) {
                try {
                    this.ic2load();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            this.ic2ok = true;
        }
    }

    private void postUnLoadEvent() {
        if (this.ic2ok && !this.func_145831_w().field_72995_K) {
            if (this.ic2Loaded) {
                try {
                    this.ic2unload();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            this.ic2ok = false;
        }
    }

    protected final BlockPos[] getNeighbors(EnumFacing facing) {
        return new BlockPos[]{this.field_174879_c.func_177972_a(facing), this.field_174879_c.func_177972_a(facing.func_176735_f()), this.field_174879_c.func_177972_a(facing.func_176746_e())};
    }

    public final boolean isOutputEnergyInfo() {
        return this.outputEnergyInfo;
    }

    public final void toggleOutputEnergyInfo() {
        this.outputEnergyInfo = !this.outputEnergyInfo;
    }

    protected abstract boolean isWorking();

    @Optional.Method(modid="ic2")
    private void ic2load() {
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
    }

    @Optional.Method(modid="ic2")
    private void ic2unload() {
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.setStoredEnergy(nbt.func_74763_f(NBT_STORED_ENERGY));
        this.configure(nbt.func_74763_f(NBT_MAX_RECEIVE), nbt.func_74763_f(NBT_MAX_STORED));
        this.outputEnergyInfo = !nbt.func_74764_b(NBT_OUTPUT_ENERGY_INFO) || nbt.func_74767_n(NBT_OUTPUT_ENERGY_INFO);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74772_a(NBT_STORED_ENERGY, this.all);
        nbt.func_74772_a(NBT_MAX_STORED, this.max);
        nbt.func_74772_a(NBT_MAX_RECEIVE, this.maxGot);
        nbt.func_74757_a(NBT_OUTPUT_ENERGY_INFO, this.outputEnergyInfo);
        return super.func_189515_b(nbt);
    }

    @Deprecated
    public final long useEnergy(long min, long amount, boolean real, EnergyUsage usage) {
        if (Config.content().noEnergy()) {
            this.debug.use(amount, !real, usage);
            return amount;
        }
        if (this.max < min) {
            if (real) {
                this.all = 0L;
                QuarryPlus.LOGGER.debug(String.format("%d energy requested for %s but it's over machine capacity.", new Object[]{min, usage}));
                this.debug.use(amount, false, usage);
            }
            return amount;
        }
        long res = 0L;
        if (this.all >= min) {
            if (this.all <= amount) {
                res = this.all;
                if (real) {
                    this.all = 0L;
                }
            } else {
                res = amount;
                if (real) {
                    this.all -= amount;
                }
            }
        }
        this.debug.use(res, !real, usage);
        return res;
    }

    final long getEnergy(long a2, boolean real) {
        if (Config.content().noEnergy()) {
            return 0L;
        }
        long ret = Math.min(Math.min(this.maxGot - this.got, this.max - this.all - this.got), a2);
        if (real) {
            this.got += ret;
        }
        return ret;
    }

    protected final void getEnergy(long a2, boolean real, boolean force) {
        if (!force) {
            this.getEnergy(a2, real);
            return;
        }
        long ret = Math.min(this.max - this.all - this.got, a2);
        if (real) {
            this.got += ret;
        }
    }

    public final long getStoredEnergy() {
        return this.all;
    }

    public final void setStoredEnergy(long all) {
        this.all = all;
    }

    public final long getMaxStored() {
        return this.max;
    }

    public final void configure(long maxReceive, long maxStored) {
        this.maxGot = maxReceive;
        this.max = maxStored;
        if (Config.content().noEnergy()) {
            this.all = maxStored;
        }
    }

    @Optional.Method(modid="ic2")
    public final double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
        double mj = amount * 400000.0;
        this.got = (long)((double)this.got + mj);
        return 0.0;
    }

    @Optional.Method(modid="ic2")
    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing side) {
        return this.canReceive();
    }

    @Optional.Method(modid="ic2")
    public final double getDemandedEnergy() {
        return (double)Math.min(this.maxGot - this.got, this.max - this.all - this.got) / 400000.0;
    }

    @Optional.Method(modid="ic2")
    public final int getSinkTier() {
        return 5;
    }

    @Optional.Method(modid="redstoneflux")
    public final int receiveEnergy(EnumFacing from2, int maxReceive, boolean simulate) {
        return this.receiveEnergy(maxReceive, simulate);
    }

    @Optional.Method(modid="redstoneflux")
    public final int getEnergyStored(EnumFacing from2) {
        return this.getEnergyStored();
    }

    @Optional.Method(modid="redstoneflux")
    public final int getMaxEnergyStored(EnumFacing from2) {
        return this.getMaxEnergyStored();
    }

    @Optional.Method(modid="redstoneflux")
    public final boolean canConnectEnergy(EnumFacing from2) {
        return this.canReceive();
    }

    public final int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        return (int)(this.getEnergy((long)maxReceive * 100000L, !simulate) / 100000L);
    }

    public final int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public final int getEnergyStored() {
        return (int)(this.all / 100000L);
    }

    public final int getMaxEnergyStored() {
        return (int)(this.max / 100000L);
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }

    @Override
    public void getDebugInfo(List<String> left, List<String> right, EnumFacing side) {
        left.add(((Object)((Object)this)).getClass().getName());
        left.add(ItemQuarryDebug.tilePosToString(this).func_150261_e());
        left.add(ItemQuarryDebug.energyToString(this).func_150261_e());
        if (this.isDebugSender) {
            IDebugSender sender = (IDebugSender)((Object)this);
            sender.getMessage().stream().map(ITextComponent::func_150261_e).forEach(left::add);
        }
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (this.bcLoaded && this.hasMJCapability(capability, facing)) {
            return true;
        }
        return capability == CapabilityEnergy.ENERGY || super.hasCapability(capability, facing);
    }

    @Optional.Method(modid="buildcraftlib")
    private boolean hasMJCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return ((MjCapabilityHelper)this.helper).hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        Object o;
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this);
        }
        if (this.bcLoaded && (o = this.getMjCapability(capability, facing)) != null) {
            return (T)o;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Optional.Method(modid="buildcraftlib")
    private <T> Object getMjCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return ((MjCapabilityHelper)this.helper).getCapability(capability, facing);
    }
}

