/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.tile;

import com.yogpc.qp.Config;
import com.yogpc.qp.PowerManager;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.QuarryPlusI;
import com.yogpc.qp.compat.FluidStore;
import com.yogpc.qp.tile.APowerTile;
import com.yogpc.qp.tile.HasStorage;
import com.yogpc.qp.tile.IModule;
import com.yogpc.qp.tile.IModule$Done$;
import com.yogpc.qp.tile.IModule$NoAction$;
import com.yogpc.qp.tile.IModule$NotFinished$;
import com.yogpc.qp.tile.IModule$TypeBeforeBreak$;
import com.yogpc.qp.tile.RangeWrapper;
import com.yogpc.qp.tile.TilePump;
import com.yogpc.qp.tile.TileQuarry;
import com.yogpc.qp.tile.TileQuarry2;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.IntSupplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import scala.collection.JavaConverters;

public abstract class PumpModule
implements IModule {
    public static final String ID = "quarryplus:module_pump";
    private static final scala.collection.immutable.Set<IModule.ModuleType> TYPE_SET;

    @Override
    public String id() {
        return ID;
    }

    @Override
    public final IModule.Result invoke(IModule.CalledWhen when) {
        if (this.calledWhen().apply((Object)when.moduleType())) {
            return this.action(when);
        }
        return IModule$NoAction$.MODULE$;
    }

    @Override
    public final scala.collection.immutable.Set<IModule.ModuleType> calledWhen() {
        return TYPE_SET;
    }

    public static PumpModule fromTile(TilePump pump2, APowerTile tile) {
        return new Tile(pump2, tile);
    }

    public static PumpModule fromModule(APowerTile connected, IntSupplier unbreaking) {
        return new Module(connected, unbreaking);
    }

    @Override
    public String toString() {
        String simpleName = this.getClass().getName();
        return simpleName.substring(simpleName.lastIndexOf(".") + 1);
    }

    static {
        Set collect = Stream.of(IModule$TypeBeforeBreak$.MODULE$).collect(Collectors.toSet());
        TYPE_SET = ((scala.collection.mutable.Set)JavaConverters.asScalaSetConverter(collect).asScala()).toSet();
    }

    private static class Module
    extends PumpModule {
        private final APowerTile tile;
        private World world;
        private final BlockPos pos;
        private final IntSupplier unbreaking;
        private static final int Y_SIZE = 256;
        private static final int CHUNK_SCALE = 16;
        private byte[][][] blocks;
        private ExtendedBlockStorage[][][] storageArray;
        private int xOffset;
        private int yOffset;
        private int zOffset;
        private int px;
        private int py = Integer.MIN_VALUE;
        private int cx;
        private int cy = -1;
        private int cz;
        private boolean quarryRange = true;
        private boolean autoChangedRange = false;
        private int block_side_x;
        private int block_side_z;
        private static final int ARRAY_MAX = 524288;
        private static final int[] xb = new int[524288];
        private static final int[] yb = new int[524288];
        private static final int[] zb = new int[524288];
        private static int cp = 0;
        private long fwt;

        public Module(APowerTile connected, IntSupplier unbreaking) {
            this.tile = connected;
            this.world = connected.func_145831_w();
            this.pos = connected.func_174877_v();
            this.unbreaking = unbreaking;
        }

        @Override
        public IModule.Result action(IModule.CalledWhen when) {
            if (when instanceof IModule.BeforeBreak) {
                IModule.BeforeBreak beforeBreak = (IModule.BeforeBreak)when;
                BlockPos target = beforeBreak.pos();
                IBlockState state = beforeBreak.world().func_180495_p(target);
                if (TilePump.isLiquid(state)) {
                    this.world = this.tile.func_145831_w();
                    if (this.S_removeLiquids(this.tile, target.func_177958_n(), target.func_177956_o(), target.func_177952_p())) {
                        return IModule$Done$.MODULE$;
                    }
                    return IModule$NotFinished$.MODULE$;
                }
            }
            return IModule$NoAction$.MODULE$;
        }

        private APowerTile G_connected() {
            return this.tile;
        }

        private static void S_put(int x, int y, int z) {
            Module.xb[Module.cp] = x;
            Module.yb[Module.cp] = y;
            Module.zb[Module.cp] = z;
            if (++cp == 524288) {
                cp = 0;
            }
        }

        private void S_searchLiquid(int x, int y, int z) {
            int chunk_side_z;
            int chunk_side_x;
            this.fwt = this.world.func_82737_E();
            int cg = 0;
            cp = 0;
            this.cx = x;
            this.cy = y;
            this.cz = z;
            this.yOffset = y & 0xFFFFFFF0;
            this.py = 255;
            this.px = -1;
            APowerTile tb = this.G_connected();
            RangeWrapper b2 = null;
            if (tb instanceof TileQuarry || tb instanceof TileQuarry2) {
                b2 = RangeWrapper.of((Object)tb);
            }
            int range = 0;
            if (b2 != null && b2.yMax != Integer.MIN_VALUE) {
                int z_add;
                chunk_side_x = 1 + (b2.xMax >> 4) - (b2.xMin >> 4);
                chunk_side_z = 1 + (b2.zMax >> 4) - (b2.zMin >> 4);
                this.xOffset = b2.xMin & 0xFFFFFFF0;
                this.zOffset = b2.zMin & 0xFFFFFFF0;
                int x_add = range * 2 + 1 - chunk_side_x;
                if (x_add > 0) {
                    chunk_side_x += x_add;
                    this.xOffset -= ((x_add & 0xFFFFFFFE) << 3) + (x_add % 2 != 0 && (b2.xMax + b2.xMin + 1) / 2 % 16 <= 8 ? 16 : 0);
                }
                if ((z_add = range * 2 + 1 - chunk_side_z) > 0) {
                    chunk_side_z += z_add;
                    this.zOffset -= ((z_add & 0xFFFFFFFE) << 3) + (z_add % 2 != 0 && (b2.zMax + b2.zMin + 1) / 2 % 16 <= 8 ? 16 : 0);
                }
            } else {
                this.quarryRange = false;
                chunk_side_x = chunk_side_z = 1 + range * 2;
                this.xOffset = (x >> 4) - range << 4;
                this.zOffset = (z >> 4) - range << 4;
            }
            if (!this.quarryRange) {
                b2 = null;
            }
            this.block_side_x = chunk_side_x * 16;
            this.block_side_z = chunk_side_z * 16;
            this.blocks = new byte[256 - this.yOffset][this.block_side_x][this.block_side_z];
            this.storageArray = new ExtendedBlockStorage[chunk_side_x][chunk_side_z][];
            for (int kx = 0; kx < chunk_side_x; ++kx) {
                for (int kz = 0; kz < chunk_side_z; ++kz) {
                    this.storageArray[kx][kz] = this.world.func_72863_F().func_186025_d(kx + (this.xOffset >> 4), kz + (this.zOffset >> 4)).func_76587_i();
                }
            }
            Module.S_put(x - this.xOffset, y, z - this.zOffset);
            while (cp != cg) {
                ExtendedBlockStorage ebs_c = this.storageArray[xb[cg] >> 4][zb[cg] >> 4][yb[cg] >> 4];
                if (ebs_c != null) {
                    IBlockState b_c = ebs_c.func_177485_a(xb[cg] & 0xF, yb[cg] & 0xF, zb[cg] & 0xF);
                    if (this.blocks[yb[cg] - this.yOffset][xb[cg]][zb[cg]] == 0 && TilePump.isLiquid(b_c)) {
                        this.blocks[Module.yb[cg] - this.yOffset][Module.xb[cg]][Module.zb[cg]] = 63;
                        if ((b2 != null ? b2.xMin & 0xF : 0) < xb[cg]) {
                            Module.S_put(xb[cg] - 1, yb[cg], zb[cg]);
                        } else {
                            this.blocks[Module.yb[cg] - this.yOffset][Module.xb[cg]][Module.zb[cg]] = 127;
                        }
                        if (xb[cg] < (b2 != null ? b2.xMax - this.xOffset : this.block_side_x - 1)) {
                            Module.S_put(xb[cg] + 1, yb[cg], zb[cg]);
                        } else {
                            this.blocks[Module.yb[cg] - this.yOffset][Module.xb[cg]][Module.zb[cg]] = 127;
                        }
                        if ((b2 != null ? b2.zMin & 0xF : 0) < zb[cg]) {
                            Module.S_put(xb[cg], yb[cg], zb[cg] - 1);
                        } else {
                            this.blocks[Module.yb[cg] - this.yOffset][Module.xb[cg]][Module.zb[cg]] = 127;
                        }
                        if (zb[cg] < (b2 != null ? b2.zMax - this.zOffset : this.block_side_z - 1)) {
                            Module.S_put(xb[cg], yb[cg], zb[cg] + 1);
                        } else {
                            this.blocks[Module.yb[cg] - this.yOffset][Module.xb[cg]][Module.zb[cg]] = 127;
                        }
                        if (yb[cg] + 1 < 256) {
                            Module.S_put(xb[cg], yb[cg] + 1, zb[cg]);
                        }
                    }
                }
                if (++cg != 524288) continue;
                cg = 0;
            }
        }

        public boolean S_removeLiquids(APowerTile tile, int x, int y, int z) {
            block18: {
                int bz;
                int bx;
                if (this.cx != x || this.cy != y || this.cz != z || this.py < this.cy || this.world.func_82737_E() - this.fwt > 200L) {
                    this.S_searchLiquid(x, y, z);
                } else {
                    this.storageArray = new ExtendedBlockStorage[this.storageArray.length][this.storageArray[0].length][];
                    for (int kx = 0; kx < this.storageArray.length; ++kx) {
                        for (int kz = 0; kz < this.storageArray[0].length; ++kz) {
                            this.storageArray[kx][kz] = this.world.func_72863_F().func_186025_d(kx + (this.xOffset >> 4), kz + (this.zOffset >> 4)).func_76587_i();
                        }
                    }
                }
                int count = 0;
                while (true) {
                    if (this.px == -1) {
                        for (bx = 0; bx < this.block_side_x; ++bx) {
                            for (bz = 0; bz < this.block_side_z; ++bz) {
                                IBlockState bb;
                                if ((this.blocks[this.py - this.yOffset][bx][bz] & 0x40) == 0 || !TilePump.isLiquid(bb = this.storageArray[bx >> 4][bz >> 4][this.py >> 4].func_177485_a(bx & 0xF, this.py & 0xF, bz & 0xF))) continue;
                                ++count;
                            }
                        }
                    } else {
                        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
                        for (bz = 0; bz < this.block_side_z; ++bz) {
                            if (this.blocks[this.py - this.yOffset][this.px][bz] == 0) continue;
                            IBlockState bb = this.storageArray[this.px >> 4][bz >> 4][this.py >> 4].func_177485_a(this.px & 0xF, this.py & 0xF, bz & 0xF);
                            mutableBlockPos.func_181079_c(this.px + this.xOffset, this.py, bz + this.zOffset);
                            if (!TilePump.isLiquid(bb, Config.content().removeOnlySource(), this.world, (BlockPos)mutableBlockPos)) continue;
                            ++count;
                        }
                    }
                    if (count <= 0 && ++this.px < this.block_side_x) continue;
                    if (count > 0) break;
                    this.px = -1;
                    if (--this.py < this.cy) break;
                }
                if (count <= 0 || !PowerManager.useEnergyPump(tile, this.unbreaking.getAsInt(), count, this.px == -1 ? (long)count : 0L)) break block18;
                if (this.px == -1) {
                    for (bx = 0; bx < this.block_side_x; ++bx) {
                        for (bz = 0; bz < this.block_side_z; ++bz) {
                            if ((this.blocks[this.py - this.yOffset][bx][bz] & 0x40) == 0) continue;
                            this.drainBlock(bx, bz, QuarryPlusI.blockFrame().getDammingState());
                            if (!(tile instanceof TileQuarry) && !(tile instanceof TileQuarry2)) continue;
                            RangeWrapper wrapper = RangeWrapper.of((Object)tile);
                            int xTarget = bx + this.xOffset;
                            int zTarget = bz + this.zOffset;
                            if (wrapper.waiting()) {
                                if (wrapper.xMin > xTarget || xTarget > wrapper.xMax || wrapper.zMin > zTarget || zTarget > wrapper.zMax) continue;
                                if (Config.content().debug()) {
                                    QuarryPlus.LOGGER.warn(String.format("Quarry placed frame at %d, %d, %d", xTarget, this.py, zTarget));
                                }
                                this.autoChange(true);
                                continue;
                            }
                            if (Config.content().debug() && wrapper.xMin < xTarget && xTarget < wrapper.xMax && wrapper.zMin < zTarget && zTarget < wrapper.zMax) {
                                QuarryPlus.LOGGER.warn(String.format("Quarry placed frame at %d, %d, %d", xTarget, this.py, zTarget));
                            }
                            this.autoChange(false);
                        }
                    }
                } else {
                    for (bz = 0; bz < this.block_side_z; ++bz) {
                        if (this.blocks[this.py - this.yOffset][this.px][bz] == 0) continue;
                        this.drainBlock(this.px, bz, Blocks.field_150350_a.func_176223_P());
                    }
                }
            }
            return this.py < this.cy;
        }

        private void autoChange(boolean on) {
            if (on) {
                this.autoChangedRange = true;
                this.quarryRange = false;
            } else if (this.autoChangedRange) {
                this.autoChangedRange = false;
                this.quarryRange = true;
            }
        }

        private void drainBlock(int bx, int bz, IBlockState tb) {
            if (TilePump.isLiquid(this.storageArray[bx >> 4][bz >> 4][this.py >> 4].func_177485_a(bx & 0xF, this.py & 0xF, bz & 0xF))) {
                BlockPos blockPos = new BlockPos(bx + this.xOffset, this.py, bz + this.zOffset);
                Optional.ofNullable(FluidUtil.getFluidHandler((World)this.world, (BlockPos)blockPos, (EnumFacing)EnumFacing.UP)).ifPresent(handler -> {
                    FluidStack stack = handler.drain(1000, true);
                    if (stack != null) {
                        if (this.tile instanceof HasStorage) {
                            HasStorage.Storage storage = ((HasStorage)((Object)this.tile)).getStorage();
                            storage.insertFluid(stack, 1000L);
                        } else {
                            FluidStore.injectToNearTile(this.world, this.pos, stack);
                        }
                    }
                    this.world.func_175656_a(blockPos, tb);
                });
            }
        }
    }

    private static class Tile
    extends PumpModule {
        private final TilePump pump;
        private final APowerTile tile;

        public Tile(TilePump pump2, APowerTile tile) {
            this.pump = Objects.requireNonNull(pump2);
            this.tile = Objects.requireNonNull(tile);
        }

        @Override
        public IModule.Result action(IModule.CalledWhen when) {
            if (when instanceof IModule.BeforeBreak) {
                IModule.BeforeBreak beforeBreak = (IModule.BeforeBreak)when;
                BlockPos target = beforeBreak.pos();
                IBlockState state = beforeBreak.world().func_180495_p(target);
                if (TilePump.isLiquid(state)) {
                    if (this.pump.S_removeLiquids(this.tile, target.func_177958_n(), target.func_177956_o(), target.func_177952_p())) {
                        return IModule$Done$.MODULE$;
                    }
                    return IModule$NotFinished$.MODULE$;
                }
            }
            return IModule$NoAction$.MODULE$;
        }
    }
}

