/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.tile;

import com.yogpc.qp.modules.IModuleItem;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import jp.t2v.lab.syntax.MapStreamSyntax;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.util.INBTSerializable;
import scala.Function1;
import scala.Unit;

public class QuarryModuleInventory
extends InventoryBasic
implements INBTSerializable<NBTTagCompound> {
    private final TileEntity tile;
    private final Consumer<QuarryModuleInventory> onUpdate;
    private final Predicate<IModuleItem> moduleFilter;

    public QuarryModuleInventory(ITextComponent title, int slotCount, TileEntity entity, Consumer<QuarryModuleInventory> onUpdate, Predicate<IModuleItem> moduleFilter) {
        super(title.func_150260_c(), true, slotCount);
        this.tile = Objects.requireNonNull(entity);
        this.onUpdate = Objects.requireNonNull(onUpdate);
        this.moduleFilter = moduleFilter;
    }

    public QuarryModuleInventory(ITextComponent title, int slotCount, TileEntity entity, Function1<QuarryModuleInventory, Unit> onUpdate, Predicate<IModuleItem> moduleFilter) {
        super(title.func_150260_c(), true, slotCount);
        this.tile = Objects.requireNonNull(entity);
        this.onUpdate = arg_0 -> onUpdate.apply(arg_0);
        this.moduleFilter = moduleFilter;
    }

    public List<Map.Entry<IModuleItem, ItemStack>> moduleItems() {
        return IntStream.range(0, this.func_70302_i_()).mapToObj(arg_0 -> ((QuarryModuleInventory)this).func_70301_a(arg_0)).filter(s -> !s.func_190926_b()).map(MapStreamSyntax.toEntry(ItemStack::func_77973_b, Function.identity())).filter(MapStreamSyntax.byKey(IModuleItem.class::isInstance)).map(MapStreamSyntax.keys(IModuleItem.class::cast)).filter(MapStreamSyntax.byKey(this.moduleFilter)).collect(Collectors.toList());
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (stack.func_77973_b() instanceof IModuleItem) {
            IModuleItem item = (IModuleItem)stack.func_77973_b();
            if (!this.moduleFilter.test(item)) {
                return false;
            }
            Predicate<Item> equal = Predicate.isEqual(item);
            Predicate<Item> id = item1 -> item1 instanceof IModuleItem && ((IModuleItem)item1).getSymbol().equals((Object)item.getSymbol());
            return IntStream.range(0, this.func_70302_i_()).mapToObj(arg_0 -> ((QuarryModuleInventory)this).func_70301_a(arg_0)).map(ItemStack::func_77973_b).noneMatch(equal.or(id));
        }
        return false;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return player.func_174818_b(this.tile.func_174877_v()) <= 64.0;
    }

    public int func_70297_j_() {
        return 1;
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.onUpdate.accept(this);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        NonNullList list = IntStream.range(0, this.func_70302_i_()).mapToObj(arg_0 -> ((QuarryModuleInventory)this).func_70301_a(arg_0)).collect(Collectors.toCollection(NonNullList::func_191196_a));
        ItemStackHelper.func_191282_a((NBTTagCompound)nbtTagCompound, (NonNullList)list);
        return nbtTagCompound;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        NonNullList list = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)nbt, (NonNullList)list);
        for (int i = 0; i < list.size(); ++i) {
            this.func_70299_a(i, (ItemStack)list.get(i));
        }
    }
}

