/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.tile;

import buildcraft.api.core.IAreaProvider;
import buildcraft.api.tiles.TilesAPI;
import com.yogpc.qp.Config;
import com.yogpc.qp.PowerManager;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.QuarryPlusI;
import com.yogpc.qp.block.BlockFrame;
import com.yogpc.qp.block.BlockQuarry;
import com.yogpc.qp.compat.InvUtils;
import com.yogpc.qp.packet.PacketHandler;
import com.yogpc.qp.packet.TileMessage;
import com.yogpc.qp.packet.quarry.ModeMessage;
import com.yogpc.qp.packet.quarry.MoveHead;
import com.yogpc.qp.tile.IAttachment;
import com.yogpc.qp.tile.IChunkLoadTile;
import com.yogpc.qp.tile.IDebugSender;
import com.yogpc.qp.tile.IMarker;
import com.yogpc.qp.tile.IModule;
import com.yogpc.qp.tile.TileBasic;
import com.yogpc.qp.tile.TilePump;
import com.yogpc.qp.tile.TileReplacer;
import com.yogpc.qp.version.VersionUtil;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import jp.t2v.lab.syntax.MapStreamSyntax;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.BooleanUtils;
import scala.Symbol;
import scala.collection.JavaConverters;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;

public class TileQuarry
extends TileBasic
implements IDebugSender,
IChunkLoadTile {
    public static final Symbol SYMBOL = Symbol.apply((String)"QuarryPlus");
    private int targetX;
    private int targetY;
    private int targetZ;
    public int xMin;
    public int xMax;
    public int yMin;
    public int yMax = Integer.MIN_VALUE;
    public int zMin;
    public int zMax;
    public boolean filler;
    @Nullable
    private Object areaProvider = null;
    private boolean addX = true;
    private boolean addZ = true;
    private boolean dug = true;
    private boolean changeZ = false;
    private ForgeChunkManager.Ticket chunkTicket;
    public double headPosX;
    public double headPosY;
    public double headPosZ;
    private boolean initialized = true;
    private Mode now = Mode.NONE;

    @Override
    protected Symbol getSymbol() {
        return SYMBOL;
    }

    protected void S_updateEntity() {
        if (this.machineDisabled) {
            return;
        }
        if (this.areaProvider != null) {
            if (this.areaProvider instanceof IMarker) {
                this.cacheItems.addAll(((IMarker)this.areaProvider).removeFromWorldWithItem());
            } else if (this.bcLoaded && this.areaProvider instanceof IAreaProvider) {
                ((IAreaProvider)this.areaProvider).removeFromWorld();
            }
            this.areaProvider = null;
        }
        boolean faster = Config.content().fastQuarryHeadMove();
        boolean broken = false;
        block7: for (int i = 0; i < this.efficiency + 1 && !broken; ++i) {
            if (!faster) {
                broken = true;
            }
            switch (this.now) {
                case MAKE_FRAME: {
                    if (this.S_makeFrame()) {
                        while (!this.S_checkTarget()) {
                            this.S_setNextTarget();
                        }
                    }
                    broken = true;
                    continue block7;
                }
                case MOVE_HEAD: {
                    boolean done = this.S_moveHead();
                    MoveHead.send(this);
                    if (!done) {
                        broken = true;
                        continue block7;
                    }
                    this.setNow(Mode.BREAK_BLOCK);
                    continue block7;
                }
                case NOT_NEED_BREAK: {
                    broken = !this.filler;
                }
                case BREAK_BLOCK: {
                    if (!this.S_breakBlock()) continue block7;
                    while (!this.S_checkTarget()) {
                        this.S_setNextTarget();
                    }
                    continue block7;
                }
                case NONE: {
                    broken = true;
                }
            }
        }
        this.S_pollItems();
    }

    private boolean S_checkTarget() {
        if (this.targetY > this.yMax) {
            this.targetY = this.yMax;
        }
        BlockPos target = new BlockPos(this.targetX, this.targetY, this.targetZ);
        Chunk loadedChunk = this.func_145831_w().func_72863_F().func_186026_b(this.targetX >> 4, this.targetZ >> 4);
        IBlockState b2 = loadedChunk != null ? loadedChunk.func_177435_g(target) : this.func_145831_w().func_180495_p(target);
        float blockHardness = b2.func_185887_b(this.func_145831_w(), target);
        switch (this.now) {
            case MOVE_HEAD: 
            case BREAK_BLOCK: {
                if (this.targetY < this.yLevel) {
                    this.G_destroy();
                    this.S_checkDropItem(new AxisAlignedBB((double)(this.xMin - 2), (double)(this.yLevel - 3), (double)(this.zMin - 2), (double)(this.xMax + 2), (double)(this.yLevel + 2), (double)(this.zMax + 2)));
                    PacketHandler.sendToAround(ModeMessage.create(this), this.func_145831_w(), this.func_174877_v());
                    return true;
                }
                return this.isBreakableBlock(target, b2, blockHardness);
            }
            case NOT_NEED_BREAK: {
                if (this.targetY < this.yMin) {
                    if (this.filler) {
                        this.G_destroy();
                        return true;
                    }
                    this.setNow(Mode.MAKE_FRAME);
                    this.G_renew_powerConfigure();
                    this.targetX = this.xMin;
                    this.targetY = this.yMax;
                    this.targetZ = this.zMin;
                    this.dug = true;
                    this.addZ = true;
                    this.addX = true;
                    this.changeZ = false;
                    return this.S_checkTarget();
                }
                if (!this.isBreakableBlock(target, b2, blockHardness)) {
                    return false;
                }
                if (b2.func_177230_c() == QuarryPlusI.blockFrame() && !((Boolean)b2.func_177229_b((IProperty)BlockFrame.DAMMING)).booleanValue()) {
                    return Stream.of(this.targetX == this.xMin || this.targetX == this.xMax, this.targetY == this.yMin || this.targetY == this.yMax, this.targetZ == this.zMin || this.targetZ == this.zMax).mapToInt(BooleanUtils::toInteger).sum() < 2;
                }
                return true;
            }
            case MAKE_FRAME: {
                if (this.targetY < this.yMin) {
                    this.setNow(Mode.MOVE_HEAD);
                    this.G_renew_powerConfigure();
                    this.targetX = this.xMin + 1;
                    this.targetY = this.yMin;
                    this.targetZ = this.zMin + 1;
                    this.dug = true;
                    this.addZ = true;
                    this.addX = true;
                    this.changeZ = false;
                    return this.S_checkTarget();
                }
                if (b2.func_185904_a().func_76220_a() && (b2.func_177230_c() != QuarryPlusI.blockFrame() || ((Boolean)b2.func_177229_b((IProperty)BlockFrame.DAMMING)).booleanValue())) {
                    this.setNow(Mode.NOT_NEED_BREAK);
                    this.G_renew_powerConfigure();
                    this.targetX = this.xMin;
                    this.targetZ = this.zMin;
                    this.targetY = this.yMax;
                    this.dug = true;
                    this.addZ = true;
                    this.addX = true;
                    this.changeZ = false;
                    return this.S_checkTarget();
                }
                int flag = 0;
                if (this.targetX == this.xMin || this.targetX == this.xMax) {
                    flag = (byte)(flag + 1);
                }
                if (this.targetY == this.yMin || this.targetY == this.yMax) {
                    flag = (byte)(flag + 1);
                }
                if (this.targetZ == this.zMin || this.targetZ == this.zMax) {
                    flag = (byte)(flag + 1);
                }
                return flag > 1 && (b2.func_177230_c() != QuarryPlusI.blockFrame() || (Boolean)b2.func_177229_b((IProperty)BlockFrame.DAMMING) != false);
            }
        }
        return true;
    }

    private boolean isBreakableBlock(BlockPos target, IBlockState b2, float blockHardness) {
        return !(!(blockHardness >= 0.0f) || b2.func_177230_c().isAir(b2, (IBlockAccess)this.func_145831_w(), target) || this.now != Mode.NOT_NEED_BREAK && this.facingMap.containsKey(IAttachment.Attachments.REPLACER) && b2 == this.S_getFillBlock() || !this.facingMap.containsKey(IAttachment.Attachments.FLUID_PUMP) && TilePump.isLiquid(b2));
    }

    private void S_setNextTarget() {
        if (this.now == Mode.MAKE_FRAME) {
            if (this.changeZ) {
                this.targetZ = this.addZ ? ++this.targetZ : --this.targetZ;
            } else {
                this.targetX = this.addX ? ++this.targetX : --this.targetX;
            }
            if (this.targetX < this.xMin || this.xMax < this.targetX) {
                this.addX = !this.addX;
                this.changeZ = true;
                this.targetX = Math.max(this.xMin, Math.min(this.xMax, this.targetX));
            }
            if (this.targetZ < this.zMin || this.zMax < this.targetZ) {
                this.addZ = !this.addZ;
                this.changeZ = false;
                this.targetZ = Math.max(this.zMin, Math.min(this.zMax, this.targetZ));
            }
            if (this.xMin == this.targetX && this.zMin == this.targetZ) {
                if (this.dug) {
                    this.dug = false;
                } else {
                    --this.targetY;
                }
            }
        } else {
            int out;
            this.targetX = this.addX ? ++this.targetX : --this.targetX;
            int n = out = this.now == Mode.NOT_NEED_BREAK ? 0 : 1;
            if (this.targetX < this.xMin + out || this.xMax - out < this.targetX) {
                this.addX = !this.addX;
                this.targetX = Math.max(this.xMin + out, Math.min(this.targetX, this.xMax - out));
                this.targetZ = this.addZ ? ++this.targetZ : --this.targetZ;
                if (this.targetZ < this.zMin + out || this.zMax - out < this.targetZ) {
                    this.addZ = !this.addZ;
                    this.targetZ = Math.max(this.zMin + out, Math.min(this.targetZ, this.zMax - out));
                    if (this.dug) {
                        this.dug = false;
                    } else {
                        double dd;
                        double da;
                        double ad;
                        --this.targetY;
                        double aa = this.S_getDistance(this.xMin + 1, this.targetY, this.zMin + out);
                        double res = Math.min(aa, Math.min(ad = this.S_getDistance(this.xMin + 1, this.targetY, this.zMax - out), Math.min(da = this.S_getDistance(this.xMax - 1, this.targetY, this.zMin + out), dd = this.S_getDistance(this.xMax - 1, this.targetY, this.zMax - out))));
                        if (res == aa) {
                            this.addX = true;
                            this.addZ = true;
                            this.targetX = this.xMin + out;
                            this.targetZ = this.zMin + out;
                        } else if (res == ad) {
                            this.addX = true;
                            this.addZ = false;
                            this.targetX = this.xMin + out;
                            this.targetZ = this.zMax - out;
                        } else if (res == da) {
                            this.addX = false;
                            this.addZ = true;
                            this.targetX = this.xMax - out;
                            this.targetZ = this.zMin + out;
                        } else if (res == dd) {
                            this.addX = false;
                            this.addZ = false;
                            this.targetX = this.xMax - out;
                            this.targetZ = this.zMax - out;
                        }
                    }
                }
            }
        }
    }

    private double S_getDistance(int x, int y, int z) {
        return Math.sqrt(Math.pow((double)x - this.headPosX, 2.0) + Math.pow((double)(y + 1) - this.headPosY, 2.0) + Math.pow((double)z - this.headPosZ, 2.0));
    }

    private boolean S_makeFrame() {
        this.dug = true;
        if (!PowerManager.useEnergyFrameBuild(this, this.unbreaking)) {
            return false;
        }
        this.func_145831_w().func_175656_a(new BlockPos(this.targetX, this.targetY, this.targetZ), QuarryPlusI.blockFrame().func_176223_P());
        this.S_setNextTarget();
        return true;
    }

    private boolean S_breakBlock() {
        this.dug = true;
        if (this.S_breakBlock(this.targetX, this.targetY, this.targetZ, this.S_getFillBlock())) {
            this.S_checkDropItem(new AxisAlignedBB((double)(this.targetX - 4), (double)(this.targetY - 4), (double)(this.targetZ - 4), (double)(this.targetX + 5), (double)(this.targetY + 3), (double)(this.targetZ + 5)));
            if (this.now == Mode.BREAK_BLOCK) {
                this.setNow(Mode.MOVE_HEAD);
            }
            this.S_setNextTarget();
            return true;
        }
        return false;
    }

    private void S_checkDropItem(AxisAlignedBB axis) {
        java.util.List result = this.func_145831_w().func_72872_a(EntityItem.class, axis);
        result.stream().filter(Entity::func_70089_S).map(EntityItem::func_92059_d).filter(VersionUtil::nonEmpty).forEach(this.cacheItems::add);
        result.forEach(QuarryPlus.proxy::removeEntity);
        if (this.facingMap.containsKey(IAttachment.Attachments.EXP_PUMP)) {
            java.util.List xpOrbs = this.field_145850_b.func_72872_a(Entity.class, axis);
            this.modules.forEach(iModule -> iModule.invoke(new IModule.CollectingItem((List<Entity>)((Buffer)JavaConverters.asScalaBufferConverter((java.util.List)xpOrbs).asScala()).toList())));
        }
    }

    private void S_createBox() {
        Optional<IMarker> marker;
        if (this.yMax != Integer.MIN_VALUE) {
            return;
        }
        EnumFacing facing = ((EnumFacing)this.func_145831_w().func_180495_p(this.func_174877_v()).func_177229_b((IProperty)BlockQuarry.FACING)).func_176734_d();
        if (this.bcLoaded) {
            marker = Stream.of(this.getNeighbors(facing)).map(arg_0 -> ((World)this.func_145831_w()).func_175625_s(arg_0)).filter(Objects::nonNull).flatMap(t -> Stream.concat(MapStreamSyntax.streamCast(IAreaProvider.class).apply(t), Stream.of(t.getCapability(TilesAPI.CAP_TILE_AREA_PROVIDER, null)))).filter(nonNull).findFirst();
            if (marker.isPresent()) {
                IAreaProvider provider = (IAreaProvider)marker.get();
                if (provider.min().func_177958_n() == provider.max().func_177958_n() || provider.min().func_177952_p() == provider.max().func_177952_p()) {
                    this.setDefaultRange(this.func_174877_v(), facing);
                } else {
                    this.xMin = provider.min().func_177958_n();
                    this.yMin = provider.min().func_177956_o();
                    this.zMin = provider.min().func_177952_p();
                    this.xMax = provider.max().func_177958_n();
                    this.yMax = provider.max().func_177956_o();
                    this.zMax = provider.max().func_177952_p();
                    if (this.func_174877_v().func_177958_n() >= this.xMin && this.func_174877_v().func_177958_n() <= this.xMax && this.func_174877_v().func_177956_o() >= this.yMin && this.func_174877_v().func_177956_o() <= this.yMax && this.func_174877_v().func_177952_p() >= this.zMin && this.func_174877_v().func_177952_p() <= this.zMax) {
                        this.yMax = Integer.MIN_VALUE;
                        this.setDefaultRange(this.func_174877_v(), facing);
                        return;
                    }
                    if (this.xMax - this.xMin < 2 || this.zMax - this.zMin < 2) {
                        this.yMax = Integer.MIN_VALUE;
                        this.setDefaultRange(this.func_174877_v(), facing);
                        return;
                    }
                    if (this.yMax - this.yMin < 2) {
                        this.yMax = this.yMin + 3;
                    }
                    this.areaProvider = provider;
                }
                return;
            }
        }
        if ((marker = Stream.of(this.getNeighbors(facing)).map(arg_0 -> ((World)this.func_145831_w()).func_175625_s(arg_0)).flatMap(MapStreamSyntax.streamCast(IMarker.class)).filter(IMarker::hasLink).findFirst()).isPresent()) {
            IMarker iMarker = marker.get();
            this.xMin = iMarker.min().func_177958_n();
            this.yMin = iMarker.min().func_177956_o();
            this.zMin = iMarker.min().func_177952_p();
            this.xMax = iMarker.max().func_177958_n();
            this.yMax = iMarker.max().func_177956_o();
            this.zMax = iMarker.max().func_177952_p();
            if (this.func_174877_v().func_177958_n() >= this.xMin && this.func_174877_v().func_177958_n() <= this.xMax && this.func_174877_v().func_177956_o() >= this.yMin && this.func_174877_v().func_177956_o() <= this.yMax && this.func_174877_v().func_177952_p() >= this.zMin && this.func_174877_v().func_177952_p() <= this.zMax) {
                this.yMax = Integer.MIN_VALUE;
                this.setDefaultRange(this.func_174877_v(), facing);
                return;
            }
            if (this.xMax - this.xMin < 2 || this.zMax - this.zMin < 2) {
                this.yMax = Integer.MIN_VALUE;
                this.setDefaultRange(this.func_174877_v(), facing);
                return;
            }
            if (this.yMax - this.yMin < 2) {
                this.yMax = this.yMin + 3;
            }
            this.areaProvider = iMarker;
        } else {
            this.setDefaultRange(this.func_174877_v(), facing);
        }
    }

    protected IBlockState S_getFillBlock() {
        if (this.now == Mode.NOT_NEED_BREAK || !this.facingMap.containsKey(IAttachment.Attachments.REPLACER)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return Optional.ofNullable(this.facingMap.get(IAttachment.Attachments.REPLACER)).map(arg_0 -> ((BlockPos)this.field_174879_c).func_177972_a(arg_0)).map(arg_0 -> ((World)this.field_145850_b).func_175625_s(arg_0)).flatMap(IAttachment.Attachments.REPLACER).map(TileReplacer::getReplaceState).orElse(Blocks.field_150350_a.func_176223_P());
    }

    public void setDefaultRange(BlockPos pos, EnumFacing facing) {
        int x = 11;
        int y = 5;
        pos = pos.func_177972_a(facing);
        BlockPos pos1 = pos.func_177972_a(facing);
        BlockPos pos2 = pos.func_177967_a(facing, 11);
        BlockPos pos3 = pos.func_177967_a(facing.func_176746_e(), 5);
        BlockPos pos4 = pos.func_177967_a(facing.func_176735_f(), 5);
        if (facing.func_176740_k() == EnumFacing.Axis.X) {
            this.xMin = Math.min(pos1.func_177958_n(), pos2.func_177958_n());
            this.xMax = Math.max(pos1.func_177958_n(), pos2.func_177958_n());
            this.zMin = Math.min(pos3.func_177952_p(), pos4.func_177952_p());
            this.zMax = Math.max(pos3.func_177952_p(), pos4.func_177952_p());
        } else if (facing.func_176740_k() == EnumFacing.Axis.Z) {
            this.xMin = Math.min(pos3.func_177958_n(), pos4.func_177958_n());
            this.xMax = Math.max(pos3.func_177958_n(), pos4.func_177958_n());
            this.zMin = Math.min(pos1.func_177952_p(), pos2.func_177952_p());
            this.zMax = Math.max(pos1.func_177952_p(), pos2.func_177952_p());
        }
        this.yMin = this.func_174877_v().func_177956_o();
        this.yMax = this.func_174877_v().func_177956_o() + 3;
    }

    private void S_setFirstPos() {
        this.targetX = this.xMin;
        this.targetZ = this.zMin;
        this.targetY = this.yMax;
        this.headPosX = this.xMin + this.xMax + 1 >> 1;
        this.headPosZ = this.zMin + this.zMax + 1 >> 1;
        this.headPosY = this.yMax - 1;
    }

    private boolean S_moveHead() {
        double x = (double)this.targetX - this.headPosX;
        double y = (double)(this.targetY + 1) - this.headPosY;
        double z = (double)this.targetZ - this.headPosZ;
        double distance = Math.sqrt(x * x + y * y + z * z);
        double blocks = PowerManager.useEnergyQuarryHead(this, distance, this.unbreaking);
        if (blocks * 2.0 >= distance) {
            this.headPosX = this.targetX;
            this.headPosY = this.targetY + 1;
            this.headPosZ = this.targetZ;
            return true;
        }
        if (blocks > 0.0) {
            this.headPosX += x * blocks / distance;
            this.headPosY += y * blocks / distance;
            this.headPosZ += z * blocks / distance;
        }
        return false;
    }

    public Mode G_getNow() {
        return this.now;
    }

    public void setNow(Mode now) {
        this.now = now;
        if (!this.func_145831_w().field_72995_K) {
            PacketHandler.sendToAround(ModeMessage.create(this), this.func_145831_w(), this.func_174877_v());
            IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
            if ((Boolean)state.func_177229_b((IProperty)BlockQuarry.ACTING) ^ this.isWorking()) {
                InvUtils.setNewState(this.func_145831_w(), this.func_174877_v(), this, state.func_177226_a((IProperty)BlockQuarry.ACTING, (Comparable)Boolean.valueOf(this.isWorking())));
                if (this.isWorking()) {
                    this.startWork();
                } else {
                    this.finishWork();
                }
            }
        }
    }

    public BlockPos getMinPos() {
        return new BlockPos(this.xMin, this.yMin, this.zMin);
    }

    public BlockPos getMaxPos() {
        return new BlockPos(this.xMax, this.yMax, this.zMax);
    }

    @Override
    protected void G_destroy() {
        this.setNow(Mode.NONE);
        this.G_renew_powerConfigure();
        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.chunkTicket);
    }

    @Override
    public void G_ReInit() {
        if (this.yMax == Integer.MIN_VALUE && !this.func_145831_w().field_72995_K) {
            this.S_createBox();
        }
        this.setNow(Mode.NOT_NEED_BREAK);
        this.G_renew_powerConfigure();
        if (!this.func_145831_w().field_72995_K) {
            this.S_setFirstPos();
            PacketHandler.sendToAround(TileMessage.create(this), this.func_145831_w(), this.func_174877_v());
        }
    }

    @Override
    public void requestTicket() {
        if (this.chunkTicket != null) {
            return;
        }
        this.chunkTicket = ForgeChunkManager.requestTicket((Object)QuarryPlus.INSTANCE, (World)this.func_145831_w(), (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        this.setTileData(this.chunkTicket, this.func_174877_v());
    }

    @Override
    public void forceChunkLoading(ForgeChunkManager.Ticket ticket) {
        if (this.chunkTicket == null) {
            this.chunkTicket = ticket;
        }
        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)new ChunkPos(this.func_174877_v()));
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.initialized) {
            this.G_renew_powerConfigure();
            this.initialized = true;
        }
        if (!this.func_145831_w().field_72995_K) {
            this.S_updateEntity();
        }
    }

    @Override
    protected boolean isWorking() {
        return this.now != Mode.NONE;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.xMin = nbt.func_74762_e("xMin");
        this.xMax = nbt.func_74762_e("xMax");
        this.yMin = nbt.func_74762_e("yMin");
        this.zMin = nbt.func_74762_e("zMin");
        this.zMax = nbt.func_74762_e("zMax");
        this.yMax = nbt.func_74762_e("yMax");
        this.targetX = nbt.func_74762_e("targetX");
        this.targetY = nbt.func_74762_e("targetY");
        this.targetZ = nbt.func_74762_e("targetZ");
        this.addZ = nbt.func_74767_n("addZ");
        this.addX = nbt.func_74767_n("addX");
        this.dug = nbt.func_74767_n("dug");
        this.changeZ = nbt.func_74767_n("changeZ");
        this.now = Mode.values()[nbt.func_74771_c("now")];
        this.headPosX = nbt.func_74769_h("headPosX");
        this.headPosY = nbt.func_74769_h("headPosY");
        this.headPosZ = nbt.func_74769_h("headPosZ");
        this.filler = nbt.func_74767_n("filler");
        this.initialized = false;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74768_a("xMin", this.xMin);
        nbt.func_74768_a("xMax", this.xMax);
        nbt.func_74768_a("yMin", this.yMin);
        nbt.func_74768_a("yMax", this.yMax);
        nbt.func_74768_a("zMin", this.zMin);
        nbt.func_74768_a("zMax", this.zMax);
        nbt.func_74768_a("targetX", this.targetX);
        nbt.func_74768_a("targetY", this.targetY);
        nbt.func_74768_a("targetZ", this.targetZ);
        nbt.func_74757_a("addZ", this.addZ);
        nbt.func_74757_a("addX", this.addX);
        nbt.func_74757_a("dug", this.dug);
        nbt.func_74757_a("changeZ", this.changeZ);
        nbt.func_74774_a("now", (byte)this.now.ordinal());
        nbt.func_74780_a("headPosX", this.headPosX);
        nbt.func_74780_a("headPosY", this.headPosY);
        nbt.func_74780_a("headPosZ", this.headPosZ);
        nbt.func_74757_a("filler", this.filler);
        return super.func_189515_b(nbt);
    }

    @Override
    public String getDebugName() {
        return "tile.quarryplus.name";
    }

    @Override
    public String func_70005_c_() {
        return this.getDebugName();
    }

    @Override
    public void G_renew_powerConfigure() {
        int pmp = 0;
        if (this.func_145830_o()) {
            Map map2 = this.facingMap.entrySet().stream().filter(MapStreamSyntax.byEntry((attachments, facing) -> attachments.test(this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(facing))))).collect(MapStreamSyntax.entryToMap());
            this.facingMap.putAll(map2);
            pmp = Optional.ofNullable(this.facingMap.get(IAttachment.Attachments.FLUID_PUMP)).map(arg_0 -> ((BlockPos)this.func_174877_v()).func_177972_a(arg_0)).map(arg_0 -> ((World)this.func_145831_w()).func_175625_s(arg_0)).flatMap(IAttachment.Attachments.FLUID_PUMP).map(p -> p.unbreaking).orElse((byte)0).byteValue();
        }
        if (this.now == Mode.NONE) {
            PowerManager.configure0(this);
        } else if (this.now == Mode.MAKE_FRAME) {
            PowerManager.configureFrameBuild(this, this.efficiency, this.unbreaking, pmp);
        } else {
            PowerManager.configureQuarryWork(this, this.efficiency, this.unbreaking, pmp);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.yMax == Integer.MIN_VALUE) {
            return new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), Double.NEGATIVE_INFINITY, (double)this.func_174877_v().func_177952_p(), (double)(this.func_174877_v().func_177958_n() + 1), (double)(this.func_174877_v().func_177956_o() + 1), (double)(this.func_174877_v().func_177952_p() + 1));
        }
        double xn = (double)this.xMin + 0.46875;
        double xx = (double)this.xMax + 0.53125;
        double yx = (double)this.yMax + 0.75;
        double zn = (double)this.zMin + 0.46875;
        double zx = (double)this.zMax + 0.53125;
        double x1 = xn < (double)this.func_174877_v().func_177958_n() ? xn : (double)this.func_174877_v().func_177958_n();
        double x2 = xx > (double)(this.func_174877_v().func_177958_n() + 1) ? xx : (double)(this.func_174877_v().func_177958_n() + 1);
        double y2 = (double)(this.func_174877_v().func_177956_o() + 1) < yx ? yx : (double)(this.func_174877_v().func_177956_o() + 1);
        double z1 = zn < (double)this.func_174877_v().func_177952_p() ? zn : (double)this.func_174877_v().func_177952_p();
        double z2 = zx > (double)(this.func_174877_v().func_177952_p() + 1) ? zx : (double)(this.func_174877_v().func_177952_p() + 1);
        return new AxisAlignedBB(x1, Double.NEGATIVE_INFINITY, z1, x2, y2, z2);
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        if ((this.now == Mode.NOT_NEED_BREAK || this.now == Mode.MAKE_FRAME) && this.yMax != Integer.MIN_VALUE) {
            return (this.xMax - this.xMin) * (this.xMax - this.xMin) + 25 + (this.zMax - this.zMin) * (this.zMax - this.zMin);
        }
        if (this.now == Mode.BREAK_BLOCK || this.now == Mode.MOVE_HEAD) {
            return (this.xMax - this.xMin) * (this.xMax - this.xMin) + this.yMax * this.yMax + (this.zMax - this.zMin) * (this.zMax - this.zMin);
        }
        return super.func_145833_n();
    }

    public boolean hasFastRenderer() {
        return true;
    }

    public java.util.List<ITextComponent> getDebugMessages() {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        list.add((ITextComponent)new TextComponentTranslation("chat.currentmode", new Object[]{this.G_getNow()}));
        list.add((ITextComponent)new TextComponentString(String.format("Next target : (%d, %d, %d)", this.targetX, this.targetY, this.targetZ)));
        list.add((ITextComponent)new TextComponentString(String.format("Head Pos : (%s, %s, %s)", this.headPosX, this.headPosY, this.headPosZ)));
        list.add((ITextComponent)new TextComponentString("X : " + this.xMin + " to " + this.xMax));
        list.add((ITextComponent)new TextComponentString("Z : " + this.zMin + " to " + this.zMax));
        list.add((ITextComponent)new TextComponentTranslation(this.filler ? "chat.fillermode" : "chat.quarrymode", new Object[0]));
        list.add((ITextComponent)new TextComponentTranslation("chat.ylevel", new Object[]{this.yLevel}));
        return list;
    }

    public static enum Mode {
        NONE,
        NOT_NEED_BREAK,
        MAKE_FRAME,
        MOVE_HEAD,
        BREAK_BLOCK;

    }
}

