/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.tile;

import cofh.api.tileentity.IInventoryConnection;
import com.yogpc.qp.Config;
import com.yogpc.qp.PowerManager;
import com.yogpc.qp.compat.InvUtils;
import com.yogpc.qp.tile.APowerTile;
import com.yogpc.qp.tile.EnergyUsage;
import com.yogpc.qp.tile.HasInv;
import com.yogpc.qp.tile.IDebugSender;
import com.yogpc.qp.tile.WorkbenchRecipes;
import com.yogpc.qp.utils.IngredientWithCount;
import com.yogpc.qp.version.VersionUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import scala.Symbol;

@Optional.Interface(iface="cofh.api.tileentity.IInventoryConnection", modid="cofhcore")
public class TileWorkbench
extends APowerTile
implements HasInv,
IDebugSender,
IInventoryConnection {
    public final NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)27, (Object)VersionUtil.empty());
    public final NonNullList<ItemStack> inventory2 = NonNullList.func_191197_a((int)18, (Object)VersionUtil.empty());
    public List<WorkbenchRecipes> recipesList = Collections.emptyList();
    private WorkbenchRecipes currentRecipe = WorkbenchRecipes.dummyRecipe();
    private final ItemHandler itemHandler = new ItemHandler();
    public boolean workContinue;

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.func_145831_w().field_72995_K && this.isWorking()) {
            if (this.currentRecipe.microEnergy() <= this.getStoredEnergy()) {
                PowerManager.useEnergy(this, this.currentRecipe.microEnergy(), EnergyUsage.WORKBENCH);
                if (Config.content().noEnergy()) {
                    this.setStoredEnergy(0L);
                }
                ItemStack stack = this.currentRecipe.getOutput((List<ItemStack>)this.inventory);
                ItemStack inserted = InvUtils.injectToNearTile(this.func_145831_w(), this.func_174877_v(), stack);
                if (VersionUtil.nonEmpty(inserted)) {
                    InventoryHelper.func_180173_a((World)this.func_145831_w(), (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (ItemStack)stack);
                }
                this.currentRecipe.inputsJ().forEach(inputList -> {
                    for (IngredientWithCount i : inputList) {
                        if (!this.inventory.stream().anyMatch(i::shrink)) continue;
                        break;
                    }
                });
                for (int i = 0; i < this.inventory.size(); ++i) {
                    if (!VersionUtil.isEmpty((ItemStack)this.inventory.get(i))) continue;
                    this.inventory.set(i, (Object)VersionUtil.empty());
                }
                this.func_70296_d();
                this.setCurrentRecipeIndex(this.workContinue ? this.getRecipeIndex() : -1);
            } else if (Config.content().noEnergy()) {
                this.getEnergy(this.currentRecipe.microEnergy() / 200L, true, true);
            }
        }
    }

    @Override
    public boolean isWorking() {
        return !this.machineDisabled && this.currentRecipe.hasContent();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("Items", 10);
        VersionUtil.nbtListStream(list).forEach(nbtTagCompound -> {
            int j = nbtTagCompound.func_74771_c("Slot") & 0xFF;
            ItemStack stack = VersionUtil.fromNBTTag(nbtTagCompound);
            this.inventory.set(j, (Object)stack);
        });
        this.func_70296_d();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.inventory.size(); ++i) {
            ItemStack stack = (ItemStack)this.inventory.get(i);
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(nbttagcompound);
            nbttagcompound.func_82580_o("Count");
            nbttagcompound.func_74768_a("Count", VersionUtil.getCount(stack));
            list.func_74742_a((NBTBase)nbttagcompound);
        }
        nbt.func_74782_a("Items", (NBTBase)list);
        return super.func_189515_b(nbt);
    }

    @Override
    public int func_70302_i_() {
        return this.inventory.size() + this.inventory2.size();
    }

    @Override
    public boolean func_191420_l() {
        return this.inventory.stream().allMatch(VersionUtil::isEmpty);
    }

    @Override
    public ItemStack func_70301_a(int index) {
        if (this.inventory.size() <= index && index < this.func_70302_i_()) {
            return (ItemStack)this.inventory2.get(index - this.inventory.size());
        }
        return (ItemStack)this.inventory.get(index);
    }

    @Override
    public ItemStack func_70298_a(int index, int count) {
        if (this.inventory.size() <= index && index < this.func_70302_i_()) {
            return ItemStackHelper.func_188382_a(this.inventory2, (int)(index - this.inventory.size()), (int)count);
        }
        return ItemStackHelper.func_188382_a(this.inventory, (int)index, (int)count);
    }

    @Override
    public ItemStack func_70304_b(int index) {
        if (this.inventory.size() <= index && index < this.func_70302_i_()) {
            return ItemStackHelper.func_188383_a(this.inventory2, (int)(index - this.inventory.size()));
        }
        return ItemStackHelper.func_188383_a(this.inventory, (int)index);
    }

    @Override
    public void func_70299_a(int index, ItemStack stack) {
        if (this.inventory.size() <= index && index < this.func_70302_i_()) {
            this.inventory2.set(index - this.inventory.size(), (Object)stack);
        } else {
            this.inventory.set(index, (Object)stack);
        }
    }

    @Override
    public int func_70297_j_() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean func_70300_a(EntityPlayer player) {
        return this.func_145831_w().func_175625_s(this.func_174877_v()) == this && player.func_174831_c(this.func_174877_v()) <= 64.0;
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.recipesList = WorkbenchRecipes.getRecipe(this.inventory);
        this.inventory2.clear();
        for (int i = 0; i < this.recipesList.size(); ++i) {
            this.func_70299_a(this.inventory.size() + i, this.recipesList.get(i).getOutput());
        }
        if (this.getRecipeIndex() == -1) {
            this.setCurrentRecipeIndex(-1);
        } else {
            this.startWork();
        }
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    @Override
    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.getRecipeIndex();
            }
            case 1: {
                return 0;
            }
            case 2: {
                return this.workContinue ? 1 : 0;
            }
        }
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.setCurrentRecipeIndex(value);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.workContinue = value == 1;
            }
        }
    }

    @Override
    public int func_174890_g() {
        return 3;
    }

    @Override
    public void func_174888_l() {
        this.inventory.clear();
    }

    public List<TextComponentString> getDebugMessages() {
        return Arrays.asList(new TextComponentString(this.currentRecipe.toString()), new TextComponentString("Work mode : " + (this.workContinue ? "Continue" : "Only once")));
    }

    @Override
    public String getDebugName() {
        return "tile.workbenchplus.name";
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.itemHandler);
        }
        return super.getCapability(capability, facing);
    }

    public void setCurrentRecipeIndex(int recipeIndex) {
        this.currentRecipe = recipeIndex >= 0 && this.recipesList.size() > recipeIndex ? this.recipesList.get(recipeIndex) : WorkbenchRecipes.dummyRecipe();
        this.configure((long)Config.content().workbenchMaxReceive() * 1000000L, this.currentRecipe.microEnergy());
        if (Config.content().noEnergy()) {
            this.setStoredEnergy(0L);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getProgressScaled(int scale) {
        if (this.isWorking()) {
            return (int)(this.getStoredEnergy() * (long)scale / this.currentRecipe.microEnergy());
        }
        return 0;
    }

    public int getRecipeIndex() {
        return this.recipesList.indexOf(this.currentRecipe);
    }

    @Optional.Method(modid="cofhcore")
    public IInventoryConnection.ConnectionType canConnectInventory(EnumFacing from2) {
        return IInventoryConnection.ConnectionType.FORCE;
    }

    public String func_70005_c_() {
        return this.getDebugName();
    }

    @Override
    protected Symbol getSymbol() {
        return Symbol.apply((String)"WorkbenchPlus");
    }

    private class ItemHandler
    implements IItemHandlerModifiable {
        private ItemHandler() {
        }

        public void setStackInSlot(int slot, ItemStack stack) {
            TileWorkbench.this.func_70299_a(slot, stack);
        }

        public int getSlots() {
            return TileWorkbench.this.inventory.size();
        }

        public ItemStack getStackInSlot(int slot) {
            return TileWorkbench.this.func_70301_a(slot);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (VersionUtil.isEmpty(stack)) {
                return VersionUtil.empty();
            }
            ItemStack inSlot = this.getStackInSlot(slot).func_77946_l();
            if (VersionUtil.nonEmpty(inSlot)) {
                if (ItemHandlerHelper.canItemStacksStack((ItemStack)inSlot, (ItemStack)stack)) {
                    if (!simulate) {
                        VersionUtil.grow(inSlot, VersionUtil.getCount(stack));
                        this.setStackInSlot(slot, inSlot);
                        TileWorkbench.this.func_70296_d();
                    }
                    return VersionUtil.empty();
                }
                return stack;
            }
            if (!simulate) {
                this.setStackInSlot(slot, stack.func_77946_l());
                TileWorkbench.this.func_70296_d();
            }
            return VersionUtil.empty();
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return VersionUtil.empty();
        }

        public int getSlotLimit(int slot) {
            return TileWorkbench.this.func_70297_j_();
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return TileWorkbench.this.func_94041_b(slot, stack);
        }
    }
}

