/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.utils;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;

public class LoopList<T> {
    private List<T> values = Collections.emptyList();
    private int size = 0;

    public T get(int index) {
        if (this.size == 0) {
            return null;
        }
        return this.values.get(this.getRealIndex(index));
    }

    public Optional<T> getOptional(int index) {
        return Optional.ofNullable(this.get(index));
    }

    public void setList(@Nonnull List<T> list) {
        this.values = list;
        this.size = list.size();
    }

    public void add(T t) {
        this.values.add(t);
        this.size = this.values.size();
    }

    public void set(int index, T t) {
        this.values.set(this.getRealIndex(index), t);
        this.size = this.values.size();
    }

    public void remove(Object t) {
        if (this.values.remove(t)) {
            this.size = this.values.size();
        }
    }

    public void remove(int index) {
        this.values.remove(this.getRealIndex(index));
        this.size = this.values.size();
    }

    public int size() {
        return this.size;
    }

    private int getRealIndex(int i) {
        int a2 = i % this.size();
        if (a2 < 0) {
            return a2 + this.size();
        }
        return a2;
    }
}

