/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.compat;

import com.yogpc.qp.compat.IInjector;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.EmptyHandler;
import net.minecraftforge.registries.ObjectHolder;
import scala.Option;

public class InvUtils {
    private static final List<IInjector> INJECTORS;
    @ObjectHolder(value="ic2:meter")
    public static final Item ic2_meter;
    @ObjectHolder(value="ic2:wrench")
    public static final Item ic2_wrench;
    @ObjectHolder(value="ic2:electric_wrench")
    public static final Item ic2_electric_wrench;
    @ObjectHolder(value="quarryplus:quarrydebug")
    public static final Item quarryDebug;
    @ObjectHolder(value="cofhcore:smelting")
    public static final Enchantment cofh_smelting;
    @ObjectHolder(value="endercore:autosmelt")
    public static final Enchantment endercore_smelting;

    public static ItemStack injectToNearTile(@Nonnull World w, @Nonnull BlockPos pos, ItemStack is) {
        List injectors = Stream.of(Direction.values()).flatMap(enumFacing -> Stream.of(w.func_175625_s(pos.func_177972_a(enumFacing))).filter(Objects::nonNull).flatMap(tile -> INJECTORS.stream().flatMap(i -> i.getInjector(is, (TileEntity)tile, (Direction)enumFacing)))).collect(Collectors.toList());
        ItemStack inserted = is.func_77946_l();
        for (IInjector injector : injectors) {
            inserted = injector.inject(inserted, w, pos);
            if (!inserted.func_190926_b()) continue;
            return ItemStack.field_190927_a;
        }
        return inserted;
    }

    @Deprecated
    public static Option<IItemHandler> findItemHandler(@Nonnull World world, @Nonnull BlockPos pos, @Nullable Direction from) {
        TileEntity entity = world.func_175625_s(pos);
        if (entity == null) {
            return Option.empty();
        }
        LazyOptional capability = entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, from);
        if (capability.isPresent()) {
            return Option.apply((Object)capability.orElse((Object)EmptyHandler.INSTANCE));
        }
        return Option.empty();
    }

    public static void dropAndUpdateInv(World world, BlockPos pos, IInventory inventory, Block block) {
        if (inventory != null) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)inventory);
            world.func_175666_e(pos, block);
        }
    }

    public static boolean isDebugItem(@Nonnull PlayerEntity player, @Nonnull Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b()) {
            Item item = stack.func_77973_b();
            return item == quarryDebug || item == ic2_meter || item == ic2_wrench || item == ic2_electric_wrench;
        }
        return false;
    }

    public static BlockState getStateFromItem(@Nonnull BlockItem itemBlock) {
        Block block = itemBlock.func_179223_d();
        return block.func_176223_P();
    }

    public static boolean hasSmelting(ItemStack stack) {
        return cofh_smelting != DummyEnchantment.DUMMY_ENCHANTMENT && EnchantmentHelper.func_77506_a((Enchantment)cofh_smelting, (ItemStack)stack) > 0 || endercore_smelting != DummyEnchantment.DUMMY_ENCHANTMENT && EnchantmentHelper.func_77506_a((Enchantment)endercore_smelting, (ItemStack)stack) > 0;
    }

    static {
        Stream.Builder<IInjector> builder = Stream.builder();
        if (ModList.get().isLoaded("buildcraftlib")) {
            try {
                builder.add((IInjector)Class.forName("com.yogpc.qp.compat.BCInjector").getMethod("init", new Class[0]).invoke(null, new Object[0]));
            }
            catch (ReflectiveOperationException e) {
                e.printStackTrace();
            }
        }
        if (ModList.get().isLoaded("mekanism")) {
            try {
                builder.add((IInjector)Class.forName("com.yogpc.qp.compat.MekanismInjector").getMethod("init", new Class[0]).invoke(null, new Object[0]));
            }
            catch (ReflectiveOperationException e) {
                e.printStackTrace();
            }
        }
        builder.add(new ForgeInjector(EmptyHandler.INSTANCE));
        INJECTORS = Collections.unmodifiableList(builder.build().filter(Objects::nonNull).collect(Collectors.toList()));
        ic2_meter = new Item(new Item.Properties());
        ic2_wrench = new Item(new Item.Properties());
        ic2_electric_wrench = new Item(new Item.Properties());
        quarryDebug = new Item(new Item.Properties());
        cofh_smelting = DummyEnchantment.DUMMY_ENCHANTMENT;
        endercore_smelting = DummyEnchantment.DUMMY_ENCHANTMENT;
    }

    private static final class DummyEnchantment
    extends Enchantment {
        private static final DummyEnchantment DUMMY_ENCHANTMENT = new DummyEnchantment();

        DummyEnchantment() {
            super(Enchantment.Rarity.COMMON, EnchantmentType.ALL, new EquipmentSlotType[0]);
        }
    }

    private static class ForgeInjector
    implements IInjector {
        private final IItemHandler handler;

        private ForgeInjector(IItemHandler handler) {
            this.handler = handler;
        }

        @Override
        public Stream<? extends IInjector> getInjector(ItemStack stack, TileEntity entity, Direction facing) {
            return (Stream)entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d()).filter(h -> stack.func_190916_E() != ItemHandlerHelper.insertItemStacked((IItemHandler)h, (ItemStack)stack, (boolean)true).func_190916_E()).map(ForgeInjector::new).map(Stream::of).orElse(Stream.empty());
        }

        @Override
        public ItemStack inject(ItemStack stack, World world, BlockPos fromPos) {
            return ItemHandlerHelper.insertItem((IItemHandler)this.handler, (ItemStack)stack, (boolean)false);
        }
    }
}

