/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.marker;

import com.yogpc.qp.machines.marker.TileMarker;
import com.yogpc.qp.utils.Holder;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import jp.t2v.lab.syntax.MapStreamSyntax;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockMarker
extends Block {
    private static final VoxelShape STANDING_Shape = VoxelShapes.func_197873_a((double)0.35, (double)0.0, (double)0.35, (double)0.65, (double)0.65, (double)0.65);
    private static final VoxelShape DOWN_Shape = VoxelShapes.func_197873_a((double)0.35, (double)0.35, (double)0.35, (double)0.65, (double)1.0, (double)0.65);
    private static final VoxelShape NORTH_Shape = VoxelShapes.func_197873_a((double)0.35, (double)0.35, (double)0.35, (double)0.65, (double)0.65, (double)1.0);
    private static final VoxelShape SOUTH_Shape = VoxelShapes.func_197873_a((double)0.35, (double)0.35, (double)0.0, (double)0.65, (double)0.65, (double)0.65);
    private static final VoxelShape WEST_Shape = VoxelShapes.func_197873_a((double)0.35, (double)0.35, (double)0.35, (double)1.0, (double)0.65, (double)0.65);
    private static final VoxelShape EAST_Shape = VoxelShapes.func_197873_a((double)0.0, (double)0.35, (double)0.35, (double)0.65, (double)0.65, (double)0.65);
    public final BlockItem itemBlock;

    public BlockMarker() {
        super(Block.Properties.func_200945_a((Material)Material.field_151594_q).func_200951_a(7));
        this.setRegistryName("quarryplus", "markerplus");
        this.itemBlock = new BlockItem((Block)this, new Item.Properties().func_200916_a((ItemGroup)Holder.tab()));
        this.itemBlock.setRegistryName("quarryplus", "markerplus");
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((IProperty)BlockStateProperties.field_208155_H, (Comparable)Direction.NORTH));
    }

    public Item func_199767_j() {
        return this.itemBlock;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{BlockStateProperties.field_208155_H});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208155_H, (Comparable)context.func_196000_l());
    }

    public boolean func_220051_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TileEntity entity;
        if (!worldIn.field_72995_K && (entity = worldIn.func_175625_s(pos)) instanceof TileMarker) {
            TileMarker marker = (TileMarker)entity;
            if (marker.enabled()) {
                if (!marker.hasLink()) {
                    marker.activated();
                } else {
                    player.func_146105_b((ITextComponent)new StringTextComponent(marker.link.toString()), false);
                }
            } else {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.disable_message", new Object[]{this.func_200291_n()}), true);
            }
        }
        return true;
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!worldIn.field_72995_K) {
            Stream.of(worldIn.func_175625_s(pos)).flatMap(MapStreamSyntax.streamCast(TileMarker.class)).forEach(TileMarker::redstoneUpdate);
        }
        super.func_220069_a(state, worldIn, pos, blockIn, fromPos, isMoving);
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        Optional.ofNullable(worldIn.func_175625_s(pos)).flatMap(MapStreamSyntax.optCast(TileMarker.class)).ifPresent(TileMarker.requestTicket);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return Holder.markerTileType().func_200968_a();
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208155_H)) {
            default: {
                return STANDING_Shape;
            }
            case DOWN: {
                return DOWN_Shape;
            }
            case NORTH: {
                return NORTH_Shape;
            }
            case SOUTH: {
                return SOUTH_Shape;
            }
            case WEST: {
                return WEST_Shape;
            }
            case EAST: 
        }
        return EAST_Shape;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197880_a();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_200122_a(BlockState state, BlockState adjacentBlockState, Direction side) {
        return true;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        Direction direction = (Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208155_H);
        BlockPos blockpos = pos.func_177972_a(direction.func_176734_d());
        BlockState floorState = worldIn.func_180495_p(blockpos);
        return floorState.func_224755_d((IBlockReader)worldIn, blockpos, direction);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : stateIn;
    }
}

