/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.pump;

import com.yogpc.qp.Config;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.PowerManager;
import com.yogpc.qp.machines.base.APacketTile;
import com.yogpc.qp.machines.base.APowerTile;
import com.yogpc.qp.machines.base.HasStorage;
import com.yogpc.qp.machines.base.IAttachable;
import com.yogpc.qp.machines.base.IAttachment;
import com.yogpc.qp.machines.base.IDebugSender;
import com.yogpc.qp.machines.base.IEnchantableTile;
import com.yogpc.qp.machines.base.IModule;
import com.yogpc.qp.machines.base.QPBlock;
import com.yogpc.qp.machines.pump.PumpModule;
import com.yogpc.qp.machines.pump.RangeWrapper;
import com.yogpc.qp.machines.pump.TankPump;
import com.yogpc.qp.machines.quarry.TileQuarry;
import com.yogpc.qp.machines.quarry.TileQuarry2;
import com.yogpc.qp.packet.PacketHandler;
import com.yogpc.qp.packet.pump.Mappings;
import com.yogpc.qp.packet.pump.Now;
import com.yogpc.qp.utils.Holder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.IFluidHandler;
import scala.Symbol;

public class TilePump
extends APacketTile
implements IEnchantableTile,
ITickableTileEntity,
IDebugSender,
IAttachment,
HasStorage {
    public static final Symbol SYMBOL = Symbol.apply((String)"PumpPlus");
    @Nullable
    public Direction connectTo = null;
    private boolean initialized = false;
    private Direction preFacing;
    public byte unbreaking;
    protected byte fortune;
    protected boolean silktouch;
    private final TankPump tankPump = new TankPump();
    private static final int Y_SIZE = 256;
    private static final int CHUNK_SCALE = 16;
    private byte[][][] blocks;
    private ChunkSection[][][] storageArray;
    private int xOffset;
    private int yOffset;
    private int zOffset;
    private int px;
    private int py = Integer.MIN_VALUE;
    private int cx;
    private int cy = -1;
    private int cz;
    private byte range = 0;
    private boolean quarryRange = true;
    private boolean autoChangedRange = false;
    private int block_side_x;
    private int block_side_z;
    private static final int ARRAY_MAX = 524288;
    private static final int[] xb = new int[524288];
    private static final int[] yb = new int[524288];
    private static final int[] zb = new int[524288];
    private static int cp = 0;
    private long fwt;

    public TilePump() {
        super(Holder.pumpTileType());
    }

    public IAttachable G_connected() {
        if (this.field_145850_b != null && this.connectTo != null) {
            TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(this.connectTo));
            if (te instanceof IAttachable) {
                return (IAttachable)te;
            }
            this.setConnectTo(null);
            if (!this.field_145850_b.field_72995_K) {
                this.S_sendNowPacket();
            }
            return null;
        }
        return null;
    }

    public boolean G_working() {
        return this.py >= this.cy;
    }

    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        this.silktouch = nbt.func_74767_n("silktouch");
        this.fortune = nbt.func_74771_c("fortune");
        this.unbreaking = nbt.func_74771_c("unbreaking");
        if (nbt.func_74764_b("connectTo")) {
            this.setConnectTo(Direction.func_82600_a((int)nbt.func_74771_c("connectTo")));
            this.preFacing = this.connectTo;
        }
        this.range = nbt.func_74771_c("range");
        this.quarryRange = nbt.func_74767_n("quarryRange");
        this.autoChangedRange = nbt.func_74767_n("autoChangedRange");
        this.tankPump.deserializeNBT(nbt.func_74775_l("tankPump"), this.silktouch);
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        nbt.func_74757_a("silktouch", this.silktouch);
        nbt.func_74774_a("fortune", this.fortune);
        nbt.func_74774_a("unbreaking", this.unbreaking);
        if (this.connectTo != null) {
            nbt.func_74774_a("connectTo", (byte)this.connectTo.ordinal());
        }
        nbt.func_74774_a("range", this.range);
        nbt.func_74757_a("quarryRange", this.quarryRange);
        nbt.func_74757_a("autoChangedRange", this.autoChangedRange);
        nbt.func_218657_a("tankPump", (INBT)this.tankPump.serializeNBT(this.silktouch));
        return super.func_189515_b(nbt);
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            for (Direction facing : Direction.values()) {
                BlockPos offset = this.func_174877_v().func_177972_a(facing);
                FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)offset, (Direction)facing.func_176734_d()).ifPresent(destination -> {
                    IFluidHandler pumpTank = this.tankPump.pumpTankEnumMap.get(facing);
                    FluidUtil.tryFluidTransfer((IFluidHandler)destination, (IFluidHandler)pumpTank, (int)Integer.MAX_VALUE, (boolean)true);
                });
            }
            if (!this.initialized && this.connectTo != null) {
                TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(this.connectTo));
                if (te instanceof IAttachable && ((IAttachable)te).connect(this.connectTo.func_176734_d(), IAttachment.Attachments.FLUID_PUMP)) {
                    ((IAttachable)te).connectAttachment(this.connectTo.func_176734_d(), IAttachment.Attachments.FLUID_PUMP, false);
                    this.S_sendNowPacket();
                    this.initialized = true;
                } else if (this.field_145850_b.func_175623_d(this.func_174877_v().func_177972_a(this.connectTo))) {
                    this.setConnectTo(null);
                    this.S_sendNowPacket();
                    this.initialized = true;
                }
            }
        }
    }

    @Override
    public void G_ReInit() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            for (Direction facing : Direction.values()) {
                TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(facing));
                if (!(te instanceof IAttachable) || !((IAttachable)te).connect(facing.func_176734_d(), IAttachment.Attachments.FLUID_PUMP)) continue;
                this.setConnectTo(facing);
                ((IAttachable)te).connectAttachment(facing.func_176734_d(), IAttachment.Attachments.FLUID_PUMP, false);
                this.S_sendNowPacket();
                return;
            }
            this.setConnectTo(null);
            this.S_sendNowPacket();
        }
    }

    private void S_sendNowPacket() {
        assert (this.field_145850_b != null);
        if (this.preFacing != this.connectTo || ((Boolean)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b((IProperty)QPBlock.WORKING())).booleanValue() != this.G_working()) {
            this.preFacing = this.connectTo;
            PacketHandler.sendToAround(Now.create(this), this.field_145850_b, this.func_174877_v());
        }
    }

    @Override
    public void setConnectTo(@Nullable Direction connectTo) {
        BlockState state;
        this.connectTo = connectTo;
        if (this.field_145850_b != null && connectTo != null ^ (Boolean)(state = this.field_145850_b.func_180495_p(this.func_174877_v())).func_177229_b((IProperty)BlockStateProperties.field_208180_g)) {
            this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208180_g, (Comparable)Boolean.valueOf(connectTo != null)));
        }
    }

    @Override
    public IModule getModule() {
        return PumpModule.fromTile(this, (APowerTile)((Object)this.G_connected()));
    }

    public void setWorking(boolean b) {
        if (b) {
            this.py = -1;
            this.cy = -1;
        } else {
            this.py = Integer.MIN_VALUE;
        }
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            BlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
            this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)state.func_206870_a((IProperty)QPBlock.WORKING(), (Comparable)Boolean.valueOf(b)));
        }
    }

    public void S_OpenGUI(Direction facing, PlayerEntity ep) {
        PacketHandler.sendToClient(Mappings.All.create(this, facing), this.field_145850_b);
    }

    public void S_changeRange(PlayerEntity ep) {
        if (this.range >= (this.fortune + 1) * 2) {
            if (this.G_connected() instanceof TileQuarry || this.G_connected() instanceof TileQuarry2) {
                this.quarryRange = true;
            }
            this.range = 0;
        } else if (this.quarryRange) {
            this.quarryRange = false;
        } else {
            this.range = (byte)(this.range + 1);
        }
        if (this.quarryRange) {
            ep.func_146105_b((ITextComponent)new TranslationTextComponent("chat.pump_rtoggle.quarry", new Object[0]), false);
        } else {
            ep.func_146105_b((ITextComponent)new TranslationTextComponent("chat.pump_rtoggle.num", new Object[]{Integer.toString(this.range * 2 + 1)}), false);
        }
        this.fwt = 0L;
    }

    private static void S_put(int x, int y, int z) {
        TilePump.xb[TilePump.cp] = x;
        TilePump.yb[TilePump.cp] = y;
        TilePump.zb[TilePump.cp] = z;
        if (++cp == 524288) {
            cp = 0;
        }
    }

    private void S_searchLiquid(int x, int y, int z) {
        int chunk_side_z;
        int chunk_side_x;
        assert (this.field_145850_b != null);
        this.fwt = this.field_145850_b.func_72820_D();
        int cg = 0;
        cp = 0;
        this.cx = x;
        this.cy = y;
        this.cz = z;
        this.yOffset = y & 0xFFFFFFF0;
        this.py = 255;
        this.px = -1;
        IAttachable tb = this.G_connected();
        RangeWrapper b = null;
        if (tb instanceof TileQuarry || tb instanceof TileQuarry2) {
            b = RangeWrapper.of(tb);
        }
        if (b != null && b.yMax != Integer.MIN_VALUE) {
            int z_add;
            chunk_side_x = 1 + (b.xMax >> 4) - (b.xMin >> 4);
            chunk_side_z = 1 + (b.zMax >> 4) - (b.zMin >> 4);
            this.xOffset = b.xMin & 0xFFFFFFF0;
            this.zOffset = b.zMin & 0xFFFFFFF0;
            int x_add = this.range * 2 + 1 - chunk_side_x;
            if (x_add > 0) {
                chunk_side_x += x_add;
                this.xOffset -= ((x_add & 0xFFFFFFFE) << 3) + (x_add % 2 != 0 && (b.xMax + b.xMin + 1) / 2 % 16 <= 8 ? 16 : 0);
            }
            if ((z_add = this.range * 2 + 1 - chunk_side_z) > 0) {
                chunk_side_z += z_add;
                this.zOffset -= ((z_add & 0xFFFFFFFE) << 3) + (z_add % 2 != 0 && (b.zMax + b.zMin + 1) / 2 % 16 <= 8 ? 16 : 0);
            }
        } else {
            this.quarryRange = false;
            chunk_side_x = chunk_side_z = 1 + this.range * 2;
            this.xOffset = (x >> 4) - this.range << 4;
            this.zOffset = (z >> 4) - this.range << 4;
        }
        if (!this.quarryRange) {
            b = null;
        }
        this.block_side_x = chunk_side_x * 16;
        this.block_side_z = chunk_side_z * 16;
        this.blocks = new byte[256 - this.yOffset][this.block_side_x][this.block_side_z];
        this.storageArray = new ChunkSection[chunk_side_x][chunk_side_z][];
        for (int kx = 0; kx < chunk_side_x; ++kx) {
            for (int kz = 0; kz < chunk_side_z; ++kz) {
                this.storageArray[kx][kz] = this.field_145850_b.func_72863_F().func_217205_a(kx + (this.xOffset >> 4), kz + (this.zOffset >> 4), true).func_76587_i();
            }
        }
        TilePump.S_put(x - this.xOffset, y, z - this.zOffset);
        while (cp != cg) {
            ChunkSection ebs_c = this.storageArray[xb[cg] >> 4][zb[cg] >> 4][yb[cg] >> 4];
            if (ebs_c != null) {
                BlockState b_c = ebs_c.func_177485_a(xb[cg] & 0xF, yb[cg] & 0xF, zb[cg] & 0xF);
                if (this.blocks[yb[cg] - this.yOffset][xb[cg]][zb[cg]] == 0 && TilePump.isLiquid(b_c)) {
                    this.blocks[TilePump.yb[cg] - this.yOffset][TilePump.xb[cg]][TilePump.zb[cg]] = 63;
                    if ((b != null ? b.xMin & 0xF : 0) < xb[cg]) {
                        TilePump.S_put(xb[cg] - 1, yb[cg], zb[cg]);
                    } else {
                        this.blocks[TilePump.yb[cg] - this.yOffset][TilePump.xb[cg]][TilePump.zb[cg]] = 127;
                    }
                    if (xb[cg] < (b != null ? b.xMax - this.xOffset : this.block_side_x - 1)) {
                        TilePump.S_put(xb[cg] + 1, yb[cg], zb[cg]);
                    } else {
                        this.blocks[TilePump.yb[cg] - this.yOffset][TilePump.xb[cg]][TilePump.zb[cg]] = 127;
                    }
                    if ((b != null ? b.zMin & 0xF : 0) < zb[cg]) {
                        TilePump.S_put(xb[cg], yb[cg], zb[cg] - 1);
                    } else {
                        this.blocks[TilePump.yb[cg] - this.yOffset][TilePump.xb[cg]][TilePump.zb[cg]] = 127;
                    }
                    if (zb[cg] < (b != null ? b.zMax - this.zOffset : this.block_side_z - 1)) {
                        TilePump.S_put(xb[cg], yb[cg], zb[cg] + 1);
                    } else {
                        this.blocks[TilePump.yb[cg] - this.yOffset][TilePump.xb[cg]][TilePump.zb[cg]] = 127;
                    }
                    if (yb[cg] + 1 < 256) {
                        TilePump.S_put(xb[cg], yb[cg] + 1, zb[cg]);
                    }
                }
            }
            if (++cg != 524288) continue;
            cg = 0;
        }
    }

    public boolean S_removeLiquids(APowerTile tile, int x, int y, int z) {
        int bz;
        int bx;
        this.S_sendNowPacket();
        assert (this.field_145850_b != null);
        if (this.cx != x || this.cy != y || this.cz != z || this.py < this.cy || this.field_145850_b.func_72820_D() - this.fwt > 200L) {
            this.S_searchLiquid(x, y, z);
        } else {
            this.storageArray = new ChunkSection[this.storageArray.length][this.storageArray[0].length][];
            for (int kx = 0; kx < this.storageArray.length; ++kx) {
                for (int kz = 0; kz < this.storageArray[0].length; ++kz) {
                    this.storageArray[kx][kz] = this.field_145850_b.func_72863_F().func_217205_a(kx + (this.xOffset >> 4), kz + (this.zOffset >> 4), true).func_76587_i();
                }
            }
        }
        int count = 0;
        while (true) {
            if (this.px == -1) {
                for (bx = 0; bx < this.block_side_x; ++bx) {
                    for (bz = 0; bz < this.block_side_z; ++bz) {
                        BlockState bb;
                        if ((this.blocks[this.py - this.yOffset][bx][bz] & 0x40) == 0 || !TilePump.isLiquid(bb = this.storageArray[bx >> 4][bz >> 4][this.py >> 4].func_177485_a(bx & 0xF, this.py & 0xF, bz & 0xF))) continue;
                        ++count;
                    }
                }
            } else {
                BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
                for (bz = 0; bz < this.block_side_z; ++bz) {
                    if (this.blocks[this.py - this.yOffset][this.px][bz] == 0) continue;
                    BlockState bb = this.storageArray[this.px >> 4][bz >> 4][this.py >> 4].func_177485_a(this.px & 0xF, this.py & 0xF, bz & 0xF);
                    mutableBlockPos.func_181079_c(this.px + this.xOffset, this.py, bz + this.zOffset);
                    if (!TilePump.isLiquid(bb, (Boolean)Config.common().removeOnlySource().get(), this.field_145850_b, (BlockPos)mutableBlockPos)) continue;
                    ++count;
                }
            }
            if (count <= 0 && ++this.px < this.block_side_x) continue;
            if (count > 0) break;
            this.px = -1;
            if (--this.py < this.cy) break;
        }
        if (count > 0 && PowerManager.useEnergyPump(tile, this.unbreaking, count, this.px == -1 ? (long)count : 0L)) {
            if (this.px == -1) {
                for (bx = 0; bx < this.block_side_x; ++bx) {
                    for (bz = 0; bz < this.block_side_z; ++bz) {
                        if ((this.blocks[this.py - this.yOffset][bx][bz] & 0x40) == 0) continue;
                        this.drainBlock(bx, bz, Holder.blockFrame().getDammingState());
                        if (!(tile instanceof TileQuarry) && !(tile instanceof TileQuarry2)) continue;
                        RangeWrapper wrapper = RangeWrapper.of((Object)tile);
                        int xTarget = bx + this.xOffset;
                        int zTarget = bz + this.zOffset;
                        if (wrapper.waiting()) {
                            if (wrapper.xMin > xTarget || xTarget > wrapper.xMax || wrapper.zMin > zTarget || zTarget > wrapper.zMax) continue;
                            if (Config.common().debug()) {
                                QuarryPlus.LOGGER.warn(String.format("Quarry placed frame at %d, %d, %d", xTarget, this.py, zTarget));
                            }
                            this.autoChange(true);
                            continue;
                        }
                        if (Config.common().debug() && wrapper.xMin < xTarget && xTarget < wrapper.xMax && wrapper.zMin < zTarget && zTarget < wrapper.zMax) {
                            QuarryPlus.LOGGER.warn(String.format("Quarry placed frame at %d, %d, %d", xTarget, this.py, zTarget));
                        }
                        this.autoChange(false);
                    }
                }
            } else {
                for (bz = 0; bz < this.block_side_z; ++bz) {
                    if (this.blocks[this.py - this.yOffset][this.px][bz] == 0) continue;
                    this.drainBlock(this.px, bz, Blocks.field_150350_a.func_176223_P());
                }
            }
        }
        this.S_sendNowPacket();
        return this.py < this.cy;
    }

    private void autoChange(boolean on) {
        if (on) {
            this.autoChangedRange = true;
            this.quarryRange = false;
        } else if (this.autoChangedRange) {
            this.autoChangedRange = false;
            this.quarryRange = true;
        }
    }

    public static boolean isLiquid(@Nonnull BlockState state, boolean findSource, World world, BlockPos pos) {
        if (state.func_204520_s() != Fluids.field_204541_a.func_207188_f()) {
            return !findSource || state.func_204520_s().func_206889_d();
        }
        Block block = state.func_177230_c();
        if (block instanceof IFluidBlock) {
            return !findSource || ((IFluidBlock)block).canDrain(world, pos);
        }
        return !(block != Blocks.field_150355_j && block != Blocks.field_150353_l && !state.func_185904_a().func_76224_d() || findSource && (Integer)state.func_177229_b((IProperty)FlowingFluidBlock.field_176367_b) != 0);
    }

    public static boolean isLiquid(@Nonnull BlockState state) {
        return TilePump.isLiquid(state, false, null, null);
    }

    private void drainBlock(int bx, int bz, BlockState tb) {
        assert (this.field_145850_b != null);
        BlockState blockState = this.storageArray[bx >> 4][bz >> 4][this.py >> 4].func_177485_a(bx & 0xF, this.py & 0xF, bz & 0xF);
        if (TilePump.isLiquid(blockState)) {
            BlockPos blockPos = new BlockPos(bx + this.xOffset, this.py, bz + this.zOffset);
            IFluidState fluidState = this.field_145850_b.func_204610_c(blockPos);
            if (fluidState.func_206889_d()) {
                TankPump storage = this.G_connected() instanceof HasStorage ? ((HasStorage)((Object)this.G_connected())).getStorage() : this.getStorage();
                storage.insertFluid(new FluidStack(fluidState.func_206886_c(), 1000));
            }
            if (blockState.func_185904_a().func_76224_d()) {
                this.field_145850_b.func_175656_a(blockPos, tb);
            } else if (blockState.func_177230_c() instanceof IBucketPickupHandler) {
                ((IBucketPickupHandler)blockState.func_177230_c()).func_204508_a((IWorld)this.field_145850_b, blockPos, blockState);
            } else {
                this.field_145850_b.func_175656_a(blockPos, tb);
            }
        }
    }

    public List<ITextComponent> C_getNames() {
        Collection<FluidStack> allContents = this.tankPump.getAllContents();
        if (!allContents.isEmpty()) {
            ArrayList<ITextComponent> list = new ArrayList<ITextComponent>(allContents.size() + 1);
            list.add((ITextComponent)new TranslationTextComponent("chat.pumpcontain", new Object[0]));
            allContents.forEach(s -> list.add((ITextComponent)new TranslationTextComponent("yog.pump.liquid", new Object[]{s.getDisplayName(), Integer.toString(s.getAmount())})));
            return list;
        }
        return Collections.singletonList(new TranslationTextComponent("chat.pumpcontainno", new Object[0]));
    }

    public List<ITextComponent> getDebugMessages() {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        list.add((ITextComponent)toComponentString.apply("Connection : " + this.connectTo));
        Collection<FluidStack> allContents = this.tankPump.getAllContents();
        if (!allContents.isEmpty()) {
            list.add((ITextComponent)new TranslationTextComponent("chat.pumpcontain", new Object[0]));
            allContents.stream().map(fluidStack -> Objects.toString(fluidStack.getFluid().getRegistryName()) + fluidStack.getAmount() + "mB").reduce(combiner).map(toComponentString).ifPresent(list::add);
        } else {
            list.add((ITextComponent)new TranslationTextComponent("chat.pumpcontainno", new Object[0]));
        }
        return list;
    }

    @Override
    public String getDebugName() {
        return "block.quarryplus.pumpplus";
    }

    @Override
    @Nonnull
    public Map<ResourceLocation, Integer> getEnchantments() {
        HashMap<ResourceLocation, Integer> ret = new HashMap<ResourceLocation, Integer>();
        if (this.fortune > 0) {
            ret.put(FortuneID, Integer.valueOf(this.fortune));
        }
        if (this.unbreaking > 0) {
            ret.put(UnbreakingID, Integer.valueOf(this.unbreaking));
        }
        if (this.silktouch) {
            ret.put(SilktouchID, 1);
        }
        return ret;
    }

    @Override
    public void setEnchantment(ResourceLocation id, short val) {
        if (id.equals((Object)FortuneID)) {
            this.fortune = (byte)val;
        } else if (id.equals((Object)UnbreakingID)) {
            this.unbreaking = (byte)val;
        } else if (id.equals((Object)SilktouchID)) {
            this.silktouch = val > 0;
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        LazyOptional<T> pumpCapability = this.tankPump.getCapability(cap, side);
        if (pumpCapability.isPresent()) {
            return pumpCapability;
        }
        return super.getCapability(cap, side);
    }

    @Override
    public TankPump getStorage() {
        return this.tankPump;
    }
}

