/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.quarry;

import com.yogpc.qp.compat.BuildcraftHelper;
import com.yogpc.qp.machines.base.IEnchantableTile;
import com.yogpc.qp.machines.base.QPBlock;
import com.yogpc.qp.machines.item.YSetterInteractionObject;
import com.yogpc.qp.machines.quarry.BlockItemEnchantable;
import com.yogpc.qp.machines.quarry.TileQuarry;
import com.yogpc.qp.utils.Holder;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class BlockQuarry
extends QPBlock {
    public BlockQuarry() {
        super(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(1.5f, 10.0f).func_200947_a(SoundType.field_185851_d), "quarryplus", BlockItemEnchantable::new);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((IProperty)BlockStateProperties.field_208155_H, (Comparable)Direction.NORTH)).func_206870_a((IProperty)QPBlock.WORKING(), (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public boolean func_220051_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        TileEntity t;
        if (super.func_220051_a(state, worldIn, pos, player, hand, hit)) {
            return true;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (BuildcraftHelper.isWrench(player, hand, stack, (RayTraceResult)hit)) {
            Optional.ofNullable((TileQuarry)worldIn.func_175625_s(pos)).ifPresent(TileQuarry::G_ReInit);
            player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.quarry.restart", new Object[0]), false);
            return true;
        }
        if (!worldIn.field_72995_K && (t = worldIn.func_175625_s(pos)) != null) {
            TileQuarry quarry = (TileQuarry)t;
            if (stack.func_77973_b() == Holder.itemStatusChecker()) {
                quarry.sendEnchantMassage(player);
                player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.currentmode", new Object[]{new TranslationTextComponent(quarry.filler ? "chat.fillermode" : "chat.quarrymode", new Object[0])}), false);
            } else if (stack.func_77973_b() == Holder.itemYSetter()) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)YSetterInteractionObject.apply(quarry, pos), (BlockPos)pos);
            } else if (quarry.G_getNow() == TileQuarry.Mode.NOT_NEED_BREAK) {
                quarry.filler = !quarry.filler;
                player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.changemode", new Object[]{new TranslationTextComponent(quarry.filler ? "chat.fillermode" : "chat.quarrymode", new Object[0])}), false);
            }
        }
        return true;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (!worldIn.field_72995_K) {
            Direction facing = placer.func_174811_aO().func_176734_d();
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208155_H, (Comparable)facing), 2);
            Consumer consumer = IEnchantableTile.Util.initConsumer(stack);
            Optional.ofNullable((TileQuarry)worldIn.func_175625_s(pos)).ifPresent(consumer.andThen(TileQuarry.requestTicket));
        }
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean b) {
        super.func_220069_a(state, worldIn, pos, blockIn, fromPos, b);
        if (!worldIn.field_72995_K) {
            Optional.ofNullable((TileQuarry)worldIn.func_175625_s(pos)).ifPresent(TileQuarry::G_renew_powerConfigure);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{BlockStateProperties.field_208155_H, QPBlock.WORKING()});
    }

    @Override
    public TileEntityType<? extends TileEntity> getTileType() {
        return Holder.quarryTileType();
    }
}

