/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.quarry;

import com.yogpc.qp.compat.BuildcraftHelper;
import com.yogpc.qp.machines.base.QPBlock;
import com.yogpc.qp.machines.quarry.TileQuarry;
import com.yogpc.qp.machines.quarry.TileSolidQuarry;
import com.yogpc.qp.utils.Holder;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import scala.Symbol;

public class BlockSolidQuarry
extends QPBlock {
    public static final Symbol SYMBOL = Symbol.apply((String)"SolidFuelQuarry");

    public BlockSolidQuarry() {
        super(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(1.5f, 10.0f).func_200947_a(SoundType.field_185851_d), "solidquarry", BlockItem::new);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((IProperty)BlockStateProperties.field_208155_H, (Comparable)Direction.NORTH)).func_206870_a((IProperty)QPBlock.WORKING(), (Comparable)Boolean.valueOf(false)));
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (!worldIn.field_72995_K) {
            Direction facing = placer.func_174811_aO().func_176734_d();
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208155_H, (Comparable)facing), 2);
            Optional.ofNullable((TileSolidQuarry)worldIn.func_175625_s(pos)).ifPresent(t -> {
                t.G_ReInit();
                TileSolidQuarry.requestTicket.accept(t);
            });
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{BlockStateProperties.field_208155_H, QPBlock.WORKING()});
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean b) {
        super.func_220069_a(state, worldIn, pos, blockIn, fromPos, b);
        if (!worldIn.field_72995_K) {
            Optional.ofNullable((TileSolidQuarry)worldIn.func_175625_s(pos)).ifPresent(TileQuarry::G_renew_powerConfigure);
        }
    }

    @Override
    public boolean func_220051_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult hit) {
        if (super.func_220051_a(state, worldIn, pos, playerIn, hand, hit)) {
            return true;
        }
        ItemStack stack = playerIn.func_184586_b(hand);
        if (BuildcraftHelper.isWrench(playerIn, hand, stack, (RayTraceResult)hit)) {
            Optional.ofNullable((TileSolidQuarry)worldIn.func_175625_s(pos)).ifPresent(TileQuarry::G_ReInit);
            playerIn.func_146105_b((ITextComponent)new TranslationTextComponent("chat.quarry.restart", new Object[0]), false);
            return true;
        }
        if (!playerIn.func_70093_af()) {
            if (!worldIn.field_72995_K) {
                Optional.ofNullable((TileSolidQuarry)worldIn.func_175625_s(pos)).ifPresent(t -> NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)playerIn), (INamedContainerProvider)t, (BlockPos)pos));
            }
            return true;
        }
        return false;
    }

    @Override
    public TileEntityType<? extends TileEntity> getTileType() {
        return Holder.solidQuarryType();
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity entity;
            if (!worldIn.field_72995_K && (entity = worldIn.func_175625_s(pos)) instanceof TileSolidQuarry) {
                TileSolidQuarry inventory = (TileSolidQuarry)entity;
                InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)inventory.func_70301_a(0));
                worldIn.func_175666_e(pos, state.func_177230_c());
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }
}

