/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.quarry;

import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.compat.InvUtils;
import com.yogpc.qp.machines.PowerManager;
import com.yogpc.qp.machines.base.APacketTile;
import com.yogpc.qp.machines.base.APowerTile;
import com.yogpc.qp.machines.base.HasInv;
import com.yogpc.qp.machines.base.IAttachable;
import com.yogpc.qp.machines.base.IAttachment;
import com.yogpc.qp.machines.base.IEnchantableItem;
import com.yogpc.qp.machines.base.IEnchantableTile;
import com.yogpc.qp.machines.base.IModule;
import com.yogpc.qp.machines.pump.TilePump;
import com.yogpc.qp.machines.quarry.QuarryFakePlayer;
import com.yogpc.qp.machines.workbench.BlockData;
import com.yogpc.qp.utils.NBTBuilder;
import com.yogpc.qp.utils.NoDuplicateList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jp.t2v.lab.syntax.MapStreamSyntax;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public abstract class TileBasic
extends APowerTile
implements IEnchantableTile,
HasInv,
IAttachable {
    private static final Set<IAttachment.Attachments<?>> VALID_ATTACHMENTS = IAttachment.Attachments.ALL;
    protected final Map<IAttachment.Attachments<?>, Direction> facingMap = new HashMap();
    public NoDuplicateList<BlockData> fortuneList = NoDuplicateList.create(ArrayList::new);
    public NoDuplicateList<BlockData> silktouchList = NoDuplicateList.create(ArrayList::new);
    public boolean fortuneInclude;
    public boolean silktouchInclude;
    protected byte unbreaking;
    protected byte fortune;
    protected boolean silktouch;
    protected byte efficiency;
    protected final LinkedList<ItemStack> cacheItems = new LinkedList();
    protected final IItemHandler handler = this.createHandler();
    protected Map<ResourceLocation, Integer> ench = new HashMap<ResourceLocation, Integer>();
    public List<IModule> modules = Collections.emptyList();
    public int yLevel = 1;

    public TileBasic(TileEntityType<?> type) {
        super(type);
    }

    public abstract void G_renew_powerConfigure();

    protected abstract void G_destroy();

    @Override
    public final void onChunkUnloaded() {
        this.G_destroy();
        super.onChunkUnloaded();
    }

    protected void S_pollItems() {
        ItemStack is;
        assert (this.field_145850_b != null);
        while (null != (is = this.cacheItems.poll())) {
            ItemStack stack = InvUtils.injectToNearTile(this.field_145850_b, this.func_174877_v(), is);
            if (stack.func_190916_E() <= 0) continue;
            this.cacheItems.add(stack);
            break;
        }
    }

    protected boolean S_breakBlock(int x, int y, int z, BlockState replace) {
        assert (this.field_145850_b != null);
        ArrayList<ItemStack> dropped = new ArrayList<ItemStack>(2);
        BlockPos pos = new BlockPos(x, y, z);
        BlockState blockState = this.field_145850_b.func_180495_p(pos);
        if (blockState.func_177230_c().isAir(blockState, (IBlockReader)this.field_145850_b, pos)) {
            return true;
        }
        BI bi = this.S_addDroppedItems(dropped, blockState, pos);
        if (!PowerManager.useEnergyBreak(this, blockState.func_185887_b((IBlockReader)this.field_145850_b, pos), bi.b, this.unbreaking, bi.b1)) {
            return false;
        }
        this.modules.forEach(iModule -> iModule.invoke(new IModule.BeforeBreak(bi.i, this.field_145850_b, pos)));
        this.cacheItems.addAll(dropped);
        if (this.facingMap.containsKey(IAttachment.Attachments.FLUID_PUMP) && TilePump.isLiquid(blockState)) {
            TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(this.facingMap.get(IAttachment.Attachments.FLUID_PUMP)));
            if (!(te instanceof TilePump)) {
                this.facingMap.remove(IAttachment.Attachments.FLUID_PUMP);
                this.G_renew_powerConfigure();
                return true;
            }
            boolean b = ((TilePump)te).S_removeLiquids(this, x, y, z);
            if (blockState.func_185904_a().func_76224_d()) {
                return b;
            }
        }
        this.field_145850_b.func_217379_c(2001, pos, Block.func_196246_j((BlockState)blockState));
        this.field_145850_b.func_180501_a(pos, replace, 3);
        return true;
    }

    @Override
    public boolean connectAttachment(Direction facing, IAttachment.Attachments<? extends APacketTile> attachments, boolean simulate) {
        TileEntity entity;
        assert (this.field_145850_b != null);
        if (this.facingMap.containsKey(attachments) && attachments.test(entity = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(this.facingMap.get(attachments)))) && this.facingMap.get(attachments) != facing) {
            return false;
        }
        if (!simulate) {
            this.facingMap.put(attachments, facing);
            this.G_renew_powerConfigure();
            this.modules = this.facingMap.entrySet().stream().map(MapStreamSyntax.values(arg_0 -> ((BlockPos)this.field_174879_c).func_177972_a(arg_0))).map(MapStreamSyntax.values(arg_0 -> ((World)this.field_145850_b).func_175625_s(arg_0))).map(MapStreamSyntax.toAny(IAttachment.Attachments::module)).flatMap(iModule -> iModule.map(Stream::of).orElse(Stream.empty())).collect(Collectors.toList());
        }
        return true;
    }

    @Override
    public boolean isValidAttachment(IAttachment.Attachments<? extends APacketTile> attachments) {
        return VALID_ATTACHMENTS.contains(attachments);
    }

    public void setYLevel(int yLevel) {
        this.yLevel = yLevel;
        QuarryPlus.LOGGER.debug("Quarry yLevel is set to " + yLevel + ".");
    }

    private BI S_addDroppedItems(Collection<ItemStack> collection, BlockState state, BlockPos pos) {
        byte i;
        ItemStack pickaxe;
        assert (this.field_145850_b != null);
        int xp = 0;
        QuarryFakePlayer fakePlayer = QuarryFakePlayer.get((ServerWorld)this.field_145850_b, pos);
        if (this.silktouch && this.silktouchList.contains(new BlockData(state)) == this.silktouchInclude) {
            pickaxe = this.getEnchantedPickaxe(IEnchantableItem.FORTUNE.negate());
            i = -1;
        } else if (this.fortuneList.contains(new BlockData(state)) == this.fortuneInclude) {
            pickaxe = this.getEnchantedPickaxe(IEnchantableItem.SILKTOUCH.negate());
            i = this.fortune;
        } else {
            pickaxe = this.getEnchantedPickaxe(IEnchantableItem.SILKTOUCH.negate().and(IEnchantableItem.FORTUNE.negate()));
            i = 0;
        }
        fakePlayer.func_184611_a(Hand.MAIN_HAND, pickaxe);
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(this.field_145850_b, pos, state, (PlayerEntity)fakePlayer);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (!event.isCanceled()) {
            NonNullList list = NonNullList.func_191196_a();
            list.addAll((Collection)Block.func_220077_a((BlockState)state, (ServerWorld)((ServerWorld)this.field_145850_b), (BlockPos)pos, (TileEntity)this.field_145850_b.func_175625_s(pos), (Entity)fakePlayer, (ItemStack)fakePlayer.func_184586_b(Hand.MAIN_HAND)));
            HashSet<ItemStack> rawItems = new HashSet<ItemStack>((Collection<ItemStack>)list);
            ForgeEventFactory.fireBlockHarvesting((NonNullList)list, (World)this.field_145850_b, (BlockPos)pos, (BlockState)state, (int)Math.max(0, i), (float)1.0f, (i == -1 ? 1 : 0) != 0, (PlayerEntity)fakePlayer);
            collection.addAll((Collection<ItemStack>)list);
            if (this.facingMap.containsKey(IAttachment.Attachments.EXP_PUMP)) {
                xp += event.getExpToDrop();
                if (InvUtils.hasSmelting(fakePlayer.func_184614_ca())) {
                    xp += TileBasic.getSmeltingXp(collection, rawItems, this.field_145850_b);
                }
            }
        } else {
            i = -2;
        }
        fakePlayer.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
        return new BI(i, xp, this.facingMap.containsKey(IAttachment.Attachments.REPLACER));
    }

    public static int getSmeltingXp(Collection<ItemStack> stacks, Collection<ItemStack> raw, World world) {
        Inventory basic = new Inventory(2);
        return stacks.stream().filter(MapStreamSyntax.not(raw::contains)).mapToInt(stack -> {
            basic.func_70299_a(0, stack);
            Optional recipe = world.func_199532_z().func_215371_a(IRecipeType.field_222150_b, (IInventory)basic, world);
            return TileBasic.floorFloat(recipe.map(AbstractCookingRecipe::func_222138_b).orElse(Float.valueOf(0.0f)).floatValue() * (float)stack.func_190916_E());
        }).sum();
    }

    public static int floorFloat(float value) {
        int i = MathHelper.func_76141_d((float)value);
        return i + (Math.random() < (double)(value - (float)i) ? 1 : 0);
    }

    @Override
    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        this.silktouch = nbt.func_74767_n("silktouch");
        this.fortune = nbt.func_74771_c("fortune");
        this.efficiency = nbt.func_74771_c("efficiency");
        this.unbreaking = nbt.func_74771_c("unbreaking");
        this.fortuneInclude = nbt.func_74767_n("fortuneInclude");
        this.silktouchInclude = nbt.func_74767_n("silktouchInclude");
        this.yLevel = Math.max(nbt.func_74762_e("yLevel"), 1);
        this.fortuneList = nbt.func_150295_c("fortuneList", 10).stream().map(CompoundNBT.class::cast).map(BlockData::read).collect(Collectors.toCollection(NoDuplicateList::create));
        this.silktouchList = nbt.func_150295_c("silktouchList", 10).stream().map(CompoundNBT.class::cast).map(BlockData::read).collect(Collectors.toCollection(NoDuplicateList::create));
        this.ench = nbt.func_150295_c("enchList", 10).stream().map(CompoundNBT.class::cast).map(MapStreamSyntax.toEntry(n -> n.func_74779_i("id"), n -> n.func_74762_e("value"))).map(MapStreamSyntax.keys(ResourceLocation::new)).filter(MapStreamSyntax.byKey(arg_0 -> ((IForgeRegistry)ForgeRegistries.ENCHANTMENTS).containsKey(arg_0))).collect(MapStreamSyntax.entryToMap());
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        nbt.func_74757_a("silktouch", this.silktouch);
        nbt.func_74774_a("fortune", this.fortune);
        nbt.func_74774_a("efficiency", this.efficiency);
        nbt.func_74774_a("unbreaking", this.unbreaking);
        nbt.func_74757_a("fortuneInclude", this.fortuneInclude);
        nbt.func_74757_a("silktouchInclude", this.silktouchInclude);
        nbt.func_218657_a("fortuneList", (INBT)this.fortuneList.stream().map(arg_0 -> BlockData.dataToNbt().apply(arg_0)).collect(Collectors.toCollection(ListNBT::new)));
        nbt.func_218657_a("silktouchList", (INBT)this.silktouchList.stream().map(arg_0 -> BlockData.dataToNbt().apply(arg_0)).collect(Collectors.toCollection(ListNBT::new)));
        nbt.func_74768_a("yLevel", this.yLevel);
        nbt.func_218657_a("enchList", (INBT)this.ench.entrySet().stream().map(MapStreamSyntax.keys(ResourceLocation::toString)).map(MapStreamSyntax.values(IntNBT::new)).collect(NBTBuilder.toNBTTag()));
        return super.func_189515_b(nbt);
    }

    @Override
    @Nonnull
    public Map<ResourceLocation, Integer> getEnchantments() {
        HashMap<ResourceLocation, Integer> ret = new HashMap<ResourceLocation, Integer>(this.ench);
        if (this.efficiency > 0) {
            ret.put(EfficiencyID, Integer.valueOf(this.efficiency));
        }
        if (this.fortune > 0) {
            ret.put(FortuneID, Integer.valueOf(this.fortune));
        }
        if (this.unbreaking > 0) {
            ret.put(UnbreakingID, Integer.valueOf(this.unbreaking));
        }
        if (this.silktouch) {
            ret.put(SilktouchID, 1);
        }
        return ret;
    }

    @Override
    public void setEnchantment(ResourceLocation id, short val) {
        if (id.equals((Object)EfficiencyID)) {
            this.efficiency = (byte)val;
        } else if (id.equals((Object)FortuneID)) {
            this.fortune = (byte)val;
        } else if (id.equals((Object)UnbreakingID)) {
            this.unbreaking = (byte)val;
        } else if (id.equals((Object)SilktouchID)) {
            boolean bl = this.silktouch = val > 0;
        }
        if (val > 0) {
            this.ench.put(id, Integer.valueOf(val));
        }
    }

    @Override
    public int func_70302_i_() {
        return Math.max(1, this.cacheItems.size());
    }

    @Override
    @Nonnull
    public ItemStack func_70301_a(int i) {
        return i < 0 || i >= this.cacheItems.size() ? ItemStack.field_190927_a : this.cacheItems.get(i);
    }

    @Override
    @Nonnull
    public ItemStack func_70298_a(int index, int count) {
        if (index < 0 || index >= this.cacheItems.size()) {
            return ItemStack.field_190927_a;
        }
        ItemStack from = this.cacheItems.get(index);
        ItemStack res = new ItemStack((IItemProvider)from.func_77973_b(), Math.min(count, from.func_190916_E()));
        Optional.ofNullable(from.func_77978_p()).map(CompoundNBT::func_74737_b).ifPresent(arg_0 -> ((ItemStack)res).func_77982_d(arg_0));
        from.func_190918_g(res.func_190916_E());
        if (from.func_190926_b()) {
            this.cacheItems.remove(index);
        }
        return res;
    }

    @Override
    @Nonnull
    public ItemStack func_70304_b(int index) {
        return index < 0 || index >= this.cacheItems.size() ? ItemStack.field_190927_a : this.cacheItems.remove(index);
    }

    @Override
    public void func_70299_a(int index, ItemStack stack) {
        if (!stack.func_190926_b()) {
            QuarryPlus.LOGGER.warn("QuarryPlus WARN: call setInventorySlotContents with non null ItemStack.");
        }
        this.func_70304_b(index);
    }

    public ITextComponent func_200200_C_() {
        return new StringTextComponent("container.yog.basic");
    }

    @Override
    public boolean func_70300_a(PlayerEntity player) {
        return false;
    }

    @Override
    public boolean func_191420_l() {
        return this.cacheItems.isEmpty();
    }

    @Override
    public void func_174888_l() {
        this.cacheItems.clear();
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(cap, LazyOptional.of(() -> this.handler));
        }
        return super.getCapability(cap, side);
    }

    private static class BI {
        final byte b;
        final int i;
        final boolean b1;

        private BI(byte b, int i, boolean b1) {
            this.b = b;
            this.i = i;
            this.b1 = b1;
        }
    }
}

