/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.packet.advquarry;

import com.yogpc.qp.machines.advquarry.TileAdvQuarry;
import com.yogpc.qp.machines.base.Area;
import com.yogpc.qp.machines.quarry.ContainerQuarryModule;
import com.yogpc.qp.packet.IMessage;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.util.ThreeConsumer;

public class AdvActionMessage
implements IMessage<AdvActionMessage> {
    private BlockPos pos;
    private int dim;
    private Actions action;
    private CompoundNBT tag;

    public static AdvActionMessage create(TileAdvQuarry quarry, Actions action) {
        return AdvActionMessage.create(quarry, action, new CompoundNBT());
    }

    public static AdvActionMessage create(TileAdvQuarry quarry, Actions action, CompoundNBT compound) {
        AdvActionMessage message = new AdvActionMessage();
        message.pos = quarry.func_174877_v();
        message.dim = IMessage.getDimId(quarry.func_145831_w());
        message.action = action;
        message.tag = compound;
        return message;
    }

    @Override
    public AdvActionMessage readFromBuffer(PacketBuffer buffer) {
        this.pos = buffer.func_179259_c();
        this.dim = buffer.readInt();
        this.action = (Actions)buffer.func_179257_a(Actions.class);
        this.tag = buffer.func_150793_b();
        return this;
    }

    @Override
    public void writeToBuffer(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos).writeInt(this.dim);
        buffer.func_179249_a((Enum)this.action);
        buffer.func_150786_a(this.tag);
    }

    @Override
    public void onReceive(Supplier<NetworkEvent.Context> ctx) {
        IMessage.findTile(ctx, this.pos, this.dim, TileAdvQuarry.class).ifPresent(quarry -> ((NetworkEvent.Context)ctx.get()).enqueueWork(this.action.runnable((TileAdvQuarry)quarry, this.tag, ((NetworkEvent.Context)ctx.get()).getSender())));
    }

    public static enum Actions {
        QUICK_START(TileAdvQuarry::noFrameStart),
        CHANGE_RANGE((quarry, rangeNBT) -> quarry.area_$eq(Area.areaLoad(rangeNBT))),
        MODULE_INV((ThreeConsumer<TileAdvQuarry, CompoundNBT, ServerPlayerEntity>)((ThreeConsumer)(q, t, p) -> ContainerQuarryModule.InteractionObject.openGUI(q, p, "block.quarryplus.chunkdestroyer")));

        private final ThreeConsumer<TileAdvQuarry, CompoundNBT, ServerPlayerEntity> consumer;

        private Actions(Consumer<TileAdvQuarry> consumer) {
            this.consumer = (quarry, nbtTagCompound, player) -> consumer.accept((TileAdvQuarry)quarry);
        }

        private Actions(BiConsumer<TileAdvQuarry, CompoundNBT> consumer) {
            this.consumer = (quarry, nbtTagCompound, player) -> consumer.accept((TileAdvQuarry)quarry, (CompoundNBT)nbtTagCompound);
        }

        private Actions(ThreeConsumer<TileAdvQuarry, CompoundNBT, ServerPlayerEntity> consumer) {
            this.consumer = consumer;
        }

        Runnable runnable(TileAdvQuarry quarry, CompoundNBT compound, ServerPlayerEntity player) {
            return () -> this.consumer.accept((Object)quarry, (Object)compound, (Object)player);
        }
    }
}

