/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.utils;

import com.google.common.collect.Streams;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import jp.t2v.lab.syntax.MapStreamSyntax;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.IProperty;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class NBTBuilder<T extends INBT> {
    private Map<String, T> map = new LinkedHashMap<String, T>();

    public static <K, V> ListNBT fromMap(Map<? extends K, ? extends V> map, String keyName, String valueName, Function<? super K, ? extends INBT> keyFunction, Function<? super V, ? extends INBT> valueFunction) {
        return map.entrySet().stream().map(MapStreamSyntax.toEntry(keyFunction.compose(Map.Entry::getKey), valueFunction.compose(Map.Entry::getValue))).map(MapStreamSyntax.toAny((k, v) -> {
            CompoundNBT compound = new CompoundNBT();
            compound.func_218657_a(keyName, (INBT)k);
            compound.func_218657_a(valueName, (INBT)v);
            return compound;
        })).collect(Collectors.toCollection(ListNBT::new));
    }

    public static <K, V> Map<K, V> fromList(ListNBT list, Function<? super CompoundNBT, ? extends K> keyFunction, Function<? super CompoundNBT, ? extends V> valueFunction, Predicate<? super K> keyFilter, Predicate<? super V> valuePredicate) {
        HashMap<K, V> map = new HashMap<K, V>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT at = list.func_150305_b(i);
            K key = keyFunction.apply((CompoundNBT)at);
            V value = valueFunction.apply((CompoundNBT)at);
            if (!keyFilter.test(key) || !valuePredicate.test(value)) continue;
            map.put(key, value);
        }
        return map;
    }

    public static JsonObject fromBlockState(BlockState state) {
        JsonObject object = new JsonObject();
        object.addProperty("name", Objects.requireNonNull(state.func_177230_c().getRegistryName()).toString());
        JsonObject properties = new JsonObject();
        state.func_206871_b().entrySet().stream().map(MapStreamSyntax.valuesBi(NBTBuilder::getPropertyName)).map(MapStreamSyntax.keys(IProperty::func_177701_a)).forEach(MapStreamSyntax.entry((arg_0, arg_1) -> ((JsonObject)properties).addProperty(arg_0, arg_1)));
        object.add("properties", (JsonElement)properties);
        return object;
    }

    public static Optional<BlockState> getStateFromJson(JsonObject object) {
        return Optional.ofNullable(ForgeRegistries.BLOCKS.getValue(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)object, (String)"name")))).filter(Predicate.isEqual(Blocks.field_150350_a).negate()).map(Block::func_176223_P).map(iBlockState -> {
            BlockState state = iBlockState;
            JsonObject properties = JSONUtils.func_152754_s((JsonObject)object, (String)"properties");
            Map map = iBlockState.func_206869_a().stream().map(MapStreamSyntax.toEntry(IProperty::func_177701_a, Function.identity())).collect(MapStreamSyntax.entryToMap());
            List collect = properties.entrySet().stream().map(MapStreamSyntax.values(JsonElement::getAsString)).map(MapStreamSyntax.keys(map::get)).filter(MapStreamSyntax.byKey(Objects::nonNull)).map(MapStreamSyntax.valuesBi(IProperty::func_185929_b)).flatMap(e -> Streams.stream((Optional)((Optional)e.getValue())).map(MapStreamSyntax.toEntry(o -> (IProperty)e.getKey(), Function.identity()))).collect(Collectors.toList());
            for (Map.Entry e2 : collect) {
                state = NBTBuilder.setValue(state, (IProperty)e2.getKey(), e2.getValue());
            }
            return state;
        });
    }

    private static <T extends Comparable<T>> String getPropertyName(IProperty<T> property, Comparable<?> entry) {
        return property.func_177702_a(entry);
    }

    private static <T extends Comparable<T>> BlockState setValue(BlockState state, IProperty<T> property, Object entry) {
        return (BlockState)state.func_206870_a(property, (Comparable)entry);
    }

    public NBTBuilder<T> setTag(Map.Entry<String, T> entry) {
        return this.setTag(entry.getKey(), (INBT)entry.getValue());
    }

    public NBTBuilder<T> setTag(String key, T value) {
        this.map.put(key, value);
        return this;
    }

    public static <T extends INBT> NBTBuilder<T> appendAll(NBTBuilder<T> b1, NBTBuilder<T> b2) {
        b1.map.putAll(b2.map);
        return b1;
    }

    public static NBTBuilder<INBT> empty() {
        return new NBTBuilder<INBT>();
    }

    public static <K extends INBT, T extends Map.Entry<String, K>> Collector<T, NBTBuilder<K>, CompoundNBT> toNBTTag() {
        return Collector.of(NBTBuilder::new, NBTBuilder::setTag, NBTBuilder::appendAll, NBTBuilder::toTag, Collector.Characteristics.UNORDERED);
    }

    public CompoundNBT toTag() {
        CompoundNBT tag = new CompoundNBT();
        this.map.forEach((arg_0, arg_1) -> ((CompoundNBT)tag).func_218657_a(arg_0, arg_1));
        return tag;
    }
}

