/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.advpump;

import com.yogpc.qp.Config;
import com.yogpc.qp.compat.BuildcraftHelper;
import com.yogpc.qp.machines.advpump.BlockItemAdvPump;
import com.yogpc.qp.machines.advpump.TileAdvPump;
import com.yogpc.qp.machines.base.IEnchantableTile;
import com.yogpc.qp.machines.base.QPBlock;
import com.yogpc.qp.machines.base.StatusContainer;
import com.yogpc.qp.utils.Holder;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class BlockAdvPump
extends QPBlock {
    public BlockAdvPump() {
        super(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(1.5f, 10.0f).func_200947_a(SoundType.field_185851_d), "standalonepump", BlockItemAdvPump::new);
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((IProperty)QPBlock.WORKING(), (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult hit) {
        if (super.func_225533_a_(state, worldIn, pos, playerIn, hand, hit).func_226247_b_()) {
            return ActionResultType.SUCCESS;
        }
        ItemStack stack = playerIn.func_184586_b(hand);
        if (Config.common().debug() && stack.func_77973_b() == Items.field_151055_y) {
            Optional.ofNullable((TileAdvPump)worldIn.func_175625_s(pos)).ifPresent(TileAdvPump::toggleDelete);
            playerIn.func_146105_b((ITextComponent)new StringTextComponent("Changed delete mode."), false);
            return ActionResultType.SUCCESS;
        }
        if (BuildcraftHelper.isWrench(playerIn, hand, stack, (RayTraceResult)hit)) {
            if (!worldIn.field_72995_K) {
                Optional.ofNullable((TileAdvPump)worldIn.func_175625_s(pos)).ifPresent(TileAdvPump::G_ReInit);
            }
            return ActionResultType.SUCCESS;
        }
        if (stack.func_77973_b() == Holder.itemStatusChecker()) {
            if (!worldIn.field_72995_K) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)playerIn), (INamedContainerProvider)new StatusContainer.ContainerProvider(pos), (BlockPos)pos);
            }
            return ActionResultType.SUCCESS;
        }
        if (!playerIn.func_213453_ef()) {
            if (!worldIn.field_72995_K) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)playerIn), (INamedContainerProvider)((TileAdvPump)worldIn.func_175625_s(pos)), (BlockPos)pos);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (!worldIn.field_72995_K) {
            Consumer<TileAdvPump> consumer = IEnchantableTile.Util.initConsumer(stack);
            Consumer<TileAdvPump> deleteSetter = pump -> Stream.iterate(pos.func_177977_b(), BlockPos::func_177977_b).filter(p -> !worldIn.func_175623_d(p) || p.func_177956_o() < 0).findFirst().map(arg_0 -> ((World)worldIn).func_204610_c(arg_0)).map(f -> f.func_206886_c().func_207185_a(FluidTags.field_206959_a)).ifPresent(pump::delete_$eq);
            Optional.ofNullable((TileAdvPump)worldIn.func_175625_s(pos)).ifPresent(consumer.andThen(deleteSetter).andThen(TileAdvPump.requestTicket));
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{QPBlock.WORKING()});
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        tooltip.add((ITextComponent)new TranslationTextComponent("quarryplus.tooltip.advpump", new Object[]{Character.valueOf(' ')}));
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity entity;
            if (!worldIn.field_72995_K && (entity = worldIn.func_175625_s(pos)) instanceof TileAdvPump) {
                TileAdvPump inventory = (TileAdvPump)entity;
                InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)inventory.moduleInv());
                worldIn.func_175666_e(pos, state.func_177230_c());
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    @Override
    public TileEntityType<? extends TileEntity> getTileType() {
        return Holder.advPumpType();
    }
}

