/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.base;

import com.yogpc.qp.Config;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.base.APacketTile;
import com.yogpc.qp.machines.base.DetailDataCollector;
import com.yogpc.qp.machines.base.EnergyDebug3;
import com.yogpc.qp.machines.base.EnergyUsage;
import com.yogpc.qp.machines.base.IChunkLoadTile;
import com.yogpc.qp.machines.base.MjReceiver;
import com.yogpc.qp.machines.base.QPBlock;
import com.yogpc.qp.machines.base.TextInClient;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.ModList;
import scala.Function1;

public abstract class APowerTile
extends APacketTile
implements ITickableTileEntity,
IEnergyStorage {
    public static final long MJToMicroMJ = 1000000L;
    public static final String NBT_STORED_ENERGY = "storedEnergy";
    public static final String NBT_MAX_STORED = "MAX_stored";
    public static final String NBT_MAX_RECEIVE = "MAX_receive";
    public static final String NBT_OUTPUT_ENERGY_INFO = "outputEnergyInfo";
    private long all;
    private long maxGot;
    private long max;
    private long got;
    private boolean ic2ok = false;
    private boolean chunkLoadRegistered = false;
    public boolean bcLoaded;
    public final boolean ic2Loaded;
    private Object helper;
    protected final EnergyDebug3 debug = EnergyDebug3.apply(((Object)((Object)this)).getClass().getSimpleName(), 100, this);
    public final DetailDataCollector collector = DetailDataCollector.getInstance(this);
    protected boolean outputEnergyInfo = true;
    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public TextInClient clientText;
    private static final Function1<String, Void> logFunction = v1 -> {
        QuarryPlus.LOGGER.info(v1);
        return null;
    };
    public static final long FEtoMicroJ = 100000L;

    public APowerTile(TileEntityType<?> type) {
        super(type);
        this.bcLoaded = ModList.get().isLoaded("buildcraftlib");
        this.ic2Loaded = ModList.get().isLoaded("ic2");
        if (this.bcLoaded) {
            this.helper = MjReceiver.mjCapabilityHelper(this);
        }
        this.startListener.add(this.debug::start);
        this.finishListener.add(() -> this.debug.finish().foreach(logFunction));
        this.finishListener.add(this.collector::finish);
    }

    public final void func_73660_a() {
        this.postLoadEvent();
        this.getEnergyInTick();
        this.all += this.got;
        if (this.func_145830_o() && !Objects.requireNonNull(this.func_145831_w()).field_72995_K && this.isWorking()) {
            this.debug.getAndTick(this.got).foreach(logFunction);
        }
        this.got = 0L;
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && this.enabled() && this.enabledByRS() && this.all >= 0L) {
            this.workInTick();
        }
    }

    protected abstract void workInTick();

    protected void getEnergyInTick() {
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.postUnLoadEvent();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && this.isWorking()) {
            this.finishWork();
        }
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.postUnLoadEvent();
    }

    private void postLoadEvent() {
        if (!Objects.requireNonNull(this.func_145831_w()).field_72995_K && !this.chunkLoadRegistered) {
            if (this instanceof IChunkLoadTile) {
                MinecraftForge.EVENT_BUS.register((Object)this);
            }
            this.chunkLoadRegistered = true;
        }
    }

    private void postUnLoadEvent() {
        if (!Objects.requireNonNull(this.func_145831_w()).field_72995_K && this.chunkLoadRegistered) {
            if (this instanceof IChunkLoadTile) {
                MinecraftForge.EVENT_BUS.unregister((Object)this);
            }
            this.chunkLoadRegistered = false;
        }
    }

    public final boolean isOutputEnergyInfo() {
        return this.outputEnergyInfo;
    }

    public final void toggleOutputEnergyInfo() {
        this.outputEnergyInfo = !this.outputEnergyInfo;
    }

    protected abstract boolean isWorking();

    protected boolean enabledByRS() {
        if (((Boolean)Config.common().enableRSControl().get()).booleanValue()) {
            return this.field_145850_b != null && !this.field_145850_b.func_175640_z(this.field_174879_c);
        }
        return true;
    }

    protected void updateWorkingState() {
        assert (this.field_145850_b != null);
        BlockState nowState = this.func_195044_w();
        if ((Boolean)nowState.func_177229_b((IProperty)QPBlock.WORKING()) ^ this.isWorking()) {
            if (this.isWorking()) {
                this.startWork();
            } else {
                this.finishWork();
            }
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)nowState.func_206870_a((IProperty)QPBlock.WORKING(), (Comparable)Boolean.valueOf(this.isWorking())));
        }
    }

    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        this.setStoredEnergy(nbt.func_74763_f(NBT_STORED_ENERGY));
        this.configure(nbt.func_74763_f(NBT_MAX_RECEIVE), nbt.func_74763_f(NBT_MAX_STORED));
        this.outputEnergyInfo = !nbt.func_74764_b(NBT_OUTPUT_ENERGY_INFO) || nbt.func_74767_n(NBT_OUTPUT_ENERGY_INFO);
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        nbt.func_74772_a(NBT_STORED_ENERGY, this.all);
        nbt.func_74772_a(NBT_MAX_STORED, this.max);
        nbt.func_74772_a(NBT_MAX_RECEIVE, this.maxGot);
        nbt.func_74757_a(NBT_OUTPUT_ENERGY_INFO, this.outputEnergyInfo);
        return super.func_189515_b(nbt);
    }

    @Deprecated
    public final long useEnergy(long min, long amount, boolean real, EnergyUsage usage) {
        if (((Boolean)Config.common().noEnergy().get()).booleanValue()) {
            this.debug.use(amount, !real, usage);
            return amount;
        }
        if (this.max < min) {
            if (real) {
                this.all = 0L;
                QuarryPlus.LOGGER.debug(String.format("%d energy requested for %s but it's over machine capacity.", new Object[]{min, usage}));
                this.debug.use(amount, false, usage);
            }
            return amount;
        }
        long res = 0L;
        if (this.all >= min) {
            if (this.all <= amount) {
                res = this.all;
                if (real) {
                    this.all = 0L;
                }
            } else {
                res = amount;
                if (real) {
                    this.all -= amount;
                }
            }
        }
        this.debug.use(res, !real, usage);
        return res;
    }

    public final long useEnergyForce(long amount, boolean real, EnergyUsage usage) {
        this.debug.use(amount, !real, usage);
        if (real) {
            this.all -= amount;
        }
        return amount;
    }

    protected final long getEnergy(long a, boolean real) {
        if (((Boolean)Config.common().noEnergy().get()).booleanValue()) {
            return 0L;
        }
        long ret = Math.min(Math.min(this.maxGot - this.got, this.max - this.all - this.got), a);
        if (real) {
            this.got += ret;
        }
        return ret;
    }

    protected final void getEnergy(long a, boolean real, boolean force) {
        if (!force) {
            this.getEnergy(a, real);
            return;
        }
        long ret = Math.min(this.max - this.all - this.got, a);
        if (real) {
            this.got += ret;
        }
    }

    public final long getStoredEnergy() {
        return this.all;
    }

    public final void setStoredEnergy(long all) {
        this.all = all;
    }

    public final long getMaxStored() {
        return this.max;
    }

    public final void configure(long maxReceive, long maxStored) {
        this.maxGot = maxReceive;
        this.max = maxStored;
        if (((Boolean)Config.common().noEnergy().get()).booleanValue()) {
            this.all = maxStored;
        }
    }

    public final int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        return (int)(this.getEnergy((long)maxReceive * 100000L, !simulate) / 100000L);
    }

    public final int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public final int getEnergyStored() {
        return (int)(this.all / 100000L);
    }

    public final int getMaxEnergyStored() {
        return (int)(this.max / 100000L);
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return LazyOptional.of(() -> this).cast();
        }
        return super.getCapability(cap, side);
    }
}

