/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.base;

import com.yogpc.qp.machines.base.Area;
import java.util.Objects;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface IRemotePowerOn {
    public void setArea(Area var1);

    default public Area getArea() {
        return Area.zeroArea();
    }

    public void startWorking();

    public void startWaiting();

    default public void setAndStart(Area area) {
        this.setArea(area);
        this.startWorking();
    }

    public static class RemotePowerOnImpl
    implements IRemotePowerOn {
        private static final Logger LOGGER = LogManager.getLogger(RemotePowerOnImpl.class);
        @Nonnull
        private Area area = Area.zeroArea();

        @Override
        public void setArea(@Nonnull Area area) {
            this.area = area;
        }

        @Override
        @Nonnull
        public Area getArea() {
            return this.area;
        }

        @Override
        public void startWorking() {
            LOGGER.info("Dummy RemotePowerOnImpl instance {} has started working.", (Object)this);
        }

        @Override
        public void startWaiting() {
            LOGGER.info("Dummy RemotePowerOnImpl instance {} has changed its mode to waiting.", (Object)this);
        }

        public String toString() {
            return "RemotePowerOnImpl{area=" + this.area + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RemotePowerOnImpl that = (RemotePowerOnImpl)o;
            return this.area.equals(that.area);
        }

        public int hashCode() {
            return Objects.hash(this.area);
        }
    }

    public static final class Cap
    implements Capability.IStorage<IRemotePowerOn>,
    Callable<IRemotePowerOn> {
        @CapabilityInject(value=IRemotePowerOn.class)
        public static final Capability<IRemotePowerOn> CAPABILITY = null;

        @Override
        public IRemotePowerOn call() {
            return new RemotePowerOnImpl();
        }

        public INBT writeNBT(Capability<IRemotePowerOn> capability, IRemotePowerOn instance, Direction side) {
            return new CompoundNBT();
        }

        public void readNBT(Capability<IRemotePowerOn> capability, IRemotePowerOn instance, Direction side, INBT nbt) {
        }

        public static Capability<IRemotePowerOn> REMOTE_CAPABILITY() {
            return CAPABILITY;
        }

        public static void register() {
            Cap cap = new Cap();
            CapabilityManager.INSTANCE.register(IRemotePowerOn.class, (Capability.IStorage)cap, (Callable)cap);
        }
    }
}

