/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.item;

import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.base.EnchantmentFilter;
import com.yogpc.qp.machines.base.IHandleButton;
import com.yogpc.qp.machines.base.QuarryBlackList;
import com.yogpc.qp.machines.item.ContainerEnchList;
import com.yogpc.qp.machines.item.GuiSlotEnchList;
import com.yogpc.qp.packet.PacketHandler;
import com.yogpc.qp.packet.mover.EnchantmentMessage;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.ConfirmScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import scala.jdk.javaapi.CollectionConverters;

@OnlyIn(value=Dist.CLIENT)
public class GuiEnchList
extends ContainerScreen<ContainerEnchList>
implements BooleanConsumer,
IHandleButton {
    public static final int Toggle_id = 10;
    public static final int Remove_id = 12;
    private GuiSlotEnchList slot;
    private final EnchantmentFilter.Accessor tile;
    private final Enchantment target;

    public GuiEnchList(ContainerEnchList c, PlayerInventory i, ITextComponent t) {
        super((Container)c, i, t);
        this.target = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(c.enchantmentName);
        this.tile = c.tile;
    }

    public boolean include() {
        if (this.target == Enchantments.field_185308_t) {
            return this.tile.enchantmentFilter().fortuneInclude();
        }
        return this.tile.enchantmentFilter().silktouchInclude();
    }

    private Set<QuarryBlackList.Entry> getBlockDataList(Enchantment enchantment) {
        if (enchantment == Enchantments.field_185306_r) {
            return CollectionConverters.asJava(this.tile.enchantmentFilter().silktouchList());
        }
        if (enchantment == Enchantments.field_185308_t) {
            return CollectionConverters.asJava(this.tile.enchantmentFilter().fortuneList());
        }
        QuarryPlus.LOGGER.error(String.format("GuiEnchList target is %s", enchantment));
        return Collections.emptySet();
    }

    public void init() {
        this.field_146999_f = this.width;
        this.field_147000_g = this.height;
        super.init();
        this.addButton((Widget)new IHandleButton.Button(-1, this.width / 2 - 125, this.height - 26, 250, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]), this));
        this.addButton((Widget)new IHandleButton.Button(10, this.width * 2 / 3 + 10, 140, 100, 20, "", this));
        this.addButton((Widget)new IHandleButton.Button(12, this.width * 2 / 3 + 10, 110, 100, 20, I18n.func_135052_a((String)"selectServer.delete", (Object[])new Object[0]), this));
        this.slot = new GuiSlotEnchList(this.getMinecraft(), this.width * 3 / 5, this.height - 60, 30, this.height - 30, 18, this);
        this.children.add(this.slot);
        this.setFocused((IGuiEventListener)this.slot);
    }

    @Override
    public void actionPerformed(IHandleButton.Button par1) {
        switch (par1.id) {
            case -1: {
                this.getMinecraft().field_71439_g.func_71053_j();
                break;
            }
            case 12: {
                this.getMinecraft().func_147108_a((Screen)new ConfirmScreen((BooleanConsumer)this, (ITextComponent)new TranslationTextComponent("tof.deleteblocksure", new Object[0]), (ITextComponent)new StringTextComponent(Optional.ofNullable(this.slot.getSelected()).map(GuiSlotEnchList.Entry::getData).map(Object::toString).orElse("None"))));
                break;
            }
            default: {
                PacketHandler.sendToServer(EnchantmentMessage.create(this.tile, EnchantmentMessage.Type.Toggle, this.target, new QuarryBlackList.Name(new ResourceLocation("dummy:toggle_button"))));
            }
        }
    }

    public void accept(boolean result) {
        GuiSlotEnchList.Entry selected = (GuiSlotEnchList.Entry)this.slot.getSelected();
        if (selected != null && result) {
            QuarryBlackList.Entry entry = selected.getData();
            PacketHandler.sendToServer(EnchantmentMessage.create(this.tile, EnchantmentMessage.Type.Remove, this.target, entry));
            if (this.target == Enchantments.field_185306_r) {
                this.tile.enchantmentFilter_$eq(this.tile.enchantmentFilter().removeSilktouch(entry));
            } else if (this.target == Enchantments.field_185308_t) {
                this.tile.enchantmentFilter_$eq(this.tile.enchantmentFilter().removeFortune(entry));
            }
            this.refreshList();
        }
        this.getMinecraft().func_147108_a((Screen)this);
    }

    public void refreshList() {
        this.slot.refreshList();
        this.slot.setSelected(null);
    }

    protected void func_146976_a(float k, int i, int j) {
        if (this.slot != null) {
            this.slot.render(i, j, k);
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        super.render(mouseX, mouseY, partialTicks);
    }

    protected void func_146979_b(int i, int j) {
        this.drawCenteredString(this.font, I18n.func_135052_a((String)"qp.list.setting", (Object[])new Object[]{I18n.func_135052_a((String)this.target.func_77320_a(), (Object[])new Object[0])}), this.field_146999_f / 2, 8, 0xFFFFFF);
    }

    public void tick() {
        super.tick();
        ((Widget)this.buttons.get(1)).setMessage(I18n.func_135052_a((String)(this.include() ? "tof.include" : "tof.exclude"), (Object[])new Object[0]));
        ((Widget)this.buttons.get((int)2)).active = !this.getBlockDataList(this.target).isEmpty();
    }

    public void buildModList(Consumer<GuiSlotEnchList.Entry> modListViewConsumer, Function<QuarryBlackList.Entry, GuiSlotEnchList.Entry> newEntry) {
        this.getBlockDataList(this.target).stream().map(newEntry).forEach(modListViewConsumer);
    }
}

