/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.item;

import com.mojang.blaze3d.systems.RenderSystem;
import com.yogpc.qp.machines.base.IHandleButton;
import com.yogpc.qp.machines.base.QuarryBlackList;
import com.yogpc.qp.machines.item.ContainerListTemplate;
import com.yogpc.qp.machines.item.ItemTemplate;
import com.yogpc.qp.packet.PacketHandler;
import com.yogpc.qp.packet.listtemplate.TemplateMessage;
import com.yogpc.qp.utils.Holder;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import scala.jdk.javaapi.CollectionConverters;

public class GuiListTemplate
extends ContainerScreen<ContainerListTemplate>
implements IHandleButton {
    private static final ResourceLocation LOCATION = new ResourceLocation("quarryplus", "textures/gui/template.png");
    private final PlayerEntity player;
    private ItemList itemList;
    private ItemTemplate.Template template = ItemTemplate.EmPlate();

    public GuiListTemplate(ContainerListTemplate c, PlayerInventory i, ITextComponent t) {
        super((Container)c, i, t);
        this.player = i.field_70458_d;
        this.field_146999_f = 176;
        this.field_147000_g = 217;
        ItemStack stack = this.player.field_71071_by.func_70448_g();
        if (stack.func_77973_b() == Holder.itemTemplate()) {
            this.template = ItemTemplate.getTemplate(stack);
        }
    }

    public void init() {
        super.init();
        this.itemList = new ItemList(this.getMinecraft(), this.field_147003_i + 8, this.field_147003_i + 133, 0, this.field_147009_r + 8, this.field_147009_r + 114, 18);
        this.children.add(this.itemList);
        this.setFocused((IGuiEventListener)this.itemList);
        int id = 0;
        int buttonHeight = 20;
        int buttonWidth = 40;
        this.addButton((Widget)new IHandleButton.Button(id++, this.field_147003_i + 132, this.field_147009_r + 110, buttonWidth, buttonHeight, I18n.func_135052_a((String)"tof.addnewore", (Object[])new Object[0]), this));
        this.addButton((Widget)new IHandleButton.Button(id++, this.field_147003_i + 132, this.field_147009_r + 42, buttonWidth, buttonHeight, I18n.func_135052_a((String)"selectServer.delete", (Object[])new Object[0]), this));
        this.addButton((Widget)new IHandleButton.Button(id++, this.field_147003_i + 132, this.field_147009_r + 42 + buttonHeight, buttonWidth, buttonHeight, "", this));
        assert (id > 0);
        this.buttonText();
    }

    protected void buttonText() {
        if (this.template.include()) {
            ((Widget)this.buttons.get(2)).setMessage(I18n.func_135052_a((String)"tof.include", (Object[])new Object[0]));
        } else {
            ((Widget)this.buttons.get(2)).setMessage(I18n.func_135052_a((String)"tof.exclude", (Object[])new Object[0]));
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().func_110434_K().func_110577_a(LOCATION);
        this.blit(this.width - this.field_146999_f >> 1, this.height - this.field_147000_g >> 1, 0, 0, this.field_146999_f, this.field_147000_g);
        this.itemList.render(mouseX, mouseY, partialTicks);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.font.func_211126_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8.0f, (float)(this.field_147000_g - 96 + 2), 0x404040);
    }

    public void removed() {
        PacketHandler.sendToServer(TemplateMessage.create(this.player.field_71071_by.field_70461_c, this.template));
        super.removed();
    }

    public void onClose() {
        PacketHandler.sendToServer(TemplateMessage.create(this.player.field_71071_by.field_70461_c, this.template));
        super.onClose();
    }

    @Override
    public void actionPerformed(IHandleButton.Button button) {
        switch (button.id) {
            case 0: {
                ItemStack stack = (ItemStack)((ContainerListTemplate)this.func_212873_a_()).func_75138_a().get(0);
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof BlockItem)) break;
                QuarryBlackList.Name data2 = new QuarryBlackList.Name(stack.func_77973_b().getRegistryName());
                if (this.template.entries().contains((Object)data2)) break;
                this.template = this.template.add(data2);
                break;
            }
            case 1: {
                Optional.ofNullable(this.itemList.getSelected()).map(entry -> ((ItemList.Entry)entry).data).ifPresent(data -> {
                    this.template = this.template.remove((QuarryBlackList.Entry)data);
                });
                break;
            }
            case 2: {
                this.template = this.template.toggle();
                this.buttonText();
            }
        }
        this.itemList.refresh();
    }

    private <T extends ExtendedList.AbstractListEntry<T>> void refreshList(Consumer<T> modListViewConsumer, Function<QuarryBlackList.Entry, T> newEntry) {
        CollectionConverters.asJava(this.template.entries()).stream().map(newEntry).forEach(modListViewConsumer);
    }

    private class ItemList
    extends ExtendedList<Entry> {
        public ItemList(Minecraft mcIn, int left, int right, int height, int topIn, int bottomIn, int slotHeightIn) {
            super(mcIn, -left + right, height, topIn, bottomIn, slotHeightIn);
            assert (right > left);
            this.x0 = left;
            this.x1 = right;
            this.refresh();
        }

        public void refresh() {
            this.clearEntries();
            GuiListTemplate.this.refreshList(arg_0 -> ((ItemList)this).addEntry(arg_0), x$0 -> new Entry((QuarryBlackList.Entry)x$0));
        }

        public int getRowWidth() {
            return this.x1 - this.x0;
        }

        protected int getScrollbarPosition() {
            return this.x1 - 6;
        }

        protected void renderHoleBackground(int p_renderHoleBackground_1_, int p_renderHoleBackground_2_, int p_renderHoleBackground_3_, int p_renderHoleBackground_4_) {
        }

        private class Entry
        extends ExtendedList.AbstractListEntry<Entry> {
            private final QuarryBlackList.Entry data;

            public Entry(QuarryBlackList.Entry data) {
                this.data = data;
            }

            public void render(int entryIdx, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean p_render_8_, float partialTicks) {
                ItemList.this.drawString(((ItemList)ItemList.this).minecraft.field_71466_p, this.data.toString(), left, top + 3, 0xFFFFFF);
            }

            public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
                ItemList.this.setSelected((AbstractList.AbstractListEntry)this);
                return false;
            }
        }
    }
}

