/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.mini_quarry;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.base.IHandleButton;
import com.yogpc.qp.machines.base.QuarryBlackList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.InputMappings;
import net.minecraft.command.arguments.BlockStateParser;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class MiniQuarryAddEntryGui
extends Screen
implements IHandleButton {
    @Nonnull
    private final Screen parent;
    private final Consumer<QuarryBlackList.Entry> callback;
    private EntryList list;
    private TextFieldWidget textField;

    protected MiniQuarryAddEntryGui(Screen parent, Consumer<QuarryBlackList.Entry> callback) {
        super(parent.getTitle());
        this.parent = parent;
        this.callback = callback;
    }

    protected void init() {
        super.init();
        int buttonWidth = 80;
        this.textField = new TextFieldWidget(this.font, this.width / 2 - 125, this.height - 56, 250, 20, "");
        this.textField.func_146203_f(512);
        this.list = new EntryList(this.minecraft, this.width, this.height, 30, this.height - 70, 18, this, this::getEntries);
        this.addButton((Widget)new IHandleButton.Button(1, this.width / 2 - buttonWidth / 2, this.height - 35, buttonWidth, 20, I18n.func_135052_a((String)"tof.addnewore", (Object[])new Object[0]), this));
        this.children.add(this.list);
        this.children.add(this.textField);
        this.setFocused((IGuiEventListener)this.list);
        this.textField.func_146205_d(true);
        this.textField.func_212954_a(s -> {
            this.list.updateList();
            this.list.setScrollAmount(this.list.getScrollAmount());
        });
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.list.render(mouseX, mouseY, partialTicks);
        this.textField.render(mouseX, mouseY, partialTicks);
        super.render(mouseX, mouseY, partialTicks);
        String title = I18n.func_135052_a((String)"quarryplus.gui.new_entry", (Object[])new Object[0]);
        this.drawCenteredString(this.font, title, this.width / 2, 8, 0xFFFFFF);
    }

    private Pair<Kind, List<ResourceLocation>> getEntries() {
        String filterText;
        String string = filterText = this.textField == null ? "" : this.textField.func_146179_b();
        if (filterText.startsWith("#")) {
            String f = filterText.substring(1);
            return Pair.of((Object)((Object)Kind.TAG), BlockTags.func_199896_a().func_199908_a().stream().filter(r -> r.toString().contains(f)).sorted().collect(Collectors.toList()));
        }
        return Pair.of((Object)((Object)Kind.BLOCK), ForgeRegistries.BLOCKS.getKeys().stream().filter(r -> r.toString().contains(filterText)).sorted().collect(Collectors.toList()));
    }

    @Override
    public void actionPerformed(IHandleButton.Button button) {
        if (button.id == 1) {
            LocationEntry entry = (LocationEntry)this.list.getSelected();
            if (entry != null) {
                ResourceLocation location = entry.getData();
                switch (entry.getKind()) {
                    case BLOCK: {
                        this.callback.accept(new QuarryBlackList.Name(location));
                        break;
                    }
                    case TAG: {
                        this.callback.accept(new QuarryBlackList.Tag(location));
                        break;
                    }
                    default: {
                        QuarryPlus.LOGGER.warn("Not registered kind {} for {}.", (Object)entry.getKind(), (Object)location);
                        break;
                    }
                }
            } else {
                String maybePredicate = this.textField.func_146179_b();
                if (!maybePredicate.isEmpty()) {
                    try {
                        new BlockStateParser(new StringReader(maybePredicate), true).func_197243_a(true);
                        this.callback.accept(new QuarryBlackList.VanillaBlockPredicate(maybePredicate));
                    }
                    catch (CommandSyntaxException e) {
                        QuarryPlus.LOGGER.debug("Invalid predicate {} was parsed but not added. Got {}.", (Object)maybePredicate, (Object)e);
                    }
                }
            }
            this.onClose();
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        InputMappings.Input mouseKey = InputMappings.func_197954_a((int)keyCode, (int)scanCode);
        if (keyCode == 256 || !this.textField.isFocused() && this.getMinecraft().field_71474_y.field_151445_Q.isActiveAndMatches(mouseKey)) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void onClose() {
        this.getMinecraft().func_147108_a(this.parent);
    }

    private static enum Kind {
        BLOCK,
        TAG;

    }

    static class LocationEntry
    extends ExtendedList.AbstractListEntry<LocationEntry> {
        private final ResourceLocation data;
        private final Screen parent;
        private final Consumer<LocationEntry> setSelected;
        private final Kind kind;

        LocationEntry(ResourceLocation data, Screen parent, Consumer<LocationEntry> setSelected, Kind kind) {
            this.data = data;
            this.parent = parent;
            this.setSelected = setSelected;
            this.kind = kind;
        }

        public ResourceLocation getData() {
            return this.data;
        }

        public Kind getKind() {
            return this.kind;
        }

        public void render(int entryIdx, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean p_render_8_, float partialTicks) {
            String name = (this.kind == Kind.TAG ? "#" : "") + this.data.toString();
            Minecraft.func_71410_x().field_71466_p.func_175063_a(name, (float)((this.parent.width - Minecraft.func_71410_x().field_71466_p.func_78256_a(name)) / 2), (float)(top + 2), 0xFFFFFF);
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            this.setSelected.accept(this);
            return false;
        }
    }

    static class EntryList
    extends ExtendedList<LocationEntry> {
        private final Screen parent;
        private final Supplier<Pair<Kind, List<ResourceLocation>>> entriesSupplier;

        public EntryList(Minecraft mcIn, int widthIn, int heightIn, int topIn, int bottomIn, int slotHeightIn, Screen parent, Supplier<Pair<Kind, List<ResourceLocation>>> entriesSupplier) {
            super(mcIn, widthIn, heightIn, topIn, bottomIn, slotHeightIn);
            this.parent = parent;
            this.entriesSupplier = entriesSupplier;
            this.updateList();
        }

        public void updateList() {
            this.clearEntries();
            Pair<Kind, List<ResourceLocation>> kindListPair = this.entriesSupplier.get();
            ((List)kindListPair.getValue()).stream().map(e -> new LocationEntry((ResourceLocation)e, this.parent, arg_0 -> ((EntryList)this).setSelected(arg_0), (Kind)((Object)((Object)kindListPair.getKey())))).forEach(arg_0 -> ((EntryList)this).addEntry(arg_0));
        }
    }
}

