/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.mini_quarry;

import com.yogpc.qp.machines.base.IHandleButton;
import com.yogpc.qp.machines.base.QuarryBlackList;
import com.yogpc.qp.machines.mini_quarry.EntryList;
import com.yogpc.qp.machines.mini_quarry.MiniQuarryAddEntryGui;
import com.yogpc.qp.machines.mini_quarry.MiniQuarryListEntry;
import com.yogpc.qp.machines.mini_quarry.MiniQuarryTile;
import com.yogpc.qp.packet.IMessage;
import com.yogpc.qp.packet.PacketHandler;
import com.yogpc.qp.packet.mini_quarry.MiniListSyncMessage;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.math.BlockPos;

public class MiniQuarryListGui
extends Screen
implements IHandleButton {
    final List<QuarryBlackList.Entry> whiteList;
    final List<QuarryBlackList.Entry> blackList;
    private final BlockPos pos;
    private final int dim;
    EntryList list;
    boolean whiteListFlag = true;

    public MiniQuarryListGui(MiniQuarryTile tile, Collection<QuarryBlackList.Entry> whiteList, Collection<QuarryBlackList.Entry> blackList) {
        super(tile.func_145748_c_());
        this.whiteList = whiteList.stream().sorted(Comparator.comparing(Object::toString)).collect(Collectors.toList());
        this.blackList = blackList.stream().sorted(Comparator.comparing(Object::toString)).collect(Collectors.toList());
        this.pos = tile.func_174877_v();
        this.dim = IMessage.getDimId(tile.func_145831_w());
    }

    protected void init() {
        super.init();
        int buttonWidth = 80;
        this.addButton((Widget)new IHandleButton.Button(0, this.width / 3 - buttonWidth / 2, this.height - 35, buttonWidth, 20, I18n.func_135052_a((String)"quarryplus.gui.blacklist", (Object[])new Object[0]), this));
        this.addButton((Widget)new IHandleButton.Button(1, this.width / 3 * 2 - buttonWidth / 2, this.height - 35, buttonWidth, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]), this));
        this.addButton((Widget)new IHandleButton.Button(2, this.width / 2 - buttonWidth, this.height - 60, buttonWidth, 20, I18n.func_135052_a((String)"quarryplus.gui.new_entry", (Object[])new Object[0]), this));
        this.addButton((Widget)new IHandleButton.Button(3, this.width / 2, this.height - 60, buttonWidth, 20, I18n.func_135052_a((String)"selectWorld.delete", (Object[])new Object[0]), this));
        this.list = new EntryList(this.minecraft, this.width, this.height, 30, this.height - 70, 18, this, this::getEntries);
        this.children.add(this.list);
        this.setFocused((IGuiEventListener)this.list);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.list.render(mouseX, mouseY, partialTicks);
        super.render(mouseX, mouseY, partialTicks);
        String listName = this.whiteListFlag ? I18n.func_135052_a((String)"quarryplus.gui.whitelist", (Object[])new Object[0]) : I18n.func_135052_a((String)"quarryplus.gui.blacklist", (Object[])new Object[0]);
        String title = I18n.func_135052_a((String)"quarryplus.gui.of", (Object[])new Object[]{listName, super.getTitle().func_150254_d()});
        this.drawCenteredString(this.font, title, this.width / 2, 8, 0xFFFFFF);
    }

    public List<QuarryBlackList.Entry> getEntries() {
        if (this.whiteListFlag) {
            return this.whiteList;
        }
        return this.blackList;
    }

    public void setWhiteListFlag(boolean whiteListFlag) {
        this.whiteListFlag = whiteListFlag;
        this.list.updateList();
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (super.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        InputMappings.Input mouseKey = InputMappings.func_197954_a((int)keyCode, (int)scanCode);
        assert (this.minecraft != null);
        if (this.minecraft.field_71474_y.field_151445_Q.isActiveAndMatches(mouseKey)) {
            assert (this.minecraft.field_71439_g != null);
            this.minecraft.field_71439_g.func_71053_j();
            return true;
        }
        return false;
    }

    @Override
    public void actionPerformed(IHandleButton.Button button) {
        switch (button.id) {
            case 0: {
                this.setWhiteListFlag(!this.whiteListFlag);
                button.setMessage(this.whiteListFlag ? I18n.func_135052_a((String)"quarryplus.gui.blacklist", (Object[])new Object[0]) : I18n.func_135052_a((String)"quarryplus.gui.whitelist", (Object[])new Object[0]));
                break;
            }
            case 1: {
                assert (this.minecraft != null);
                assert (this.minecraft.field_71439_g != null);
                this.minecraft.field_71439_g.func_71053_j();
                break;
            }
            case 2: {
                this.getMinecraft().func_147108_a((Screen)new MiniQuarryAddEntryGui(this, e -> {
                    this.getEntries().add((QuarryBlackList.Entry)e);
                    this.list.updateList();
                    PacketHandler.sendToServer(MiniListSyncMessage.create(this.pos, this.dim, this.blackList, this.whiteList));
                }));
                break;
            }
            case 3: {
                MiniQuarryListEntry selected = (MiniQuarryListEntry)this.list.getSelected();
                if (selected == null) break;
                QuarryBlackList.Entry data = selected.getData();
                if (MiniQuarryTile.defaultBlackList().contains((Object)data)) break;
                this.getEntries().remove(data);
                this.list.updateList();
                PacketHandler.sendToServer(MiniListSyncMessage.create(this.pos, this.dim, this.blackList, this.whiteList));
            }
        }
    }
}

