/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.pb;

import com.yogpc.qp.compat.InvUtils;
import com.yogpc.qp.machines.base.QPBlock;
import com.yogpc.qp.machines.pb.PlacerTile;
import com.yogpc.qp.utils.Holder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import jp.t2v.lab.syntax.MapStreamSyntax;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class PlacerBlock
extends QPBlock {
    private static final Direction[] DIRECTIONS = (Direction[])Direction.values().clone();

    public PlacerBlock() {
        super(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(1.2f), "placer_plus", BlockItem::new);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((IProperty)BlockStateProperties.field_208155_H, (Comparable)Direction.NORTH)).func_206870_a((IProperty)BlockStateProperties.field_208197_x, (Comparable)Boolean.FALSE));
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (super.func_225533_a_(state, worldIn, pos, player, hand, hit).func_226247_b_()) {
            return ActionResultType.SUCCESS;
        }
        if (!player.func_213453_ef()) {
            if (!worldIn.field_72995_K) {
                ItemStack stack = player.func_184586_b(hand);
                if (stack.func_77973_b() == Items.field_221764_cr) {
                    Optional.ofNullable((PlacerTile)worldIn.func_175625_s(pos)).ifPresent(t -> {
                        t.cycleRedstoneMode();
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("quarryplus.chat.placer_rs", new Object[]{t.redstoneMode}), false);
                    });
                } else {
                    Optional.ofNullable((PlacerTile)worldIn.func_175625_s(pos)).ifPresent(o -> NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)o, (BlockPos)pos));
                }
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            InvUtils.dropAndUpdateInv(worldIn, pos, (PlacerTile)worldIn.func_175625_s(pos), (Block)this);
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    @Override
    public TileEntityType<? extends TileEntity> getTileType() {
        return Holder.placerType();
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208155_H, (Comparable)context.func_196010_d().func_176734_d());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{BlockStateProperties.field_208155_H, BlockStateProperties.field_208197_x});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        if (Screen.hasShiftDown()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("quarryplus.tooltip.placer_plus", new Object[0]));
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        super.func_225534_a_(state, worldIn, pos, rand);
        Direction facing = (Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208155_H);
        boolean isPowered = (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208197_x);
        Optional<PlacerTile> tile = Optional.ofNullable(worldIn.func_175625_s(pos)).flatMap(MapStreamSyntax.optCast(PlacerTile.class));
        if (worldIn.func_175623_d(pos.func_177972_a(facing)) && isPowered) {
            tile.ifPresent(PlacerTile::placeBlock);
        } else if (!isPowered) {
            tile.ifPresent(PlacerTile::breakBlock);
        }
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.func_220069_a(state, worldIn, pos, blockIn, fromPos, isMoving);
        Direction facing = (Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208155_H);
        boolean poweredNow = PlacerBlock.isPoweredToWork(worldIn, pos, facing);
        boolean poweredOld = (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208197_x);
        if (poweredNow && !poweredOld) {
            if (Optional.ofNullable(worldIn.func_175625_s(pos)).flatMap(MapStreamSyntax.optCast(PlacerTile.class)).filter(p -> p.redstoneMode.isPulse()).isPresent()) {
                worldIn.func_205220_G_().func_205360_a(pos, (Object)this, this.func_149738_a((IWorldReader)worldIn));
            }
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208197_x, (Comparable)Boolean.TRUE), 4);
        } else if (!poweredNow && poweredOld) {
            if (Optional.ofNullable(worldIn.func_175625_s(pos)).flatMap(MapStreamSyntax.optCast(PlacerTile.class)).filter(p -> p.redstoneMode.isPulse()).isPresent()) {
                worldIn.func_205220_G_().func_205360_a(pos, (Object)this, this.func_149738_a((IWorldReader)worldIn));
            }
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208197_x, (Comparable)Boolean.FALSE), 4);
        }
    }

    public static boolean isPoweredToWork(World worldIn, BlockPos pos, Direction currentFacing) {
        return Arrays.stream(DIRECTIONS).filter(Predicate.isEqual(currentFacing).negate()).anyMatch(f -> worldIn.func_175709_b(pos.func_177972_a(f), f)) || worldIn.func_175640_z(pos.func_177984_a());
    }

    public int func_149738_a(IWorldReader worldIn) {
        return 1;
    }
}

