/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.test;

import com.yogpc.qp.machines.workbench.WorkbenchRecipes;
import com.yogpc.qp.utils.Holder;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import scala.jdk.javaapi.CollectionConverters;

class ItemAccessTest {
    ItemAccessTest() {
    }

    @Test
    void exist() {
        Item item = Holder.itemStatusChecker();
        Assertions.assertEquals((Object)new ResourceLocation("quarryplus", "statuschecker"), (Object)item.getRegistryName());
    }

    @Test
    void myItemsInForgeRegistry() {
        IForgeRegistry blocks = ForgeRegistries.BLOCKS;
        Assertions.assertTrue((boolean)CollectionConverters.asJava(Holder.blocks()).stream().allMatch(arg_0 -> ((IForgeRegistry)blocks).containsValue(arg_0)), (String)"All blocks are in forge registry.");
        IForgeRegistry items = ForgeRegistries.ITEMS;
        Assertions.assertTrue((boolean)CollectionConverters.asJava(Holder.items()).stream().allMatch(arg_0 -> ((IForgeRegistry)items).containsValue(arg_0)), (String)"All items are in registry.");
    }

    @Test
    void accessToClass() {
        Assertions.assertDoesNotThrow(() -> new ItemStack((IItemProvider)Items.field_205158_fa));
        WorkbenchRecipes recipes2 = WorkbenchRecipes.dummyRecipe();
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertTrue((boolean)recipes2.func_77571_b().func_190926_b()), () -> Assertions.assertFalse((boolean)recipes2.hasContent())});
    }

    @Test
    void CANT_AccessToCapability() {
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertNull((Object)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY), () -> Assertions.assertNull((Object)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY), () -> Assertions.assertNull((Object)CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY), () -> Assertions.assertNull((Object)CapabilityEnergy.ENERGY)});
    }
}

