/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.utils;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.resources.ReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class JsonReloadListener
extends ReloadListener<Map<ResourceLocation, JsonElement>> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int JSON_EXTENSION_LENGTH = ".json".length();
    private final Gson gson;
    private final String folder;

    public JsonReloadListener(Gson gson, String folder) {
        this.gson = gson;
        this.folder = folder;
    }

    protected Map<ResourceLocation, JsonElement> prepare(IResourceManager resourceManagerIn, IProfiler profilerIn) {
        HashMap map = Maps.newHashMap();
        int i = this.folder.length() + 1;
        for (ResourceLocation dataPath : resourceManagerIn.func_199003_a(this.folder, s -> !s.startsWith("_") && s.endsWith(".json"))) {
            String s2 = dataPath.func_110623_a();
            ResourceLocation location = new ResourceLocation(dataPath.func_110624_b(), s2.substring(i, s2.length() - JSON_EXTENSION_LENGTH));
            try {
                IResource iresource = resourceManagerIn.func_199002_a(dataPath);
                Throwable throwable = null;
                try {
                    InputStream inputstream = iresource.func_199027_b();
                    Throwable throwable2 = null;
                    try {
                        BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));
                        Throwable throwable3 = null;
                        try {
                            JsonElement element = (JsonElement)JSONUtils.func_193839_a((Gson)this.gson, (Reader)reader, JsonElement.class);
                            if (element != null) {
                                JsonElement put = map.put(location, element);
                                if (put == null) continue;
                                throw new IllegalStateException("Duplicate data file ignored with ID " + location);
                            }
                            LOGGER.error("Couldn't load data file {} from {} as it's null or empty", (Object)location, (Object)dataPath);
                        }
                        catch (Throwable throwable4) {
                            throwable3 = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (reader == null) continue;
                            if (throwable3 != null) {
                                try {
                                    ((Reader)reader).close();
                                }
                                catch (Throwable throwable5) {
                                    throwable3.addSuppressed(throwable5);
                                }
                                continue;
                            }
                            ((Reader)reader).close();
                        }
                    }
                    catch (Throwable throwable6) {
                        throwable2 = throwable6;
                        throw throwable6;
                    }
                    finally {
                        if (inputstream == null) continue;
                        if (throwable2 != null) {
                            try {
                                inputstream.close();
                            }
                            catch (Throwable throwable7) {
                                throwable2.addSuppressed(throwable7);
                            }
                            continue;
                        }
                        inputstream.close();
                    }
                }
                catch (Throwable throwable8) {
                    throwable = throwable8;
                    throw throwable8;
                }
                finally {
                    if (iresource == null) continue;
                    if (throwable != null) {
                        try {
                            iresource.close();
                        }
                        catch (Throwable throwable9) {
                            throwable.addSuppressed(throwable9);
                        }
                        continue;
                    }
                    iresource.close();
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException e) {
                LOGGER.error("Couldn't parse data file {} from {}", (Object)location, (Object)dataPath, (Object)e);
            }
        }
        return map;
    }
}

