/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.base;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.yogpc.qp.Config;
import com.yogpc.qp.machines.TranslationKeys;
import com.yogpc.qp.machines.bookmover.BlockBookMover;
import com.yogpc.qp.utils.Holder;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import jp.t2v.lab.syntax.MapStreamSyntax;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootFunction;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public interface IEnchantableTile {
    public static final ResourceLocation FortuneID = ForgeRegistries.ENCHANTMENTS.getKey((IForgeRegistryEntry)Enchantments.field_185308_t);
    public static final ResourceLocation SilktouchID = ForgeRegistries.ENCHANTMENTS.getKey((IForgeRegistryEntry)Enchantments.field_185306_r);
    public static final ResourceLocation EfficiencyID = ForgeRegistries.ENCHANTMENTS.getKey((IForgeRegistryEntry)Enchantments.field_185305_q);
    public static final ResourceLocation UnbreakingID = ForgeRegistries.ENCHANTMENTS.getKey((IForgeRegistryEntry)Enchantments.field_185307_s);
    public static final BiPredicate<ResourceLocation, Integer> isValidEnch = (id, level) -> {
        if (id.equals((Object)FortuneID) || id.equals((Object)UnbreakingID)) {
            return level <= 3;
        }
        if (id.equals((Object)EfficiencyID)) {
            return level <= 5;
        }
        return id.equals((Object)SilktouchID) && level == 1;
    };

    public void G_ReInit();

    @Nonnull
    public Map<ResourceLocation, Integer> getEnchantments();

    public void setEnchantment(ResourceLocation var1, short var2);

    default public void sendEnchantMassage(PlayerEntity player) {
        Util.getEnchantmentsChat(this).forEach(c -> player.func_146105_b(c, false));
    }

    default public ItemStack getEnchantedPickaxe() {
        return this.getEnchantedPickaxe(MapStreamSyntax.always_true());
    }

    default public ItemStack getEnchantedPickaxe(Predicate<? super Enchantment> predicate) {
        ItemStack stack = new ItemStack((IItemProvider)Holder.itemQuarryPickaxe());
        this.getEnchantments().entrySet().stream().filter(MapStreamSyntax.byEntry(((Boolean)((ForgeConfigSpec.BooleanValue)Config.common().disabled().apply((Object)BlockBookMover.SYMBOL)).get()).booleanValue() ? isValidEnch : (k, v) -> true)).map(MapStreamSyntax.keys(arg_0 -> ((IForgeRegistry)ForgeRegistries.ENCHANTMENTS).getValue(arg_0))).filter(MapStreamSyntax.byKey(Objects::nonNull)).filter(MapStreamSyntax.byKey(predicate)).forEach(MapStreamSyntax.entry((arg_0, arg_1) -> ((ItemStack)stack).func_77966_a(arg_0, arg_1)));
        return stack;
    }

    public static class DropFunction
    extends LootFunction {
        public static final ResourceLocation LOCATION = new ResourceLocation("quarryplus", "drop_function");

        public static LootFunction.Builder<?> builder() {
            return LootFunction.func_215860_a(DropFunction::new);
        }

        protected DropFunction(ILootCondition[] conditionsIn) {
            super(conditionsIn);
        }

        protected ItemStack func_215859_a(ItemStack stack, LootContext context) {
            Optional.ofNullable(context.func_216031_c(LootParameters.field_216288_h)).flatMap(MapStreamSyntax.optCast(IEnchantableTile.class)).ifPresent(t -> Util.enchantmentToIS(t, stack));
            return stack;
        }

        public LootFunctionType func_230425_b_() {
            return Holder.dropLootFunctionType();
        }

        public static class Serializer
        extends LootFunction.Serializer<DropFunction> {
            public DropFunction deserialize(JsonObject object, JsonDeserializationContext deserializationContext, ILootCondition[] conditionsIn) {
                return new DropFunction(conditionsIn);
            }
        }
    }

    public static class Util {
        public static void init(@Nonnull IEnchantableTile te, @Nonnull ListNBT tagList) {
            tagList.stream().map(CompoundNBT.class::cast).map(MapStreamSyntax.toEntry(n -> n.func_74779_i("id"), n -> n.func_74765_d("lvl"))).map(MapStreamSyntax.keys(ResourceLocation::new)).forEach(MapStreamSyntax.entry(te::setEnchantment));
            te.G_ReInit();
        }

        static List<ITextComponent> getEnchantmentsChat(@Nonnull IEnchantableTile te) {
            Map<ResourceLocation, Integer> enchantments = te.getEnchantments();
            if (enchantments.size() <= 0) {
                return Collections.singletonList(new TranslationTextComponent("chat.plusenchantno"));
            }
            LinkedList collect = enchantments.entrySet().stream().map(MapStreamSyntax.keys(arg_0 -> ((IForgeRegistry)ForgeRegistries.ENCHANTMENTS).getValue(arg_0))).filter(MapStreamSyntax.byKey(Objects::nonNull)).map(MapStreamSyntax.toAny((enchantment, level) -> new TranslationTextComponent("chat.indent", new Object[]{new TranslationTextComponent(enchantment.func_77320_a()), enchantment.func_77325_b() != 1 ? new TranslationTextComponent(TranslationKeys.ENCHANT_LEVELS.getOrDefault(level, level.toString())) : ""}))).collect(Collectors.toCollection(LinkedList::new));
            collect.addFirst(new TranslationTextComponent("chat.plusenchant"));
            return collect;
        }

        public static void enchantmentToIS(@Nonnull IEnchantableTile te, @Nonnull ItemStack is) {
            te.getEnchantments().entrySet().stream().map(MapStreamSyntax.keys(arg_0 -> ((IForgeRegistry)ForgeRegistries.ENCHANTMENTS).getValue(arg_0))).filter(MapStreamSyntax.byKey(Objects::nonNull)).forEach(MapStreamSyntax.entry((arg_0, arg_1) -> ((ItemStack)is).func_77966_a(arg_0, arg_1)));
        }

        @Nonnull
        public static <T extends IEnchantableTile> Consumer<T> initConsumer(ItemStack stack) {
            return t -> Util.init(t, stack.func_77986_q());
        }
    }
}

