/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.item;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.base.EnchantmentFilter;
import com.yogpc.qp.machines.base.IHandleButton;
import com.yogpc.qp.machines.base.QuarryBlackList;
import com.yogpc.qp.machines.item.ContainerEnchList;
import com.yogpc.qp.machines.item.GuiSlotEnchList;
import com.yogpc.qp.packet.PacketHandler;
import com.yogpc.qp.packet.mover.EnchantmentMessage;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.ConfirmScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import scala.jdk.javaapi.CollectionConverters;

@OnlyIn(value=Dist.CLIENT)
public class GuiEnchList
extends ContainerScreen<ContainerEnchList>
implements BooleanConsumer,
IHandleButton {
    public static final int Toggle_id = 10;
    public static final int Remove_id = 12;
    private GuiSlotEnchList slot;
    private final EnchantmentFilter.Accessor tile;
    private final Enchantment target;

    public GuiEnchList(ContainerEnchList c, PlayerInventory i, ITextComponent t) {
        super((Container)c, i, t);
        this.target = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(c.enchantmentName);
        this.tile = c.tile;
    }

    public boolean include() {
        if (this.target == Enchantments.field_185308_t) {
            return this.tile.enchantmentFilter().fortuneInclude();
        }
        return this.tile.enchantmentFilter().silktouchInclude();
    }

    private Set<QuarryBlackList.Entry> getBlockDataList(Enchantment enchantment) {
        if (enchantment == Enchantments.field_185306_r) {
            return CollectionConverters.asJava(this.tile.enchantmentFilter().silktouchList());
        }
        if (enchantment == Enchantments.field_185308_t) {
            return CollectionConverters.asJava(this.tile.enchantmentFilter().fortuneList());
        }
        QuarryPlus.LOGGER.error(String.format("GuiEnchList target is %s", enchantment));
        return Collections.emptySet();
    }

    public void func_231160_c_() {
        int width = this.field_230708_k_;
        int height = this.field_230709_l_;
        this.field_146999_f = width;
        this.field_147000_g = height;
        super.func_231160_c_();
        this.func_230480_a_((Widget)new IHandleButton.Button(-1, width / 2 - 125, height - 26, 250, 20, (ITextComponent)new TranslationTextComponent("gui.done"), (IHandleButton)this));
        this.func_230480_a_((Widget)new IHandleButton.Button(10, width * 2 / 3 + 10, 140, 100, 20, "", (IHandleButton)this));
        this.func_230480_a_((Widget)new IHandleButton.Button(12, width * 2 / 3 + 10, 110, 100, 20, (ITextComponent)new TranslationTextComponent("selectServer.delete"), (IHandleButton)this));
        this.slot = new GuiSlotEnchList(this.getMinecraft(), width * 3 / 5, height - 60, 30, height - 30, 18, this);
        this.field_230705_e_.add(this.slot);
        this.func_231035_a_((IGuiEventListener)this.slot);
    }

    @Override
    public void actionPerformed(IHandleButton.Button par1) {
        switch (par1.id) {
            case -1: {
                this.getMinecraft().field_71439_g.func_71053_j();
                break;
            }
            case 12: {
                this.getMinecraft().func_147108_a((Screen)new ConfirmScreen((BooleanConsumer)this, (ITextComponent)new TranslationTextComponent("tof.deleteblocksure"), (ITextComponent)new StringTextComponent(Optional.ofNullable(this.slot.func_230958_g_()).map(GuiSlotEnchList.Entry::getData).map(Object::toString).orElse("None"))));
                break;
            }
            default: {
                PacketHandler.sendToServer(EnchantmentMessage.create(this.tile, EnchantmentMessage.Type.Toggle, this.target, new QuarryBlackList.Name(new ResourceLocation("dummy:toggle_button"))));
            }
        }
    }

    public void accept(boolean result) {
        GuiSlotEnchList.Entry selected = (GuiSlotEnchList.Entry)this.slot.func_230958_g_();
        if (selected != null && result) {
            QuarryBlackList.Entry entry = selected.getData();
            PacketHandler.sendToServer(EnchantmentMessage.create(this.tile, EnchantmentMessage.Type.Remove, this.target, entry));
            if (this.target == Enchantments.field_185306_r) {
                this.tile.enchantmentFilter_$eq(this.tile.enchantmentFilter().removeSilktouch(entry));
            } else if (this.target == Enchantments.field_185308_t) {
                this.tile.enchantmentFilter_$eq(this.tile.enchantmentFilter().removeFortune(entry));
            }
            this.refreshList();
        }
        this.getMinecraft().func_147108_a((Screen)this);
    }

    public void refreshList() {
        this.slot.refreshList();
        this.slot.func_241215_a_(null);
    }

    protected void func_230450_a_(MatrixStack matrixStack, float k, int i, int j) {
        if (this.slot != null) {
            this.slot.func_230430_a_(matrixStack, i, j, k);
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    protected void func_230451_b_(MatrixStack matrixStack, int i, int j) {
        this.func_238471_a_(matrixStack, this.field_230712_o_, I18n.func_135052_a((String)"qp.list.setting", (Object[])new Object[]{I18n.func_135052_a((String)this.target.func_77320_a(), (Object[])new Object[0])}), this.field_146999_f / 2, 8, 0xFFFFFF);
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        ((Widget)this.field_230710_m_.get(1)).func_238482_a_((ITextComponent)new TranslationTextComponent(this.include() ? "tof.include" : "tof.exclude"));
        ((Widget)this.field_230710_m_.get((int)2)).field_230693_o_ = !this.getBlockDataList(this.target).isEmpty();
    }

    public void buildModList(Consumer<GuiSlotEnchList.Entry> modListViewConsumer, Function<QuarryBlackList.Entry, GuiSlotEnchList.Entry> newEntry) {
        this.getBlockDataList(this.target).stream().map(newEntry).forEach(modListViewConsumer);
    }
}

