/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.workbench;

import com.yogpc.qp.Config;
import com.yogpc.qp.compat.InvUtils;
import com.yogpc.qp.machines.PowerManager;
import com.yogpc.qp.machines.base.APowerTile;
import com.yogpc.qp.machines.base.EnergyUsage;
import com.yogpc.qp.machines.base.HasInv;
import com.yogpc.qp.machines.base.IDebugSender;
import com.yogpc.qp.machines.workbench.ContainerWorkbench;
import com.yogpc.qp.machines.workbench.IngredientWithCount;
import com.yogpc.qp.machines.workbench.WorkbenchRecipes;
import com.yogpc.qp.packet.PacketHandler;
import com.yogpc.qp.packet.TileMessage;
import com.yogpc.qp.utils.Holder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import scala.Symbol;

public class TileWorkbench
extends APowerTile
implements HasInv,
IDebugSender,
INamedContainerProvider {
    public static final String GUI_ID = "quarryplus:gui_workbenchplus";
    public static final Symbol SYMBOL = Symbol.apply((String)"WorkbenchPlus");
    public final NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
    public final NonNullList<ItemStack> inventory2 = NonNullList.func_191197_a((int)18, (Object)ItemStack.field_190927_a);
    public List<WorkbenchRecipes> recipesList = Collections.emptyList();
    private WorkbenchRecipes currentRecipe = WorkbenchRecipes.dummyRecipe();
    private final ItemHandler itemHandler = new ItemHandler();
    public boolean workContinue;
    public boolean noEnergy = false;
    private final List<PlayerEntity> openPlayers = new ArrayList<PlayerEntity>();

    public TileWorkbench() {
        super(Holder.workbenchTileType());
    }

    @Override
    public void workInTick() {
        if (this.isWorking() && this.field_145850_b != null) {
            if (this.currentRecipe.microEnergy() <= this.getStoredEnergy()) {
                PowerManager.useEnergy(this, this.currentRecipe.microEnergy(), EnergyUsage.WORKBENCH);
                if (((Boolean)Config.common().noEnergy().get()).booleanValue()) {
                    this.setStoredEnergy(0L);
                }
                ItemStack stack = this.currentRecipe.getOutput((List<ItemStack>)this.inventory);
                ItemStack remain = InvUtils.injectToNearTile(this.field_145850_b, this.func_174877_v(), stack);
                if (!remain.func_190926_b()) {
                    InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (ItemStack)stack);
                }
                this.currentRecipe.inputsJ().forEach(inputList -> {
                    for (IngredientWithCount i : inputList) {
                        if (!this.inventory.stream().anyMatch(i::shrink)) continue;
                        break;
                    }
                });
                for (int i = 0; i < this.inventory.size(); ++i) {
                    if (!((ItemStack)this.inventory.get(i)).func_190926_b()) continue;
                    this.inventory.set(i, (Object)ItemStack.field_190927_a);
                }
                this.func_70296_d();
                this.setCurrentRecipeIndex(this.workContinue ? this.getRecipeIndex() : -1);
                this.noEnergy = false;
            } else if (((Boolean)Config.common().noEnergy().get()).booleanValue() || this.noEnergy) {
                this.getEnergy(this.currentRecipe.microEnergy() / 200L, true, true);
            }
        }
        if (!this.openPlayers.isEmpty()) {
            PacketHandler.sendToAround(TileMessage.create(this), Objects.requireNonNull(this.func_145831_w()), this.func_174877_v());
        }
    }

    @Override
    public boolean isWorking() {
        return this.enabled() && this.currentRecipe.hasContent();
    }

    @Override
    public void read(CompoundNBT nbt) {
        super.read(nbt);
        ListNBT list = nbt.func_150295_c("Items", 10);
        list.stream().map(b -> (CompoundNBT)b).forEach(nbtTagCompound -> {
            int j = nbtTagCompound.func_74771_c("Slot") & 0xFF;
            ItemStack stack = ItemStack.func_199557_a((CompoundNBT)nbtTagCompound);
            stack.func_190920_e(nbtTagCompound.func_74762_e("Count"));
            this.inventory.set(j, (Object)stack);
        });
        this.func_70296_d();
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        ListNBT list = new ListNBT();
        for (int i = 0; i < this.inventory.size(); ++i) {
            ItemStack stack = (ItemStack)this.inventory.get(i);
            CompoundNBT compoundNBT = new CompoundNBT();
            compoundNBT.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(compoundNBT);
            compoundNBT.func_82580_o("Count");
            compoundNBT.func_74768_a("Count", stack.func_190916_E());
            list.add((Object)compoundNBT);
        }
        nbt.func_218657_a("Items", (INBT)list);
        return super.func_189515_b(nbt);
    }

    @Override
    public int func_70302_i_() {
        return this.inventory.size() + this.inventory2.size();
    }

    @Override
    public boolean func_191420_l() {
        return this.inventory.stream().allMatch(ItemStack::func_190926_b);
    }

    @Override
    public ItemStack func_70301_a(int index) {
        if (this.inventory.size() <= index && index < this.func_70302_i_()) {
            return (ItemStack)this.inventory2.get(index - this.inventory.size());
        }
        return (ItemStack)this.inventory.get(index);
    }

    @Override
    public ItemStack func_70298_a(int index, int count) {
        if (this.inventory.size() <= index && index < this.func_70302_i_()) {
            return ItemStackHelper.func_188382_a(this.inventory2, (int)(index - this.inventory.size()), (int)count);
        }
        return ItemStackHelper.func_188382_a(this.inventory, (int)index, (int)count);
    }

    @Override
    public ItemStack func_70304_b(int index) {
        if (this.inventory.size() <= index && index < this.func_70302_i_()) {
            return ItemStackHelper.func_188383_a(this.inventory2, (int)(index - this.inventory.size()));
        }
        return ItemStackHelper.func_188383_a(this.inventory, (int)index);
    }

    @Override
    public void func_70299_a(int index, ItemStack stack) {
        if (this.inventory.size() <= index && index < this.func_70302_i_()) {
            this.inventory2.set(index - this.inventory.size(), (Object)stack);
        } else {
            this.inventory.set(index, (Object)stack);
        }
    }

    @Override
    public int func_70297_j_() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean func_70300_a(PlayerEntity player) {
        return this.field_145850_b != null && this.field_145850_b.func_175625_s(this.func_174877_v()) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p()) <= 64.0;
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.recipesList = WorkbenchRecipes.getRecipe(this.inventory);
        this.inventory2.clear();
        for (int i = 0; i < this.recipesList.size(); ++i) {
            this.func_70299_a(this.inventory.size() + i, this.recipesList.get(i).getOutput((List<ItemStack>)this.inventory));
        }
        if (this.getRecipeIndex() == -1) {
            if (this.currentRecipe.hasContent()) {
                this.setCurrentRecipeIndex(-1);
                if (this.field_145850_b != null && !this.field_145850_b.func_201670_d()) {
                    this.finishWork();
                }
            }
        } else if (this.field_145850_b != null && !this.field_145850_b.func_201670_d()) {
            this.startWork();
        }
        if (this.field_145850_b != null && !this.field_145850_b.func_201670_d()) {
            PacketHandler.sendToAround(TileMessage.create(this), this.field_145850_b, this.field_174879_c);
        }
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    @Override
    public void func_174888_l() {
        this.inventory.clear();
    }

    public List<StringTextComponent> getDebugMessages() {
        return Arrays.asList(new StringTextComponent(this.currentRecipe.toString()), new StringTextComponent("Work mode : " + (this.workContinue ? "Continue" : "Only once")));
    }

    @Override
    public String getDebugName() {
        return "block.quarryplus.workbenchplus";
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(cap, LazyOptional.of(() -> this.itemHandler));
        }
        return super.getCapability(cap, side);
    }

    public void setCurrentRecipeIndex(int recipeIndex) {
        this.currentRecipe = recipeIndex >= 0 && this.recipesList.size() > recipeIndex ? this.recipesList.get(recipeIndex) : WorkbenchRecipes.dummyRecipe();
        this.configure((long)((Integer)Config.common().workbenchMaxReceive().get()).intValue() * 1000000L, this.currentRecipe.microEnergy());
        if (((Boolean)Config.common().noEnergy().get()).booleanValue()) {
            this.setStoredEnergy(0L);
        }
    }

    public int getProgressScaled(int scale) {
        if (this.isWorking()) {
            return (int)(this.getStoredEnergy() * (long)scale / this.currentRecipe.microEnergy());
        }
        return 0;
    }

    public int getRecipeIndex() {
        return this.recipesList.indexOf(this.currentRecipe);
    }

    public Container createMenu(int p_createMenu_1_, PlayerInventory p_createMenu_2_, PlayerEntity p_createMenu_3_) {
        return new ContainerWorkbench(p_createMenu_1_, p_createMenu_3_, this.field_174879_c);
    }

    public ITextComponent func_200200_C_() {
        return new TranslationTextComponent(this.getDebugName());
    }

    @Override
    public void func_174889_b(PlayerEntity player) {
        this.openPlayers.add(player);
    }

    public void func_174886_c(PlayerEntity player) {
        this.openPlayers.remove(player);
    }

    private class ItemHandler
    implements IItemHandlerModifiable {
        private ItemHandler() {
        }

        public void setStackInSlot(int slot, ItemStack stack) {
            TileWorkbench.this.func_70299_a(slot, stack);
        }

        public int getSlots() {
            return TileWorkbench.this.inventory.size();
        }

        public ItemStack getStackInSlot(int slot) {
            return TileWorkbench.this.func_70301_a(slot);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (stack.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            ItemStack inSlot = this.getStackInSlot(slot).func_77946_l();
            if (!inSlot.func_190926_b()) {
                if (ItemHandlerHelper.canItemStacksStack((ItemStack)inSlot, (ItemStack)stack)) {
                    if (!simulate) {
                        inSlot.func_190917_f(stack.func_190916_E());
                        this.setStackInSlot(slot, inSlot);
                        TileWorkbench.this.func_70296_d();
                    }
                    return ItemStack.field_190927_a;
                }
                return stack;
            }
            if (!simulate) {
                this.setStackInSlot(slot, stack.func_77946_l());
                TileWorkbench.this.func_70296_d();
            }
            return ItemStack.field_190927_a;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            return TileWorkbench.this.func_70297_j_();
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return TileWorkbench.this.func_94041_b(slot, stack);
        }
    }
}

