/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.utils;

import com.yogpc.qp.Config;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.advpump.GuiAdvPump;
import com.yogpc.qp.machines.advquarry.GuiAdvQuarry;
import com.yogpc.qp.machines.base.StatusGui;
import com.yogpc.qp.machines.bookmover.GuiBookMover;
import com.yogpc.qp.machines.item.GuiEnchList;
import com.yogpc.qp.machines.item.GuiListTemplate;
import com.yogpc.qp.machines.item.GuiQuarryLevel;
import com.yogpc.qp.machines.mini_quarry.MiniQuarryGui;
import com.yogpc.qp.machines.mover.GuiMover;
import com.yogpc.qp.machines.pb.PlacerGui;
import com.yogpc.qp.machines.quarry.GuiQuarryModule;
import com.yogpc.qp.machines.quarry.GuiSolidQuarry;
import com.yogpc.qp.machines.workbench.GuiWorkbench;
import com.yogpc.qp.render.DummyBlockBakedModel;
import com.yogpc.qp.render.RenderAdvQuarry;
import com.yogpc.qp.render.RenderMarker;
import com.yogpc.qp.render.RenderMiniQuarry;
import com.yogpc.qp.render.RenderQuarry;
import com.yogpc.qp.render.RenderQuarry2;
import com.yogpc.qp.render.Sprites;
import com.yogpc.qp.utils.Holder;
import com.yogpc.qp.utils.ProxyCommon;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelManager;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.network.NetworkEvent;

@OnlyIn(value=Dist.CLIENT)
public class ProxyClient
extends ProxyCommon {
    @Override
    public Optional<PlayerEntity> getPacketPlayer(NetworkEvent.Context context) {
        if (context.getSender() != null) {
            return Optional.of(context.getSender());
        }
        return Optional.ofNullable(Minecraft.func_71410_x().field_71439_g);
    }

    @Override
    public Optional<World> getPacketWorld(NetworkEvent.Context context) {
        ServerPlayerEntity sender = context.getSender();
        if (sender == null) {
            return Optional.of(this.getClientWorld());
        }
        return Optional.of(sender).map(Entity::func_130014_f_);
    }

    @Override
    public void removeEntity(Entity e) {
        e.func_70106_y();
        if (e.field_70170_p.field_72995_K) {
            ((ClientWorld)e.field_70170_p).func_217413_d(e.func_145782_y());
        }
    }

    @Override
    public World getClientWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="quarryplus", value={Dist.CLIENT})
    static class ClientModEventHandlers {
        ClientModEventHandlers() {
        }

        @SubscribeEvent
        public static void registerTextures(FMLCommonSetupEvent event) {
            if (((Boolean)Config.client().enableRender().get()).booleanValue()) {
                ClientRegistry.bindTileEntityRenderer(Holder.markerTileType(), t -> RenderMarker.instance());
                ClientRegistry.bindTileEntityRenderer(Holder.quarryTileType(), t -> RenderQuarry.instance());
                ClientRegistry.bindTileEntityRenderer(Holder.solidQuarryType(), t -> RenderQuarry.instance());
                ClientRegistry.bindTileEntityRenderer(Holder.quarry2(), t -> RenderQuarry2.instance());
                ClientRegistry.bindTileEntityRenderer(Holder.advQuarryType(), t -> RenderAdvQuarry.instance());
                ClientRegistry.bindTileEntityRenderer(Holder.miniQuarryType(), t -> RenderMiniQuarry.instance());
            }
            ScreenManager.func_216911_a(Holder.moverContainerType(), GuiMover::new);
            ScreenManager.func_216911_a(Holder.workbenchContainerType(), GuiWorkbench::new);
            ScreenManager.func_216911_a(Holder.bookMoverContainerType(), GuiBookMover::new);
            ScreenManager.func_216911_a(Holder.ySetterContainerType(), GuiQuarryLevel::new);
            ScreenManager.func_216911_a(Holder.solidQuarryContainerType(), GuiSolidQuarry::new);
            ScreenManager.func_216911_a(Holder.quarryModuleContainerType(), GuiQuarryModule::new);
            ScreenManager.func_216911_a(Holder.enchListContainerType(), GuiEnchList::new);
            ScreenManager.func_216911_a(Holder.templateContainerType(), GuiListTemplate::new);
            ScreenManager.func_216911_a(Holder.advPumpContainerType(), GuiAdvPump::new);
            ScreenManager.func_216911_a(Holder.advQuarryContainerType(), GuiAdvQuarry::new);
            ScreenManager.func_216911_a(Holder.statusContainerType(), StatusGui::new);
            ScreenManager.func_216911_a(Holder.placerContainerType(), PlacerGui::new);
            ScreenManager.func_216911_a(Holder.miniQuarryContainerType(), MiniQuarryGui::new);
            RenderType rendertype = RenderType.func_228641_d_();
            RenderTypeLookup.setRenderLayer((Block)Holder.blockFrame(), (RenderType)rendertype);
            RenderTypeLookup.setRenderLayer((Block)Holder.blockDummy(), (RenderType)rendertype);
            RenderTypeLookup.setRenderLayer((Block)Holder.blockPlainPipe(), (RenderType)rendertype);
            RenderTypeLookup.setRenderLayer((Block)Holder.blockMarker(), (RenderType)rendertype);
        }

        @SubscribeEvent
        public static void onBake(ModelBakeEvent event) {
            String itemTexName = "minecraft:glass";
            IBakedModel blockModel = ClientModEventHandlers.getModel(event.getModelManager(), new ModelResourceLocation(itemTexName));
            IBakedModel itemModel = ClientModEventHandlers.getModel(event.getModelManager(), new ModelResourceLocation(itemTexName, "inventory"));
            DummyBlockBakedModel dummyBlockBakedModel = new DummyBlockBakedModel(blockModel);
            DummyBlockBakedModel dummyItemBakedModel = new DummyBlockBakedModel(itemModel);
            ResourceLocation pathIn = Objects.requireNonNull(Holder.blockDummy().getRegistryName());
            event.getModelRegistry().put(new ModelResourceLocation(pathIn.toString()), dummyBlockBakedModel);
            event.getModelRegistry().put(new ModelResourceLocation(pathIn, "inventory"), dummyItemBakedModel);
        }

        private static IBakedModel getModel(ModelManager manager, ModelResourceLocation location) {
            return manager.func_174953_a(new ModelResourceLocation("minecraft:glass", location.func_177518_c()));
        }

        @SubscribeEvent
        public static void registerTexture(TextureStitchEvent.Pre event) {
            Sprites.registerTexture(event);
        }

        @SubscribeEvent
        public static void putTexture(TextureStitchEvent.Post event) {
            Sprites.putTexture(event);
        }

        @SubscribeEvent
        public static void loadComplete(FMLLoadCompleteEvent event) {
            QuarryPlus.proxy.setDummyTexture((String)Config.client().dummyTexture().get());
        }
    }
}

