/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.entity;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import net.adventurez.init.SoundInit;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1400;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_4140;
import net.minecraft.class_4538;
import net.minecraft.class_4836;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_7;

public class PiglinBeastEntity
extends class_1588 {
    public static final class_2940<Float> AttackTickVisual = class_2945.method_12791(PiglinBeastEntity.class, (class_2941)class_2943.field_13320);
    public static final class_2940<Float> LeadArm = class_2945.method_12791(PiglinBeastEntity.class, (class_2941)class_2943.field_13320);
    private float attackTick;
    public float armTick;
    private int makePiglinsAngry = 0;

    public PiglinBeastEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6013 = 1.0f;
        this.field_6194 = 30;
        this.method_5941(class_7.field_14, 8.0f);
    }

    public static class_5132.class_5133 createPiglinBeastAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, 80.0).method_26868(class_5134.field_23719, 0.225).method_26868(class_5134.field_23718, 0.5).method_26868(class_5134.field_23721, 9.0).method_26868(class_5134.field_23722, 2.0).method_26868(class_5134.field_23717, 38.0);
    }

    public void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(4, (class_1352)new AttackGoal());
        this.field_6201.method_6277(5, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(6, (class_1352)new class_1361((class_1308)this, class_1657.class, 12.0f));
        this.field_6201.method_6277(7, (class_1352)new class_1376((class_1308)this));
        this.field_6201.method_6277(10, (class_1352)new class_1361((class_1308)this, class_1308.class, 8.0f));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
    }

    public void method_5958() {
        if (this.attackTick > 0.0f) {
            this.attackTick -= 0.08f;
            this.field_6011.method_12778(AttackTickVisual, (Object)Float.valueOf(this.attackTick));
        }
        if (this.method_5968() instanceof class_1657) {
            ++this.makePiglinsAngry;
            if (this.makePiglinsAngry == 2000) {
                this.field_6011.method_12778(LeadArm, (Object)Float.valueOf(1.0f));
                this.getPiglins();
                this.field_6002.method_8449(null, (class_1297)this, SoundInit.PIGLINBEAST_SHOUT_EVENT, class_3419.field_15251, 1.0f, 1.0f);
                this.method_5996(class_5134.field_23719).method_6192(0.0);
            }
            if (this.makePiglinsAngry > 2000) {
                this.field_6011.method_12778(LeadArm, (Object)Float.valueOf(((Float)this.field_6011.method_12789(LeadArm)).floatValue() - 0.02f));
            }
            if (this.makePiglinsAngry == 2050) {
                this.method_5996(class_5134.field_23719).method_6192(0.23);
                this.makePiglinsAngry = 0;
            }
        }
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10548("AttackTick", this.attackTick);
        tag.method_10548("LeadArm", 0.0f);
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.attackTick = tag.method_10583("AttackTick");
        this.armTick = tag.method_10583("LeadArm");
    }

    public void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(AttackTickVisual, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(LeadArm, (Object)Float.valueOf(0.0f));
    }

    public boolean method_5957(class_4538 world) {
        return !world.method_22345(this.method_5829());
    }

    public boolean method_17326() {
        return true;
    }

    public boolean method_5822() {
        return false;
    }

    protected class_3414 method_5994() {
        return SoundInit.PIGLINBEAST_IDLE_EVENT;
    }

    protected class_3414 method_6011(class_1282 source) {
        return SoundInit.PIGLINBEAST_HURT_EVENT;
    }

    protected class_3414 method_6002() {
        return SoundInit.PIGLINBEAST_DEATH_EVENT;
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(SoundInit.PIGLINBEAST_WALK_EVENT, 0.5f, 1.0f);
    }

    public void getPiglins() {
        List list = this.field_6002.method_8335((class_1297)this, this.method_5829().method_1014(40.0));
        for (int i = 0; i < list.size(); ++i) {
            class_1297 entity = (class_1297)list.get(i);
            if (entity.method_5864() != class_1299.field_22281) continue;
            class_4836 piglin = (class_4836)entity;
            PiglinBeastEntity.angerNearbyPiglins(piglin);
        }
    }

    public static void angerNearbyPiglins(class_4836 piglin) {
        PiglinBeastEntity.getNearbyPiglins(piglin).forEach(piglinEntity -> PiglinBeastEntity.getNearestDetectedPlayer(piglinEntity).ifPresent(playerEntity -> PiglinBeastEntity.becomeAngryWith(piglinEntity, (class_1309)playerEntity)));
    }

    public static Optional<class_1657> getNearestDetectedPlayer(class_4836 piglin) {
        return piglin.method_18868().method_18896(class_4140.field_22354) ? piglin.method_18868().method_18904(class_4140.field_22354) : Optional.empty();
    }

    public static void becomeAngryWith(class_4836 piglin, class_1309 target) {
        piglin.method_18868().method_18875(class_4140.field_19293);
        piglin.method_18868().method_24525(class_4140.field_22333, (Object)target.method_5667(), 600L);
        if (target.method_5864() == class_1299.field_6097 && piglin.field_6002.method_8450().method_8355(class_1928.field_25402)) {
            piglin.method_18868().method_24525(class_4140.field_25361, (Object)true, 600L);
        }
    }

    private static List<class_4836> getNearbyPiglins(class_4836 piglin) {
        return (List)piglin.method_18868().method_18904(class_4140.field_23228).orElse(ImmutableList.of());
    }

    class AttackGoal
    extends class_1366 {
        public AttackGoal() {
            super((class_1314)PiglinBeastEntity.this, 1.0, true);
        }

        public double method_6289(class_1309 entity) {
            float f = PiglinBeastEntity.this.method_17681();
            return (double)(f * f) * 1.3 + (double)entity.method_17681();
        }

        protected void method_6288(class_1309 target, double squaredDistance) {
            double number = this.method_6289(target);
            if (squaredDistance <= number && PiglinBeastEntity.this.attackTick <= 0.0f) {
                PiglinBeastEntity.this.field_6002.method_8449(null, (class_1297)PiglinBeastEntity.this, SoundInit.PIGLINBEAST_CLUBSWING_EVENT, class_3419.field_15251, 1.0f, 1.0f);
                this.method_28346();
                this.field_6503.method_6121((class_1297)target);
                PiglinBeastEntity.this.attackTick = 1.0f;
            }
        }
    }
}

