/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.integration.jei;

import com.yogpc.qp.integration.jei.BookRecipeCategory;
import com.yogpc.qp.integration.jei.MoverRecipeCategory;
import com.yogpc.qp.integration.jei.WorkBenchRecipeCategory;
import com.yogpc.qp.machines.workbench.GuiWorkbench;
import com.yogpc.qp.machines.workbench.WorkbenchRecipes;
import com.yogpc.qp.utils.Holder;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import scala.collection.JavaConverters;

@JeiPlugin
public class QuarryJeiPlugin
implements IModPlugin {
    static IJeiRuntime jeiRuntime;
    static WorkBenchRecipeCategory workBenchRecipeCategory;
    static MoverRecipeCategory moverRecipeCategory;
    static BookRecipeCategory bookRecipeCategory;

    public void registerRecipes(IRecipeRegistration registration) {
        List recipes2 = JavaConverters.mapAsJavaMap(WorkbenchRecipes.recipes()).values().stream().filter(WorkbenchRecipes::showInJEI).sorted(WorkbenchRecipes.recipeOrdering()).collect(Collectors.toList());
        registration.addRecipes(recipes2, WorkBenchRecipeCategory.UID());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)Holder.blockWorkbench()), new ResourceLocation[]{WorkBenchRecipeCategory.UID()});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(GuiWorkbench.class, 7, 74, 161, 11, new ResourceLocation[]{WorkBenchRecipeCategory.UID()});
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("quarryplus", "jei_recipe");
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        workBenchRecipeCategory = new WorkBenchRecipeCategory(registry.getJeiHelpers().getGuiHelper());
        registry.addRecipeCategories(new IRecipeCategory[]{workBenchRecipeCategory});
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        QuarryJeiPlugin.jeiRuntime = jeiRuntime;
    }
}

