/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.base;

import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.base.HasInv;
import com.yogpc.qp.machines.base.IChunkLoadTile;
import com.yogpc.qp.machines.base.IDebugSender;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import scala.Symbol;

public abstract class APacketTile
extends TileEntity {
    public static final BinaryOperator<String> combiner = (s, s2) -> s + ", " + s2;
    public static final Function<String, TextComponentString> toComponentString = TextComponentString::new;
    public static final Consumer<IChunkLoadTile> requestTicket = IChunkLoadTile::requestTicket;
    private final ITextComponent displayName;
    protected final boolean machineDisabled = false;
    protected final boolean isDebugSender = this instanceof IDebugSender;
    protected final List<Runnable> startListener = new ArrayList<Runnable>();
    protected final List<Runnable> finishListener = new ArrayList<Runnable>();

    protected APacketTile(TileEntityType<?> type) {
        super(type);
        if (this instanceof HasInv) {
            HasInv hasInv = (HasInv)((Object)this);
            this.displayName = hasInv.func_200200_C_();
        } else if (this.isDebugSender) {
            IDebugSender sender = (IDebugSender)((Object)this);
            this.displayName = new TextComponentTranslation(sender.getDebugName(), new Object[0]);
        } else {
            this.displayName = new TextComponentString("APacketTile");
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.func_145839_a(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public ITextComponent getDisplayName() {
        return this.displayName;
    }

    protected final void startWork() {
        if (this.func_145830_o()) {
            this.startListener.forEach(Runnable::run);
        }
    }

    protected final void finishWork() {
        if (this.func_145830_o()) {
            this.finishListener.forEach(Runnable::run);
        }
    }

    protected abstract Symbol getSymbol();

    protected static <T> T invoke(Method method, Object ref, Object ... param) {
        try {
            return (T)method.invoke(ref, param);
        }
        catch (ReflectiveOperationException e) {
            QuarryPlus.LOGGER.warn((Object)e);
            return null;
        }
    }
}

