/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.base;

import com.yogpc.qp.Config;
import com.yogpc.qp.machines.base.APacketTile;
import com.yogpc.qp.machines.base.EnergyDebug;
import com.yogpc.qp.machines.base.EnergyUsage;
import com.yogpc.qp.machines.base.MjReceiver;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.ModList;

public abstract class APowerTile
extends APacketTile
implements ITickable,
IEnergyStorage {
    public static final long MicroJtoMJ = 1000000L;
    public static final String NBT_STORED_ENERGY = "storedEnergy";
    public static final String NBT_MAX_STORED = "MAX_stored";
    public static final String NBT_MAX_RECEIVE = "MAX_receive";
    public static final String NBT_OUTPUT_ENERGY_INFO = "outputEnergyInfo";
    long all;
    long maxGot;
    long max;
    long got;
    private boolean ic2ok = false;
    public boolean bcLoaded;
    public final boolean ic2Loaded;
    private Object helper;
    protected final EnergyDebug debug = new EnergyDebug(this);
    protected boolean outputEnergyInfo = true;
    private static final long FEtoMicroJ = 100000L;

    public APowerTile(TileEntityType<?> type) {
        super(type);
        this.bcLoaded = ModList.get().isLoaded("buildcraftlib");
        this.ic2Loaded = ModList.get().isLoaded("ic2");
        if (this.bcLoaded) {
            this.helper = MjReceiver.mjCapabilityHelper(this);
        }
        this.startListener.add(this.debug::start);
        this.finishListener.add(this.debug::finish);
    }

    public void func_73660_a() {
        this.postLoadEvent();
        this.all += this.got;
        if (this.func_145830_o() && !Objects.requireNonNull(this.func_145831_w()).field_72995_K && this.isWorking()) {
            this.debug.getAndTick(this.got);
        }
        this.got = 0L;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.postUnLoadEvent();
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.postUnLoadEvent();
    }

    private void postLoadEvent() {
    }

    private void postUnLoadEvent() {
    }

    protected final BlockPos[] getNeighbors(EnumFacing facing) {
        return new BlockPos[]{this.field_174879_c.func_177972_a(facing), this.field_174879_c.func_177972_a(facing.func_176735_f()), this.field_174879_c.func_177972_a(facing.func_176746_e())};
    }

    public final boolean isOutputEnergyInfo() {
        return this.outputEnergyInfo;
    }

    public final void toggleOutputEnergyInfo() {
        this.outputEnergyInfo = !this.outputEnergyInfo;
    }

    protected abstract boolean isWorking();

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.setStoredEnergy(nbt.func_74763_f(NBT_STORED_ENERGY));
        this.configure(nbt.func_74763_f(NBT_MAX_RECEIVE), nbt.func_74763_f(NBT_MAX_STORED));
        this.outputEnergyInfo = !nbt.func_74764_b(NBT_OUTPUT_ENERGY_INFO) || nbt.func_74767_n(NBT_OUTPUT_ENERGY_INFO);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74772_a(NBT_STORED_ENERGY, this.all);
        nbt.func_74772_a(NBT_MAX_STORED, this.max);
        nbt.func_74772_a(NBT_MAX_RECEIVE, this.maxGot);
        nbt.func_74757_a(NBT_OUTPUT_ENERGY_INFO, this.outputEnergyInfo);
        return super.func_189515_b(nbt);
    }

    public final long useEnergy(long min, long amount, boolean real, EnergyUsage usage) {
        if (((Boolean)Config.common().noEnergy().get()).booleanValue()) {
            this.debug.use(amount, !real, usage);
            return amount;
        }
        long res = 0L;
        if (this.all >= min) {
            if (this.all <= amount) {
                res = this.all;
                if (real) {
                    this.all = 0L;
                }
            } else {
                res = amount;
                if (real) {
                    this.all -= amount;
                }
            }
        }
        this.debug.use(res, !real, usage);
        return res;
    }

    protected final long getEnergy(long a, boolean real) {
        if (((Boolean)Config.common().noEnergy().get()).booleanValue()) {
            return 0L;
        }
        long ret = Math.min(Math.min(this.maxGot - this.got, this.max - this.all - this.got), a);
        if (real) {
            this.got += ret;
        }
        return ret;
    }

    public final long getStoredEnergy() {
        return this.all;
    }

    public final void setStoredEnergy(long all) {
        this.all = all;
    }

    public final long getMaxStored() {
        return this.max;
    }

    public final void configure(long maxReceive, long maxStored) {
        this.maxGot = maxReceive;
        this.max = maxStored;
        if (((Boolean)Config.common().noEnergy().get()).booleanValue()) {
            this.all = maxStored;
        }
    }

    public final int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        return (int)(this.getEnergy((long)maxReceive * 100000L, !simulate) / 100000L);
    }

    public final int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public final int getEnergyStored() {
        return (int)(this.all / 100000L);
    }

    public final int getMaxEnergyStored() {
        return (int)(this.max / 100000L);
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable EnumFacing side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return LazyOptional.of(() -> this).cast();
        }
        return super.getCapability(cap, side);
    }
}

