/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.base;

import com.google.common.base.Stopwatch;
import com.yogpc.qp.Config$;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.base.APowerTile;
import com.yogpc.qp.machines.base.EnergyUsage;
import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001db\u0001B\u000e\u001d\u0001\u001dB\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\u0006g\u0001!\t\u0001\u000e\u0005\u0007o\u0001\u0001\u000b\u0011\u0002\u001d\t\r\u0001\u0003\u0001\u0015!\u0003B\u0011\u00199\u0005\u0001)A\u0005\u0003\"1\u0001\n\u0001Q!\n%Ca\u0001\u0014\u0001!B\u0013I\u0005BB'\u0001A\u0003&A\t\u0003\u0004O\u0001\u0001\u0006K\u0001\u0012\u0005\u0007\u001f\u0002\u0001\u000b\u0015\u0002#\t\rA\u0003\u0001\u0015)\u0003E\u0011\u0019\t\u0006\u0001)A\u0007\t\"1!\u000b\u0001Q\u0001\nMCa\u0001\u0018\u0001!B\u0013!\u0005BB/\u0001A\u0003%a\fC\u0003j\u0001\u0011\u0005!\u000eC\u0003o\u0001\u0011\u0005q\u000eC\u0003t\u0001\u0011%A\u000fC\u0003v\u0001\u0011%!\u000eC\u0003w\u0001\u0011\u0005q\u000fC\u0003\u007f\u0001\u0011\u0005q\u0010\u0003\u0004\u0002\u0004\u0001!\ta\u001c\u0005\u0007\u0003\u000b\u0001A\u0011B8\t\u000f\u0005\u001d\u0001\u0001\"\u0001\u0002\n!1\u0011Q\u0002\u0001\u0005\u0002=Dq!a\u0004\u0001\t\u0003\n\tBA\u0006F]\u0016\u0014x-\u001f#fEV<'BA\u000f\u001f\u0003\u0011\u0011\u0017m]3\u000b\u0005}\u0001\u0013\u0001C7bG\"Lg.Z:\u000b\u0005\u0005\u0012\u0013AA9q\u0015\t\u0019C%A\u0003z_\u001e\u00048MC\u0001&\u0003\r\u0019w.\\\u0002\u0001'\t\u0001\u0001\u0006\u0005\u0002*Y5\t!FC\u0001,\u0003\u0015\u00198-\u00197b\u0013\ti#F\u0001\u0004B]f\u0014VMZ\u0001\u0005i&dW\r\u0005\u00021c5\tA$\u0003\u000239\tQ\u0011\tU8xKJ$\u0016\u000e\\3\u0002\rqJg.\u001b;?)\t)d\u0007\u0005\u00021\u0001!)aF\u0001a\u0001_\u0005AA/\u001b7f\u001d\u0006lW\r\u0005\u0002:}5\t!H\u0003\u0002<y\u0005!A.\u00198h\u0015\u0005i\u0014\u0001\u00026bm\u0006L!a\u0010\u001e\u0003\rM#(/\u001b8h\u0003\r9w\u000e\u001e\t\u0004S\t#\u0015BA\"+\u0005\u0015\t%O]1z!\tIS)\u0003\u0002GU\t!Aj\u001c8h\u0003\u0011)8/\u001a3\u0002\u0011\u001d|GoQ8v]R\u0004\"!\u000b&\n\u0005-S#aA%oi\u0006IQo]3e\u0007>,h\u000e^\u0001\ni>$\u0018\r\\+tK\u0012\f\u0011\"\u001e'bgR$\u0016nY6\u0002\u0013\u001dd\u0015m\u001d;US\u000e\\\u0017A\u00037bgR|U\u000f\u001e9vi\u0006\u0011QN[\u0001\ngR|\u0007oV1uG\"\u0004\"\u0001\u0016.\u000e\u0003US!!\b,\u000b\u0005]C\u0016AB2p[6|gN\u0003\u0002ZI\u00051qm\\8hY\u0016L!aW+\u0003\u0013M#x\u000e]<bi\u000eD\u0017!C:uCJ$H+[7f\u0003!)8/Y4f\u001b\u0006\u0004\b\u0003B0eM\u0012k\u0011\u0001\u0019\u0006\u0003C\n\fq!\\;uC\ndWM\u0003\u0002dU\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\u0015\u0004'aA'baB\u0011\u0001gZ\u0005\u0003Qr\u00111\"\u00128fe\u001eLXk]1hK\u000691\u000f^1si\u0016$W#A6\u0011\u0005%b\u0017BA7+\u0005\u001d\u0011un\u001c7fC:\fQa\u001d;beR$\u0012\u0001\u001d\t\u0003SEL!A\u001d\u0016\u0003\tUs\u0017\u000e^\u0001\bO\u0016$H+[7f+\u0005!\u0015AC8viB,H/\u00138g_\u0006\u0019Qo]3\u0015\tAD(\u0010 \u0005\u0006sR\u0001\r\u0001R\u0001\u0007C6|WO\u001c;\t\u000bm$\u0002\u0019A6\u0002\u0011MLW.\u001e7bi\u0016DQ! \u000bA\u0002\u0019\fQ!^:bO\u0016\f1aZ3u)\r\u0001\u0018\u0011\u0001\u0005\u0006sV\u0001\r\u0001R\u0001\u0005i&\u001c7.A\u0005qe&tG/\u00138g_\u0006Qq-\u001a;B]\u0012$\u0016nY6\u0015\u0007A\fY\u0001C\u0003z1\u0001\u0007A)\u0001\u0004gS:L7\u000f[\u0001\ti>\u001cFO]5oOR\u0011\u00111\u0003\t\u0005\u0003+\t\u0019C\u0004\u0003\u0002\u0018\u0005}\u0001cAA\rU5\u0011\u00111\u0004\u0006\u0004\u0003;1\u0013A\u0002\u001fs_>$h(C\u0002\u0002\")\na\u0001\u0015:fI\u00164\u0017bA \u0002&)\u0019\u0011\u0011\u0005\u0016")
public class EnergyDebug {
    private final APowerTile tile;
    private final String tileName;
    private final long[] got;
    private final long[] used;
    private int gotCount;
    private int usedCount;
    private long totalUsed;
    private long uLastTick;
    private long gLastTick;
    private long lastOutput;
    private final long mj;
    private final Stopwatch stopWatch;
    private long startTime;
    private final Map<EnergyUsage, Object> usageMap;

    public boolean started() {
        return this.stopWatch.isRunning();
    }

    public void start() {
        if (this.started()) {
            return;
        }
        this.stopWatch.start();
        this.startTime = this.getTime();
    }

    private long getTime() {
        return this.tile.func_145831_w().func_82737_E();
    }

    private boolean outputInfo() {
        return Config$.MODULE$.common().debug() && this.tile.isOutputEnergyInfo();
    }

    public void use(long amount, boolean simulate, EnergyUsage usage) {
        if (!this.outputInfo() || simulate) {
            return;
        }
        if (!this.started()) {
            this.start();
        }
        long tick = this.getTime();
        int energy = Math.round(amount);
        if (tick == this.uLastTick) {
            int n = this.usedCount - 1;
            this.used[n] = this.used[n] + (long)energy;
        } else {
            ++this.usedCount;
            if (this.usedCount <= 100) {
                this.used[this.usedCount - 1] = energy;
            }
            this.uLastTick = tick;
        }
        this.totalUsed += (long)energy;
        this.usageMap.update((Object)usage, (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)this.usageMap.getOrElse((Object)usage, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)) + (long)energy)));
    }

    public void get(long amount) {
        if (!this.outputInfo()) {
            return;
        }
        long tick = this.getTime();
        int energy = Math.round(amount);
        if (tick == this.gLastTick) {
            if (this.gotCount > 0) {
                int n = this.gotCount - 1;
                this.got[n] = this.got[n] + (long)energy;
            }
        } else {
            ++this.gotCount;
            if (this.gotCount > 100) {
                Predef$.MODULE$.print((Object)BoxesRunTime.boxToInteger((int)this.gotCount));
                return;
            }
            this.got[this.gotCount - 1] = energy;
            this.gLastTick = tick;
        }
    }

    public void tick() {
        block0: {
            block1: {
                if (this.getTime() - this.lastOutput < 100L) break block0;
                if (this.lastOutput != 0L) break block1;
                this.usedCount = 0;
                this.gotCount = 0;
                this.lastOutput = this.getTime();
                break block0;
            }
            if (!this.outputInfo()) break block0;
            this.printInfo();
        }
    }

    private void printInfo() {
        long allUsed = BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(this.used)).take(this.usedCount))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / this.mj;
        long allGot = BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(this.got)).take(this.gotCount))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / this.mj;
        if (allUsed != 0L || allGot != 0L) {
            if (allUsed == 0L || this.usedCount == 0) {
                if (this.gotCount == 0) {
                    QuarryPlus.LOGGER.info(new StringBuilder(20).append(this.tileName).append(" used 0 MJ, got 0 MJ").toString());
                } else {
                    QuarryPlus.LOGGER.info(new StringBuilder(37).append(this.tileName).append(" used 0 MJ, got ").append(allGot).append(" in 100 ticks (").append(allGot * 10L / (long)this.gotCount).append(" RF/t)").toString());
                }
            } else if (this.gotCount == 0) {
                QuarryPlus.LOGGER.info(new StringBuilder(37).append(this.tileName).append(" used ").append(allUsed).append(" MJ in ").append(this.usedCount).append(" ticks (").append(allUsed * 10L / (long)this.usedCount).append(" RF/t), got 0 MJ").toString());
            } else {
                QuarryPlus.LOGGER.info(new StringBuilder(51).append(this.tileName).append(" used ").append(allUsed).append(" MJ in ").append(this.usedCount).append(" ticks (").append(allUsed * 10L / (long)this.usedCount).append(" RF/t), got ").append(allGot).append(" in ").append(this.gotCount).append(" ticks (").append(allGot * 10L / (long)this.gotCount).append(" RF/t)").toString());
            }
        }
        this.usedCount = 0;
        this.gotCount = 0;
        this.lastOutput = this.getTime();
    }

    public void getAndTick(long amount) {
        this.get(amount);
        this.tick();
    }

    public void finish() {
        if (!this.started()) {
            return;
        }
        this.stopWatch.stop();
        if (this.outputInfo()) {
            this.printInfo();
            long time = this.getTime() - this.startTime;
            QuarryPlus.LOGGER.info(new StringBuilder(55).append(this.tileName).append(" finished its work and took ").append(this.stopWatch.toString()).append(", ").append(time).append(" ticks. Used ").append(this.totalUsed / this.mj).append(" MJ at ").append(this.totalUsed * 10L / time / this.mj).append(" RF/t").toString());
            this.usageMap.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                EnergyDebug.$anonfun$finish$1(this, x0$1);
                return BoxedUnit.UNIT;
            });
            this.usageMap.clear();
            this.totalUsed = 0L;
            this.startTime = 0L;
            this.uLastTick = 0L;
            this.gLastTick = 0L;
            this.lastOutput = 0L;
        }
        this.stopWatch.reset();
    }

    public String toString() {
        return new StringBuilder(19).append("Debugger for ").append(this.tileName).append(". ").append(this.stopWatch).append(" t: ").append(this.totalUsed).toString();
    }

    public static final /* synthetic */ void $anonfun$finish$1(EnergyDebug $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        EnergyUsage usage = (EnergyUsage)((Object)tuple2._1());
        long amount = tuple2._2$mcJ$sp();
        QuarryPlus.LOGGER.info(new StringBuilder(3).append(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)usage), " used ")).append(amount / $this.mj).append("MJ.").toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public EnergyDebug(APowerTile tile) {
        this.tile = tile;
        this.tileName = tile.getClass().getSimpleName();
        this.got = (long[])Array$.MODULE$.ofDim(100, ClassTag$.MODULE$.Long());
        this.used = (long[])Array$.MODULE$.ofDim(100, ClassTag$.MODULE$.Long());
        this.gotCount = 0;
        this.usedCount = 0;
        this.totalUsed = 0L;
        this.uLastTick = 0L;
        this.gLastTick = 0L;
        this.lastOutput = 0L;
        this.mj = APowerTile.MicroJtoMJ;
        this.stopWatch = Stopwatch.createUnstarted();
        this.startTime = 0L;
        this.usageMap = Map$.MODULE$.empty();
    }
}

