/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.base;

import com.yogpc.qp.machines.TranslationKeys;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import jp.t2v.lab.syntax.MapStreamSyntax;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public interface IEnchantableTile {
    public static final ResourceLocation FortuneID = ForgeRegistries.ENCHANTMENTS.getKey((IForgeRegistryEntry)Enchantments.field_185308_t);
    public static final ResourceLocation SilktouchID = ForgeRegistries.ENCHANTMENTS.getKey((IForgeRegistryEntry)Enchantments.field_185306_r);
    public static final ResourceLocation EfficiencyID = ForgeRegistries.ENCHANTMENTS.getKey((IForgeRegistryEntry)Enchantments.field_185305_q);
    public static final ResourceLocation UnbreakingID = ForgeRegistries.ENCHANTMENTS.getKey((IForgeRegistryEntry)Enchantments.field_185307_s);
    public static final BiPredicate<ResourceLocation, Integer> isValidEnch = (id, level) -> {
        if (id.equals((Object)FortuneID) || id.equals((Object)UnbreakingID)) {
            return level <= 3;
        }
        if (id.equals((Object)EfficiencyID)) {
            return level <= 5;
        }
        return id.equals((Object)SilktouchID) && level == 1;
    };

    public void G_ReInit();

    @Nonnull
    public Map<ResourceLocation, Integer> getEnchantments();

    public void setEnchantment(ResourceLocation var1, short var2);

    default public void sendEnchantMassage(EntityPlayer player) {
        Util.getEnchantmentsChat(this).forEach(c -> player.func_146105_b(c, false));
    }

    default public ItemStack getEnchantedPickaxe() {
        ItemStack stack = new ItemStack((IItemProvider)Items.field_151046_w);
        this.getEnchantments().entrySet().stream().filter(MapStreamSyntax.byEntry((k, v) -> true)).map(MapStreamSyntax.keys(arg_0 -> ((IForgeRegistry)ForgeRegistries.ENCHANTMENTS).getValue(arg_0))).filter(MapStreamSyntax.byKey(Objects::nonNull)).forEach(MapStreamSyntax.entry((arg_0, arg_1) -> ((ItemStack)stack).func_77966_a(arg_0, arg_1)));
        return stack;
    }

    public static class Util {
        public static void init(@Nonnull IEnchantableTile te, @Nonnull NBTTagList tagList) {
            tagList.stream().map(NBTTagCompound.class::cast).map(MapStreamSyntax.toEntry(n -> n.func_74779_i("id"), n -> n.func_74765_d("lvl"))).map(MapStreamSyntax.keys(ResourceLocation::new)).forEach(MapStreamSyntax.entry(te::setEnchantment));
            te.G_ReInit();
        }

        static List<ITextComponent> getEnchantmentsChat(@Nonnull IEnchantableTile te) {
            Map<ResourceLocation, Integer> enchantments = te.getEnchantments();
            if (enchantments.size() <= 0) {
                return Collections.singletonList(new TextComponentTranslation("chat.plusenchantno", new Object[0]));
            }
            LinkedList collect = enchantments.entrySet().stream().map(MapStreamSyntax.keys(arg_0 -> ((IForgeRegistry)ForgeRegistries.ENCHANTMENTS).getValue(arg_0))).filter(MapStreamSyntax.byKey(Objects::nonNull)).map(MapStreamSyntax.toAny((enchantment, level) -> new TextComponentTranslation("chat.indent", new Object[]{new TextComponentTranslation(enchantment.func_77320_a(), new Object[0]), enchantment.func_77325_b() != 1 ? new TextComponentTranslation(TranslationKeys.ENCHANT_LEVELS.getOrDefault(level, level.toString()), new Object[0]) : ""}))).collect(Collectors.toCollection(LinkedList::new));
            collect.addFirst(new TextComponentTranslation("chat.plusenchant", new Object[0]));
            return collect;
        }

        public static void enchantmentToIS(@Nonnull IEnchantableTile te, @Nonnull ItemStack is) {
            te.getEnchantments().entrySet().stream().map(MapStreamSyntax.keys(arg_0 -> ((IForgeRegistry)ForgeRegistries.ENCHANTMENTS).getValue(arg_0))).filter(MapStreamSyntax.byKey(Objects::nonNull)).forEach(MapStreamSyntax.entry((arg_0, arg_1) -> ((ItemStack)is).func_77966_a(arg_0, arg_1)));
        }

        @Nonnull
        public static <T extends IEnchantableTile> Consumer<T> initConsumer(ItemStack stack) {
            return t -> Util.init(t, stack.func_77986_q());
        }
    }
}

