/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.exppump;

import com.yogpc.qp.machines.base.IEnchantableTile;
import com.yogpc.qp.machines.base.QPBlock;
import com.yogpc.qp.machines.exppump.ItemBlockExpPump;
import com.yogpc.qp.machines.exppump.TileExpPump;
import com.yogpc.qp.utils.Holder;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import scala.Symbol;

public class BlockExpPump
extends QPBlock {
    public static final Symbol SYMBOL = Symbol.apply((String)"ExpPump");

    public BlockExpPump() {
        super(Block.Properties.func_200945_a((Material)Material.field_151574_g).func_200943_b(5.0f), "exppump", ItemBlockExpPump::new);
        this.func_180632_j((IBlockState)((IBlockState)((IBlockState)this.func_176194_O().func_177621_b()).func_206870_a((IProperty)BlockStateProperties.field_208180_g, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)QPBlock.WORKING(), (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{BlockStateProperties.field_208180_g, QPBlock.WORKING()});
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return Holder.expPumpTileType().func_200968_a();
    }

    @Override
    public boolean func_196250_a(IBlockState state, World worldIn, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (super.func_196250_a(state, worldIn, pos, player, hand, side, hitX, hitY, hitZ)) {
            return true;
        }
        if (!player.func_70093_af()) {
            TileEntity tileEntity;
            if (!worldIn.field_72995_K && (tileEntity = worldIn.func_175625_s(pos)) instanceof TileExpPump) {
                TileExpPump expPump = (TileExpPump)tileEntity;
                expPump.onActivated(worldIn, pos, player);
            }
            return true;
        }
        return false;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        TileEntity entity = worldIn.func_175625_s(pos);
        if (entity instanceof IEnchantableTile) {
            IEnchantableTile.Util.initConsumer(stack).accept((IEnchantableTile)entity);
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        Optional.ofNullable((TileExpPump)worldIn.func_175625_s(pos)).ifPresent(TileExpPump::G_ReInit);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest, IFluidState fluid) {
        return willHarvest || super.removedByPlayer(state, world, pos, player, false, fluid);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        worldIn.func_175698_g(pos);
    }

    public void getDrops(IBlockState state, NonNullList<ItemStack> drops, World world, BlockPos pos, int fortune) {
        TileEntity entity = world.func_175625_s(pos);
        if (entity instanceof TileExpPump) {
            TileExpPump pump = (TileExpPump)entity;
            ItemStack stack = new ItemStack((IItemProvider)this, 1);
            IEnchantableTile.Util.enchantmentToIS(pump, stack);
            drops.add((Object)stack);
        }
    }

    public void func_196243_a(IBlockState state, World worldIn, BlockPos pos, IBlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity entity;
            if (!worldIn.field_72995_K && (entity = worldIn.func_175625_s(pos)) instanceof TileExpPump) {
                TileExpPump pump = (TileExpPump)entity;
                pump.onBreak(worldIn);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }
}

