/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.exppump;

import com.yogpc.qp.machines.base.APacketTile;
import com.yogpc.qp.machines.base.IAttachable;
import com.yogpc.qp.machines.base.IAttachment;
import com.yogpc.qp.machines.base.IDebugSender;
import com.yogpc.qp.machines.base.IEnchantableTile;
import com.yogpc.qp.machines.base.QPBlock;
import com.yogpc.qp.machines.exppump.BlockExpPump;
import com.yogpc.qp.utils.Holder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jp.t2v.lab.syntax.MapStreamSyntax;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;
import scala.Symbol;

public class TileExpPump
extends APacketTile
implements IEnchantableTile,
IDebugSender,
IAttachment {
    @Nullable
    private EnumFacing mConnectTo;
    private int xpAmount = 0;
    private int fortune = 0;
    private int unbreaking = 0;
    private boolean silktouch = false;

    public TileExpPump() {
        super(Holder.expPumpTileType());
    }

    @Override
    protected Symbol getSymbol() {
        return BlockExpPump.SYMBOL;
    }

    @Override
    public void setConnectTo(@Nullable EnumFacing connectTo) {
        this.mConnectTo = connectTo;
        if (this.func_145830_o()) {
            IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
            if (!this.working() == (Boolean)state.func_177229_b((IProperty)QPBlock.WORKING())) {
                this.field_145850_b.func_175656_a(this.field_174879_c, (IBlockState)state.func_206870_a((IProperty)QPBlock.WORKING(), (Comparable)Boolean.valueOf(this.working())));
            }
        }
    }

    @Override
    public String getDebugName() {
        return "block.quarryplus.exppump";
    }

    @Override
    public List<? extends ITextComponent> getDebugMessages() {
        return Stream.of("Connection -> " + this.mConnectTo, Stream.of("Unbreaking -> " + this.unbreaking, "Fortune -> " + this.fortune, "Silktouch -> " + this.silktouch).reduce(combiner).get(), "XpAmount -> " + this.xpAmount).map(toComponentString).collect(Collectors.toList());
    }

    public void onLoad() {
        this.refreshConnection();
    }

    @Override
    public void G_ReInit() {
        this.refreshConnection();
    }

    private void refreshConnection() {
        Map.Entry entry;
        if (this.func_145830_o() && !this.field_145850_b.field_72995_K && ((entry = Stream.of(EnumFacing.values()).map(f -> Pair.of((Object)f, (Object)this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(f)))).filter(MapStreamSyntax.byValue(t -> t instanceof IAttachable)).map(MapStreamSyntax.values(t -> (IAttachable)t)).filter(pair -> ((IAttachable)pair.getValue()).connect(((EnumFacing)pair.getKey()).func_176734_d(), IAttachment.Attachments.EXP_PUMP)).findFirst().orElse((Map.Entry)Pair.of(null, (Object)IAttachable.dummy))).getKey() == null || ((IAttachable)entry.getValue()).connectAttachment(((EnumFacing)entry.getKey()).func_176734_d(), IAttachment.Attachments.EXP_PUMP, false))) {
            this.setConnectTo((EnumFacing)entry.getKey());
        }
    }

    public void addXp(int amount) {
        this.xpAmount += amount;
        if (this.xpAmount > 0 ^ (Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockStateProperties.field_208180_g)) {
            IBlockState state = (IBlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((IProperty)BlockStateProperties.field_208180_g, (Comparable)Boolean.valueOf(this.xpAmount > 0));
            this.field_145850_b.func_175656_a(this.field_174879_c, state);
        }
    }

    public long getEnergyUse(int amount) {
        return (long)(amount * 10) * 1000000L / (long)(1 + this.unbreaking);
    }

    public void onActivated(World worldIn, BlockPos pos, EntityPlayer playerIn) {
        if (this.xpAmount > 0) {
            int xp = EntityXPOrb.func_70527_a((int)this.xpAmount);
            EntityXPOrb orb = new EntityXPOrb(worldIn, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, xp);
            worldIn.func_72838_d((Entity)orb);
            this.addXp(-xp);
        }
    }

    public void onBreak(World worldIn) {
        if (this.xpAmount > 0) {
            EntityXPOrb xpOrb = new EntityXPOrb(worldIn, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), this.xpAmount);
            worldIn.func_72838_d((Entity)xpOrb);
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        byte connectID = compound.func_74771_c("mConnectTo");
        this.mConnectTo = connectID < 0 ? null : EnumFacing.func_82600_a((int)connectID);
        this.xpAmount = compound.func_74762_e("xpAmount");
        this.silktouch = compound.func_74767_n("silktouch");
        this.fortune = compound.func_74771_c("fortune");
        this.unbreaking = compound.func_74771_c("unbreaking");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74774_a("mConnectTo", Optional.ofNullable(this.mConnectTo).map(Enum::ordinal).orElse(-1).byteValue());
        compound.func_74768_a("xpAmount", this.xpAmount);
        compound.func_74757_a("silktouch", this.silktouch);
        compound.func_74774_a("fortune", (byte)this.fortune);
        compound.func_74774_a("unbreaking", (byte)this.unbreaking);
        return super.func_189515_b(compound);
    }

    @Override
    @Nonnull
    public Map<ResourceLocation, Integer> getEnchantments() {
        HashMap<ResourceLocation, Integer> map = new HashMap<ResourceLocation, Integer>();
        if (this.fortune > 0) {
            map.put(FortuneID, this.fortune);
        }
        if (this.unbreaking > 0) {
            map.put(UnbreakingID, this.unbreaking);
        }
        if (this.silktouch) {
            map.put(SilktouchID, 1);
        }
        return map;
    }

    @Override
    public void setEnchantment(ResourceLocation id, short val) {
        if (id.equals((Object)FortuneID)) {
            this.fortune = val;
        } else if (id.equals((Object)UnbreakingID)) {
            this.unbreaking = val;
        } else if (id.equals((Object)SilktouchID)) {
            this.silktouch = val > 0;
        }
    }

    public boolean working() {
        return this.mConnectTo != null;
    }
}

