/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.marker;

import com.yogpc.qp.machines.marker.TileMarker;
import com.yogpc.qp.utils.Holder;
import java.util.stream.Stream;
import jp.t2v.lab.syntax.MapStreamSyntax;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemGroup;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockMarker
extends Block {
    private static final VoxelShape STANDING_Shape = VoxelShapes.func_197873_a((double)0.35, (double)0.0, (double)0.35, (double)0.65, (double)0.65, (double)0.65);
    private static final VoxelShape DOWN_Shape = VoxelShapes.func_197873_a((double)0.35, (double)0.35, (double)0.35, (double)0.65, (double)1.0, (double)0.65);
    private static final VoxelShape NORTH_Shape = VoxelShapes.func_197873_a((double)0.35, (double)0.35, (double)0.35, (double)0.65, (double)0.65, (double)1.0);
    private static final VoxelShape SOUTH_Shape = VoxelShapes.func_197873_a((double)0.35, (double)0.35, (double)0.0, (double)0.65, (double)0.65, (double)0.65);
    private static final VoxelShape WEST_Shape = VoxelShapes.func_197873_a((double)0.35, (double)0.35, (double)0.35, (double)1.0, (double)0.65, (double)0.65);
    private static final VoxelShape EAST_Shape = VoxelShapes.func_197873_a((double)0.0, (double)0.35, (double)0.35, (double)0.65, (double)0.65, (double)0.65);
    public final ItemBlock itemBlock;

    public BlockMarker() {
        super(Block.Properties.func_200945_a((Material)Material.field_151594_q).func_200951_a(7));
        this.setRegistryName("quarryplus", "markerplus");
        this.itemBlock = new ItemBlock((Block)this, new Item.Properties().func_200916_a((ItemGroup)Holder.tab()));
        this.itemBlock.setRegistryName("quarryplus", "markerplus");
        this.func_180632_j((IBlockState)((IBlockState)this.func_176194_O().func_177621_b()).func_206870_a((IProperty)BlockStateProperties.field_208155_H, (Comparable)EnumFacing.NORTH));
    }

    public Item func_199767_j() {
        return this.itemBlock;
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{BlockStateProperties.field_208155_H});
    }

    public IBlockState func_196258_a(BlockItemUseContext context) {
        return (IBlockState)this.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208155_H, (Comparable)context.func_196000_l());
    }

    public boolean func_196250_a(IBlockState state, World worldIn, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity entity;
        if (!worldIn.field_72995_K && (entity = worldIn.func_175625_s(pos)) instanceof TileMarker) {
            TileMarker marker = (TileMarker)entity;
            if (!marker.hasLink()) {
                marker.activated();
            } else {
                player.func_146105_b((ITextComponent)new TextComponentString(marker.link.toString()), false);
            }
        }
        return true;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!worldIn.field_72995_K) {
            Stream.of(worldIn.func_175625_s(pos)).flatMap(MapStreamSyntax.streamCast(TileMarker.class)).forEach(TileMarker::redstoneUpdate);
        }
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(IBlockState state, IBlockReader world) {
        return Holder.markerTileType().func_200968_a();
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public BlockFaceShape func_193383_a(IBlockReader worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public VoxelShape func_196244_b(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)BlockStateProperties.field_208155_H)) {
            default: {
                return STANDING_Shape;
            }
            case DOWN: {
                return DOWN_Shape;
            }
            case NORTH: {
                return NORTH_Shape;
            }
            case SOUTH: {
                return SOUTH_Shape;
            }
            case WEST: {
                return WEST_Shape;
            }
            case EAST: 
        }
        return EAST_Shape;
    }

    public VoxelShape func_196268_f(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        return VoxelShapes.func_197880_a();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_200122_a(IBlockState state, IBlockState adjacentBlockState, EnumFacing side) {
        return true;
    }

    public boolean func_196260_a(IBlockState state, IWorldReaderBase worldIn, BlockPos pos) {
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)BlockStateProperties.field_208155_H);
        BlockPos blockpos = pos.func_177972_a(enumfacing.func_176734_d());
        IBlockState iblockstate = worldIn.func_180495_p(blockpos);
        return iblockstate.func_193401_d((IBlockReader)worldIn, blockpos, enumfacing) == BlockFaceShape.SOLID;
    }

    public IBlockState func_196271_a(IBlockState stateIn, EnumFacing facing, IBlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return !stateIn.func_196955_c((IWorldReaderBase)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : stateIn;
    }
}

