/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.marker;

import com.yogpc.qp.Config;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.base.IDebugSender;
import com.yogpc.qp.machines.base.IMarker;
import com.yogpc.qp.packet.PacketHandler;
import com.yogpc.qp.packet.marker.LinkMessage;
import com.yogpc.qp.packet.marker.UpdateBoxMessage;
import com.yogpc.qp.render.Box;
import com.yogpc.qp.utils.Holder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import jp.t2v.lab.syntax.MapStreamSyntax;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.tuple.Pair;

public class TileMarker
extends TileEntity
implements IMarker,
IDebugSender {
    private static final int MAX_SIZE = 256;
    public Link link = Link.DEFAULT;
    public Laser laser;

    public TileMarker() {
        super(Holder.markerTileType());
    }

    @Override
    public boolean hasLink() {
        return this.link.hasXLink() && this.link.hasZLink();
    }

    @Override
    public BlockPos min() {
        return this.link.min();
    }

    @Override
    public BlockPos max() {
        return this.link.max();
    }

    @Override
    public List<ItemStack> removeFromWorldWithItem() {
        return Collections.emptyList();
    }

    public void onLoad() {
        this.laser = new Laser(this.func_145831_w(), this.func_174877_v(), this.link);
    }

    public void func_145843_s() {
        this.removeLink();
        super.func_145843_s();
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @OnlyIn(value=Dist.CLIENT)
    public double func_145833_n() {
        if (this.laser.hasLaser() || this.link.hasAnyLink()) {
            return 262144.0;
        }
        return super.func_145833_n();
    }

    public boolean hasFastRenderer() {
        return true;
    }

    public void activated() {
        Link.updateLinks(this.func_145831_w(), this.func_174877_v());
        if (!this.field_145850_b.field_72995_K) {
            PacketHandler.sendToClient(LinkMessage.create(this), this.func_145831_w());
        }
        QuarryPlus.LOGGER.debug(String.format("Marker signal updated. Link: %s, Laser: %s", this.link, this.laser));
    }

    public void redstoneUpdate() {
        if (!this.field_145850_b.field_72995_K) {
            PacketHandler.sendToClient(UpdateBoxMessage.create(this, this.field_145850_b.func_175640_z(this.field_174879_c)), this.func_145831_w());
        }
    }

    public void setLink(Link link) {
        this.link = link;
        this.laser = new Laser(this.func_145831_w(), this.func_174877_v(), this.link);
    }

    public void removeLink() {
        this.link.edges().map(arg_0 -> ((World)this.field_145850_b).func_175625_s(arg_0)).flatMap(MapStreamSyntax.streamCast(TileMarker.class)).forEach(m -> m.setLink(Link.DEFAULT));
    }

    @Override
    public String getDebugName() {
        return "block.quarryplus.markerplus";
    }

    @Override
    public List<? extends ITextComponent> getDebugMessages() {
        return Arrays.asList(new TextComponentString("Link : " + this.link), new TextComponentString("Laser : " + this.laser));
    }

    public static class Link {
        public static final Link DEFAULT = new Link(0, 0, 0, 0, 0, 0){

            @Override
            public boolean hasAnyLink() {
                return false;
            }

            @Override
            public BlockPos min() {
                return BlockPos.field_177992_a;
            }

            @Override
            public BlockPos max() {
                return BlockPos.field_177992_a;
            }

            @Override
            public Link setWorld(World world) {
                return this;
            }

            @Override
            public Stream<BlockPos> edges() {
                return Stream.empty();
            }

            @Override
            public String toString() {
                return "Link DEFAULT";
            }
        };
        private final boolean hasX;
        private final boolean hasY;
        private final boolean hasZ;
        public final int xMax;
        public final int xMin;
        public final int yMax;
        public final int yMin;
        public final int zMax;
        public final int zMin;
        public final AxisAlignedBB[] lineBoxes = new AxisAlignedBB[12];
        @Nullable
        public Box[] boxes;

        public Link(int x1, int x2, int y1, int y2, int z1, int z2) {
            this.xMax = Math.max(x1, x2);
            this.xMin = Math.min(x1, x2);
            this.yMax = Math.max(y1, y2);
            this.yMin = Math.min(y1, y2);
            this.zMax = Math.max(z1, z2);
            this.zMin = Math.min(z1, z2);
            this.hasX = this.xMax != this.xMin;
            this.hasY = this.yMax != this.yMin;
            this.hasZ = this.zMax != this.zMin;
        }

        public Link(BlockPos pos) {
            this.xMax = pos.func_177958_n();
            this.xMin = pos.func_177958_n();
            this.yMax = pos.func_177956_o();
            this.yMin = pos.func_177956_o();
            this.zMax = pos.func_177952_p();
            this.zMin = pos.func_177952_p();
            this.hasX = this.xMax != this.xMin;
            this.hasY = this.yMax != this.yMin;
            this.hasZ = this.zMax != this.zMin;
        }

        public Link(int x1, int x2, int y1, int y2, int z1, int z2, World world) {
            this(x1, x2, y1, y2, z1, z2);
            int flag = 0;
            double a = 0.5;
            double b = 0.625;
            double c = 0.375;
            if (this.hasXLink()) {
                flag |= 1;
            }
            if (this.hasYLink()) {
                flag |= 2;
            }
            if (this.hasZLink()) {
                flag |= 4;
            }
            if ((flag & 1) == 1) {
                this.lineBoxes[0] = new AxisAlignedBB((double)this.xMin + 0.625, (double)this.yMin + 0.5, (double)this.zMin + 0.5, (double)this.xMax + 0.375, (double)this.yMin + 0.5, (double)this.zMin + 0.5);
            }
            if ((flag & 2) == 2) {
                this.lineBoxes[4] = new AxisAlignedBB((double)this.xMin + 0.5, (double)this.yMin + 0.625, (double)this.zMin + 0.5, (double)this.xMin + 0.5, (double)this.yMax + 0.375, (double)this.zMin + 0.5);
            }
            if ((flag & 4) == 4) {
                this.lineBoxes[8] = new AxisAlignedBB((double)this.xMin + 0.5, (double)this.yMin + 0.5, (double)this.zMin + 0.625, (double)this.xMin + 0.5, (double)this.yMin + 0.5, (double)this.zMax + 0.375);
            }
            if ((flag & 3) == 3) {
                this.lineBoxes[2] = new AxisAlignedBB((double)this.xMin + 0.625, (double)this.yMax + 0.5, (double)this.zMin + 0.5, (double)this.xMax + 0.375, (double)this.yMax + 0.5, (double)this.zMin + 0.5);
                this.lineBoxes[6] = new AxisAlignedBB((double)this.xMax + 0.5, (double)this.yMin + 0.625, (double)this.zMin + 0.5, (double)this.xMax + 0.5, (double)this.yMax + 0.375, (double)this.zMin + 0.5);
            }
            if ((flag & 5) == 5) {
                this.lineBoxes[1] = new AxisAlignedBB((double)this.xMin + 0.625, (double)this.yMin + 0.5, (double)this.zMax + 0.5, (double)this.xMax + 0.375, (double)this.yMin + 0.5, (double)this.zMax + 0.5);
                this.lineBoxes[9] = new AxisAlignedBB((double)this.xMax + 0.5, (double)this.yMin + 0.5, (double)this.zMin + 0.625, (double)this.xMax + 0.5, (double)this.yMin + 0.5, (double)this.zMax + 0.375);
            }
            if ((flag & 6) == 6) {
                this.lineBoxes[5] = new AxisAlignedBB((double)this.xMin + 0.5, (double)this.yMin + 0.625, (double)this.zMax + 0.5, (double)this.xMin + 0.5, (double)this.yMax + 0.375, (double)this.zMax + 0.5);
                this.lineBoxes[10] = new AxisAlignedBB((double)this.xMin + 0.5, (double)this.yMax + 0.5, (double)this.zMin + 0.625, (double)this.xMin + 0.5, (double)this.yMax + 0.5, (double)this.zMax + 0.375);
            }
            if ((flag & 7) == 7) {
                this.lineBoxes[3] = new AxisAlignedBB((double)this.xMin + 0.625, (double)this.yMax + 0.5, (double)this.zMax + 0.5, (double)this.xMax + 0.375, (double)this.yMax + 0.5, (double)this.zMax + 0.5);
                this.lineBoxes[7] = new AxisAlignedBB((double)this.xMax + 0.5, (double)this.yMin + 0.625, (double)this.zMax + 0.5, (double)this.xMax + 0.5, (double)this.yMax + 0.375, (double)this.zMax + 0.5);
                this.lineBoxes[11] = new AxisAlignedBB((double)this.xMax + 0.5, (double)this.yMax + 0.5, (double)this.zMin + 0.625, (double)this.xMax + 0.5, (double)this.yMax + 0.5, (double)this.zMax + 0.375);
            }
            this.boxes = world.field_72995_K && (Boolean)Config.client().enableRender().get() != false ? (Box[])Stream.of(this.lineBoxes).filter(Objects::nonNull).map(range -> Box.apply(range, 0.125, 0.125, 0.125, false, false)).toArray(Box[]::new) : null;
        }

        boolean hasXLink() {
            return this.hasX;
        }

        boolean hasYLink() {
            return this.hasY;
        }

        boolean hasZLink() {
            return this.hasZ;
        }

        public boolean hasAnyLink() {
            return this.hasX || this.hasY || this.hasZ;
        }

        public BlockPos min() {
            return new BlockPos(this.xMin, this.yMin, this.zMin);
        }

        public BlockPos max() {
            return new BlockPos(this.xMax, this.yMax, this.zMax);
        }

        public String toString() {
            long i = BooleanUtils.toInteger((boolean)this.hasX) + BooleanUtils.toInteger((boolean)this.hasY) + BooleanUtils.toInteger((boolean)this.hasZ);
            return this.min() + " to " + this.max() + " Lasers : " + i * 2L;
        }

        public Link setWorld(World world) {
            return new Link(this.xMax, this.xMin, this.yMax, this.yMin, this.zMax, this.zMin, world);
        }

        public Stream<BlockPos> edges() {
            return Stream.of(this.xMin, this.xMax).flatMap(x -> Stream.of(Pair.of((Object)x, (Object)this.yMin), Pair.of((Object)x, (Object)this.yMax))).flatMap(xy -> Stream.of(new BlockPos(((Integer)xy.getLeft()).intValue(), ((Integer)xy.getRight()).intValue(), this.zMin), new BlockPos(((Integer)xy.getLeft()).intValue(), ((Integer)xy.getRight()).intValue(), this.zMax))).distinct();
        }

        public static Link of(int x1, int x2, int y1, int y2, int z1, int z2) {
            if (x1 == 0 && x2 == 0 && y1 == 0 && y2 == 0 && z1 == 0 && z2 == 0) {
                return DEFAULT;
            }
            return new Link(x1, x2, y1, y2, z1, z2);
        }

        public static void updateLinks(World world, BlockPos originPos) {
            Link newLink = Link.searchInternal(world, originPos, new Link(originPos)).setWorld(world);
            newLink.edges().map(arg_0 -> ((World)world).func_175625_s(arg_0)).flatMap(MapStreamSyntax.streamCast(TileMarker.class)).forEach(m -> m.setLink(newLink));
        }

        private static Link searchInternal(World world, BlockPos originPos, Link link) {
            TileEntity tile;
            int i;
            int xOffsetTemp = 0;
            int yOffsetTemp = 0;
            int zOffsetTemp = 0;
            int nXMax = link.xMax;
            int nXMin = link.xMin;
            int nYMax = link.yMax;
            int nYMin = link.yMin;
            int nZMax = link.zMax;
            int nZMin = link.zMin;
            if (!link.hasXLink()) {
                for (i = 1; i < 256; ++i) {
                    tile = world.func_175625_s(originPos.func_177982_a(i, 0, 0));
                    if (tile instanceof TileMarker && !((TileMarker)tile).hasLink()) {
                        xOffsetTemp = i;
                        nXMax += i;
                        break;
                    }
                    tile = world.func_175625_s(originPos.func_177982_a(-i, 0, 0));
                    if (!(tile instanceof TileMarker) || ((TileMarker)tile).hasLink()) continue;
                    xOffsetTemp = -i;
                    nXMin -= i;
                    break;
                }
            }
            if (!link.hasYLink()) {
                for (i = 1; i < 256; ++i) {
                    tile = world.func_175625_s(originPos.func_177982_a(0, i, 0));
                    if (tile instanceof TileMarker && !((TileMarker)tile).link.hasYLink()) {
                        yOffsetTemp = i;
                        nYMax += i;
                        break;
                    }
                    tile = world.func_175625_s(originPos.func_177982_a(0, -i, 0));
                    if (!(tile instanceof TileMarker) || ((TileMarker)tile).link.hasYLink()) continue;
                    yOffsetTemp = -i;
                    nYMin -= i;
                    break;
                }
            }
            if (!link.hasZLink()) {
                for (i = 1; i < 256; ++i) {
                    tile = world.func_175625_s(originPos.func_177982_a(0, 0, i));
                    if (tile instanceof TileMarker && !((TileMarker)tile).hasLink()) {
                        nZMax += i;
                        zOffsetTemp = i;
                        break;
                    }
                    tile = world.func_175625_s(originPos.func_177982_a(0, 0, -i));
                    if (!(tile instanceof TileMarker) || ((TileMarker)tile).hasLink()) continue;
                    zOffsetTemp = -i;
                    nZMin -= i;
                    break;
                }
            }
            int xOffset = xOffsetTemp;
            int yOffset = yOffsetTemp;
            int zOffset = zOffsetTemp;
            return Optional.of(Link.of(nXMin, nXMax, nYMax, nYMin, nZMax, nZMin)).map(link1 -> {
                if (!link1.hasXLink() && yOffset != 0) {
                    return Link.searchInternal(world, originPos.func_177982_a(0, yOffset, 0), link1);
                }
                return link1;
            }).map(link1 -> {
                if (!link1.hasXLink() && zOffset != 0) {
                    return Link.searchInternal(world, originPos.func_177982_a(0, 0, zOffset), link1);
                }
                return link1;
            }).map(link1 -> {
                if (!link1.hasYLink() && xOffset != 0) {
                    return Link.searchInternal(world, originPos.func_177982_a(xOffset, 0, 0), link1);
                }
                return link1;
            }).map(link1 -> {
                if (!link1.hasYLink() && zOffset != 0) {
                    return Link.searchInternal(world, originPos.func_177982_a(0, 0, zOffset), link1);
                }
                return link1;
            }).map(link1 -> {
                if (!link1.hasZLink() && xOffset != 0) {
                    return Link.searchInternal(world, originPos.func_177982_a(xOffset, 0, 0), link1);
                }
                return link1;
            }).map(link1 -> {
                if (!link1.hasZLink() && yOffset != 0) {
                    return Link.searchInternal(world, originPos.func_177982_a(0, yOffset, 0), link1);
                }
                return link1;
            }).filter(Link::hasAnyLink).orElse(DEFAULT);
        }
    }

    public static class Laser {
        final AxisAlignedBB[] lasers = new AxisAlignedBB[6];
        @Nullable
        public Box[] boxes;

        public Laser(World world, BlockPos pos, @Nullable Link definedLink) {
            int px = pos.func_177958_n();
            int py = pos.func_177956_o();
            int pz = pos.func_177952_p();
            double b = 0.625;
            double c = 0.375;
            if (definedLink == null || !definedLink.hasXLink()) {
                this.lasers[0] = new AxisAlignedBB((double)px + 0.625 - 256.0, (double)py + 0.5, (double)pz + 0.5, (double)px + 0.375, (double)py + 0.5, (double)pz + 0.5);
                this.lasers[3] = new AxisAlignedBB((double)px + 0.625, (double)py + 0.5, (double)pz + 0.5, (double)px + 0.375 + 256.0, (double)py + 0.5, (double)pz + 0.5);
            }
            if (definedLink == null || !definedLink.hasYLink()) {
                this.lasers[1] = new AxisAlignedBB((double)px + 0.5, 0.0, (double)pz + 0.5, (double)px + 0.5, (double)py - 0.1, (double)pz + 0.5);
                this.lasers[4] = new AxisAlignedBB((double)px + 0.5, (double)py + 0.625, (double)pz + 0.5, (double)px + 0.5, 255.0, (double)pz + 0.5);
            }
            if (definedLink == null || !definedLink.hasZLink()) {
                this.lasers[2] = new AxisAlignedBB((double)px + 0.5, (double)py + 0.5, (double)pz + 0.625 - 256.0, (double)px + 0.5, (double)py + 0.5, (double)pz + 0.375);
                this.lasers[5] = new AxisAlignedBB((double)px + 0.5, (double)py + 0.5, (double)pz + 0.625, (double)px + 0.5, (double)py + 0.5, (double)pz + 0.375 + 256.0);
            }
            this.boxUpdate(world, world.func_175640_z(pos));
        }

        public String toString() {
            long i = Stream.of(this.lasers).filter(Objects::nonNull).count();
            return "Lasers : " + i;
        }

        public boolean hasLaser() {
            return Stream.of(this.lasers).anyMatch(Objects::nonNull);
        }

        public void boxUpdate(World world, boolean on) {
            this.boxes = world.field_72995_K && (Boolean)Config.client().enableRender().get() != false && on ? (Box[])Stream.of(this.lasers).filter(Objects::nonNull).map(range -> Box.apply(range, 0.125, 0.125, 0.125, false, false)).toArray(Box[]::new) : null;
        }
    }
}

