/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.pump;

import com.yogpc.qp.compat.BuildcraftHelper;
import com.yogpc.qp.machines.base.IEnchantableTile;
import com.yogpc.qp.machines.base.QPBlock;
import com.yogpc.qp.machines.pump.ItemBlockPump;
import com.yogpc.qp.machines.pump.TilePump;
import com.yogpc.qp.utils.Holder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BlockPump
extends QPBlock {
    private final ArrayList<ItemStack> drop = new ArrayList();

    public BlockPump() {
        super(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(5.0f), "pumpplus", ItemBlockPump::new);
        this.func_180632_j((IBlockState)((IBlockState)((IBlockState)this.func_176194_O().func_177621_b()).func_206870_a((IProperty)QPBlock.WORKING(), (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)BlockStateProperties.field_208180_g, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{QPBlock.WORKING(), BlockStateProperties.field_208180_g});
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return Holder.pumpTileType().func_200968_a();
    }

    public void func_196243_a(IBlockState state, World worldIn, BlockPos pos, IBlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            this.drop.clear();
            Optional.ofNullable((TilePump)worldIn.func_175625_s(pos)).ifPresent(pump -> {
                ItemStack stack = new ItemStack((IItemProvider)this, 1);
                IEnchantableTile.Util.enchantmentToIS(pump, stack);
                this.drop.add(stack);
            });
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public void getDrops(IBlockState state, NonNullList<ItemStack> drops, World world, BlockPos pos, int fortune) {
        drops.addAll(this.drop);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        Optional.ofNullable((IEnchantableTile)worldIn.func_175625_s(pos)).ifPresent(IEnchantableTile.Util.initConsumer(stack));
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        Optional.ofNullable((TilePump)worldIn.func_175625_s(pos)).ifPresent(TilePump::G_ReInit);
    }

    @Override
    public boolean func_196250_a(IBlockState state, World worldIn, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (super.func_196250_a(state, worldIn, pos, player, hand, side, hitX, hitY, hitZ)) {
            return true;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (BuildcraftHelper.isWrench(player, hand, stack, new RayTraceResult(new Vec3d((double)hitX, (double)hitY, (double)hitZ), side, pos))) {
            if (!worldIn.field_72995_K) {
                Optional.ofNullable((TilePump)worldIn.func_175625_s(pos)).ifPresent(pump -> pump.S_changeRange(player));
            }
            return true;
        }
        if (stack.func_77973_b() == Holder.itemStatusChecker()) {
            TilePump pump2;
            if (!worldIn.field_72995_K && (pump2 = (TilePump)worldIn.func_175625_s(pos)) != null) {
                pump2.sendEnchantMassage(player);
                pump2.C_getNames().forEach(c -> player.func_146105_b(c, false));
            }
            return true;
        }
        if (stack.func_77973_b() == Holder.itemLiquidSelector()) {
            TilePump pump3;
            if (worldIn.field_72995_K || (pump3 = (TilePump)worldIn.func_175625_s(pos)) != null) {
                // empty if block
            }
            return true;
        }
        return false;
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        tooltip.add((ITextComponent)new TextComponentTranslation("quarryplus.tooltip.blockpump", new Object[]{new TextComponentTranslation("block.quarryplus.quarryplus", new Object[0]), Character.valueOf(' ')}));
    }
}

