/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.quarry;

import com.yogpc.qp.Config;
import com.yogpc.qp.utils.Holder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Stream;
import jp.t2v.lab.syntax.MapStreamSyntax;
import net.minecraft.block.Block;
import net.minecraft.block.BlockEmptyDrops;
import net.minecraft.block.BlockSixWay;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemGroup;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;

public class BlockFrame
extends BlockEmptyDrops {
    public static final BooleanProperty DAMMING = BooleanProperty.func_177716_a((String)"damming");
    public static final VoxelShape BOX_AABB = VoxelShapes.func_197873_a((double)0.25, (double)0.25, (double)0.25, (double)0.75, (double)0.75, (double)0.75);
    public static final VoxelShape North_AABB = VoxelShapes.func_197873_a((double)0.25, (double)0.25, (double)0.0, (double)0.75, (double)0.75, (double)0.25);
    public static final VoxelShape South_AABB = VoxelShapes.func_197873_a((double)0.25, (double)0.25, (double)0.75, (double)0.75, (double)0.75, (double)1.0);
    public static final VoxelShape West_AABB = VoxelShapes.func_197873_a((double)0.0, (double)0.25, (double)0.25, (double)0.25, (double)0.75, (double)0.75);
    public static final VoxelShape East_AABB = VoxelShapes.func_197873_a((double)0.75, (double)0.25, (double)0.25, (double)1.0, (double)0.75, (double)0.75);
    public static final VoxelShape UP_AABB = VoxelShapes.func_197873_a((double)0.25, (double)0.75, (double)0.25, (double)0.75, (double)1.0, (double)0.75);
    public static final VoxelShape Down_AABB = VoxelShapes.func_197873_a((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.25, (double)0.75);
    private static final Map<BooleanProperty, VoxelShape> SHAPE_MAP = Stream.of(Pair.of((Object)BlockStateProperties.field_208151_D, (Object)North_AABB), Pair.of((Object)BlockStateProperties.field_208153_F, (Object)South_AABB), Pair.of((Object)BlockStateProperties.field_208154_G, (Object)West_AABB), Pair.of((Object)BlockStateProperties.field_208152_E, (Object)East_AABB), Pair.of((Object)BlockStateProperties.field_208149_B, (Object)UP_AABB), Pair.of((Object)BlockStateProperties.field_208150_C, (Object)Down_AABB)).collect(MapStreamSyntax.entryToMap());
    private static final BiPredicate<World, BlockPos> HAS_NEIGHBOUR_LIQUID = (world, pos) -> Stream.of(EnumFacing.values()).map(arg_0 -> ((BlockPos)pos).func_177972_a(arg_0)).map(arg_0 -> ((World)world).func_180495_p(arg_0)).anyMatch(state -> !state.func_185917_h() && state.func_185904_a().func_76224_d());
    public final ItemBlock itemBlock;
    private boolean breaking = false;

    public BlockFrame() {
        super(Block.Properties.func_200945_a((Material)Material.field_151592_s).func_200943_b(0.5f));
        this.setRegistryName("quarryplus", "quarryframe");
        this.func_180632_j((IBlockState)((IBlockState)((IBlockState)((IBlockState)((IBlockState)((IBlockState)((IBlockState)((IBlockState)this.func_176194_O().func_177621_b()).func_206870_a((IProperty)BlockStateProperties.field_208151_D, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)BlockStateProperties.field_208152_E, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)BlockStateProperties.field_208153_F, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)BlockStateProperties.field_208154_G, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)BlockStateProperties.field_208149_B, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)BlockStateProperties.field_208150_C, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)DAMMING, (Comparable)Boolean.valueOf(false)));
        this.itemBlock = new ItemBlock((Block)this, new Item.Properties().func_200916_a((ItemGroup)Holder.tab()));
        this.itemBlock.setRegistryName("quarryplus", "quarryframe");
    }

    public Item func_199767_j() {
        return this.itemBlock;
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{BlockStateProperties.field_208151_D, BlockStateProperties.field_208152_E, BlockStateProperties.field_208153_F, BlockStateProperties.field_208154_G, BlockStateProperties.field_208149_B, BlockStateProperties.field_208150_C, DAMMING});
    }

    public IBlockState func_196258_a(BlockItemUseContext context) {
        World worldIn = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        return (IBlockState)((IBlockState)((IBlockState)((IBlockState)((IBlockState)((IBlockState)this.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208151_D, (Comparable)Boolean.valueOf(this.canConnectTo((IWorld)worldIn, pos.func_177978_c())))).func_206870_a((IProperty)BlockStateProperties.field_208152_E, (Comparable)Boolean.valueOf(this.canConnectTo((IWorld)worldIn, pos.func_177974_f())))).func_206870_a((IProperty)BlockStateProperties.field_208153_F, (Comparable)Boolean.valueOf(this.canConnectTo((IWorld)worldIn, pos.func_177968_d())))).func_206870_a((IProperty)BlockStateProperties.field_208154_G, (Comparable)Boolean.valueOf(this.canConnectTo((IWorld)worldIn, pos.func_177976_e())))).func_206870_a((IProperty)BlockStateProperties.field_208150_C, (Comparable)Boolean.valueOf(this.canConnectTo((IWorld)worldIn, pos.func_177977_b())))).func_206870_a((IProperty)BlockStateProperties.field_208149_B, (Comparable)Boolean.valueOf(this.canConnectTo((IWorld)worldIn, pos.func_177984_a())));
    }

    public IBlockState func_196271_a(IBlockState stateIn, EnumFacing facing, IBlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return (IBlockState)stateIn.func_206870_a((IProperty)BlockSixWay.field_196491_B.get(facing), (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, currentPos.func_177972_a(facing))));
    }

    public void func_196243_a(IBlockState state, World worldIn, BlockPos pos, IBlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            if (!((Boolean)Config.common().disableFrameChainBreak().get()).booleanValue()) {
                boolean firstBreak;
                if (this.breaking) {
                    firstBreak = false;
                } else {
                    firstBreak = true;
                    this.breaking = true;
                }
                if (firstBreak) {
                    if (!HAS_NEIGHBOUR_LIQUID.test(worldIn, pos)) {
                        this.breakChain(worldIn, pos);
                    }
                    this.breaking = false;
                }
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    private void breakChain(World world, BlockPos first) {
        if (!world.field_72995_K) {
            HashSet<BlockPos> set = new HashSet<BlockPos>();
            set.add(first);
            ArrayList<BlockPos> nextCheck = new ArrayList<BlockPos>();
            nextCheck.add(first);
            while (!nextCheck.isEmpty()) {
                List list = (List)nextCheck.clone();
                nextCheck.clear();
                for (BlockPos pos : list) {
                    for (EnumFacing dir : EnumFacing.values()) {
                        BlockPos nPos = pos.func_177972_a(dir);
                        IBlockState nBlock = world.func_180495_p(nPos);
                        if (nBlock.func_177230_c() != this || HAS_NEIGHBOUR_LIQUID.test(world, nPos) || !set.add(nPos)) continue;
                        nextCheck.add(nPos);
                    }
                }
            }
            set.forEach(arg_0 -> ((World)world).func_175698_g(arg_0));
        }
    }

    private boolean canConnectTo(IWorld worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos).func_177230_c() == this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_200122_a(IBlockState state, IBlockState adjacentBlockState, EnumFacing side) {
        return true;
    }

    public IBlockState getDammingState() {
        return (IBlockState)this.func_176223_P().func_206870_a((IProperty)DAMMING, (Comparable)Boolean.valueOf(true));
    }

    @OnlyIn(value=Dist.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public VoxelShape func_196244_b(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        return SHAPE_MAP.entrySet().stream().filter(MapStreamSyntax.byKey(arg_0 -> ((IBlockState)state).func_177229_b(arg_0))).map(MapStreamSyntax.valueToAny(Function.identity())).reduce(BOX_AABB, VoxelShapes::func_197872_a);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        if (!((Boolean)Config.common().disableFrameChainBreak().get()).booleanValue() && ((Boolean)state.func_177229_b((IProperty)DAMMING)).booleanValue()) {
            worldIn.func_180501_a(pos, (IBlockState)state.func_206870_a((IProperty)DAMMING, (Comparable)Boolean.valueOf(HAS_NEIGHBOUR_LIQUID.test(worldIn, pos))), 2);
        }
    }
}

