/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.quarry;

import com.yogpc.qp.compat.BuildcraftHelper;
import com.yogpc.qp.machines.base.IEnchantableTile;
import com.yogpc.qp.machines.base.QPBlock;
import com.yogpc.qp.machines.item.YSetterInteractionObject;
import com.yogpc.qp.machines.quarry.ItemBlockEnchantable;
import com.yogpc.qp.machines.quarry.TileMiningWell;
import com.yogpc.qp.utils.Holder;
import java.util.ArrayList;
import java.util.Optional;
import jp.t2v.lab.syntax.MapStreamSyntax;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.INameable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class BlockMiningWell
extends QPBlock {
    private final ArrayList<ItemStack> drops = new ArrayList();

    public BlockMiningWell() {
        super(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(1.5f, 10.0f).func_200947_a(SoundType.field_185851_d), "miningwellplus", ItemBlockEnchantable::new);
        this.func_180632_j((IBlockState)((IBlockState)((IBlockState)this.func_176194_O().func_177621_b()).func_206870_a((IProperty)BlockStateProperties.field_208155_H, (Comparable)EnumFacing.NORTH)).func_206870_a((IProperty)QPBlock.WORKING(), (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public boolean func_196250_a(IBlockState state, World worldIn, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (super.func_196250_a(state, worldIn, pos, player, hand, side, hitX, hitY, hitZ)) {
            return true;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (BuildcraftHelper.isWrench(player, hand, stack, new RayTraceResult(new Vec3d((double)hitX, (double)hitY, (double)hitZ), side, pos))) {
            Optional.ofNullable((TileMiningWell)worldIn.func_175625_s(pos)).ifPresent(TileMiningWell::G_ReInit);
            return true;
        }
        if (stack.func_77973_b() == Holder.itemStatusChecker()) {
            if (!worldIn.field_72995_K) {
                Optional.ofNullable((IEnchantableTile)worldIn.func_175625_s(pos)).ifPresent(t -> t.sendEnchantMassage(player));
            }
            return true;
        }
        if (stack.func_77973_b() == Holder.itemYSetter()) {
            if (!worldIn.field_72995_K) {
                Optional.ofNullable(worldIn.func_175625_s(pos)).flatMap(MapStreamSyntax.optCast(TileMiningWell.class)).ifPresent(t -> NetworkHooks.openGui((EntityPlayerMP)((EntityPlayerMP)player), (IInteractionObject)YSetterInteractionObject.apply((INameable)t), (BlockPos)pos));
            }
            return true;
        }
        return false;
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{BlockStateProperties.field_208155_H, QPBlock.WORKING()});
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (!worldIn.field_72995_K) {
            EnumFacing facing = placer.func_184172_bi().func_176734_d();
            worldIn.func_180501_a(pos, (IBlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208155_H, (Comparable)facing), 2);
            Optional.ofNullable((IEnchantableTile)worldIn.func_175625_s(pos)).ifPresent(IEnchantableTile.Util.initConsumer(stack));
        }
    }

    public void func_196243_a(IBlockState state, World worldIn, BlockPos pos, IBlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileMiningWell tile;
            this.drops.clear();
            if (!worldIn.field_72995_K && (tile = (TileMiningWell)worldIn.func_175625_s(pos)) != null) {
                tile.removePipes();
                int count = this.func_196251_a(state, 0, worldIn, pos, worldIn.field_73012_v);
                Item it = this.func_199769_a(state, worldIn, pos, 0).func_199767_j();
                for (int i = 0; i < count; ++i) {
                    ItemStack is = new ItemStack((IItemProvider)it, 1);
                    IEnchantableTile.Util.enchantmentToIS(tile, is);
                    this.drops.add(is);
                }
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public void getDrops(IBlockState state, NonNullList<ItemStack> drops, World world, BlockPos pos, int fortune) {
        drops.addAll(this.drops);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        if (!worldIn.field_72995_K) {
            Optional.ofNullable((TileMiningWell)worldIn.func_175625_s(pos)).ifPresent(TileMiningWell::G_renew_powerConfigure);
        }
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return Holder.miningWellTileType().func_200968_a();
    }
}

