/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.quarry;

import com.yogpc.qp.compat.BuildcraftHelper;
import com.yogpc.qp.machines.base.IEnchantableTile;
import com.yogpc.qp.machines.base.QPBlock;
import com.yogpc.qp.machines.item.YSetterInteractionObject;
import com.yogpc.qp.machines.quarry.ItemBlockEnchantable;
import com.yogpc.qp.machines.quarry.TileQuarry;
import com.yogpc.qp.utils.Holder;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.INameable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class BlockQuarry
extends QPBlock {
    private final ArrayList<ItemStack> drops = new ArrayList();

    public BlockQuarry() {
        super(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(1.5f, 10.0f).func_200947_a(SoundType.field_185851_d), "quarryplus", ItemBlockEnchantable::new);
        this.func_180632_j((IBlockState)((IBlockState)((IBlockState)this.func_176194_O().func_177621_b()).func_206870_a((IProperty)BlockStateProperties.field_208155_H, (Comparable)EnumFacing.NORTH)).func_206870_a((IProperty)QPBlock.WORKING(), (Comparable)Boolean.valueOf(false)));
    }

    public void func_196243_a(IBlockState state, World worldIn, BlockPos pos, IBlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileQuarry tile;
            this.drops.clear();
            if (!worldIn.field_72995_K && (tile = (TileQuarry)worldIn.func_175625_s(pos)) != null) {
                int count = this.func_196251_a(state, 0, worldIn, pos, worldIn.field_73012_v);
                Item it = this.func_199769_a(state, worldIn, pos, 0).func_199767_j();
                for (int i = 0; i < count; ++i) {
                    ItemStack is = new ItemStack((IItemProvider)it, 1);
                    IEnchantableTile.Util.enchantmentToIS(tile, is);
                    this.drops.add(is);
                }
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public void getDrops(IBlockState state, NonNullList<ItemStack> drops, World world, BlockPos pos, int fortune) {
        drops.addAll(this.drops);
    }

    @Override
    public boolean func_196250_a(IBlockState state, World worldIn, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity t;
        if (super.func_196250_a(state, worldIn, pos, player, hand, side, hitX, hitY, hitZ)) {
            return true;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (BuildcraftHelper.isWrench(player, hand, stack, new RayTraceResult(new Vec3d((double)hitX, (double)hitY, (double)hitZ), side, pos))) {
            Optional.ofNullable((TileQuarry)worldIn.func_175625_s(pos)).ifPresent(TileQuarry::G_ReInit);
            return true;
        }
        if (!worldIn.field_72995_K && (t = worldIn.func_175625_s(pos)) != null) {
            TileQuarry quarry = (TileQuarry)t;
            if (stack.func_77973_b() == Holder.itemStatusChecker()) {
                quarry.sendEnchantMassage(player);
                player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.currentmode", new Object[]{new TextComponentTranslation(quarry.filler ? "chat.fillermode" : "chat.quarrymode", new Object[0])}), false);
            } else if (stack.func_77973_b() == Holder.itemYSetter()) {
                NetworkHooks.openGui((EntityPlayerMP)((EntityPlayerMP)player), (IInteractionObject)YSetterInteractionObject.apply((INameable)quarry), (BlockPos)pos);
            } else if (quarry.G_getNow() == TileQuarry.Mode.NOT_NEED_BREAK) {
                quarry.filler = !quarry.filler;
                player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.changemode", new Object[]{new TextComponentTranslation(quarry.filler ? "chat.fillermode" : "chat.quarrymode", new Object[0])}), false);
            }
        }
        return true;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (!worldIn.field_72995_K) {
            EnumFacing facing = placer.func_174811_aO().func_176734_d();
            worldIn.func_180501_a(pos, (IBlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208155_H, (Comparable)facing), 2);
            Consumer consumer = IEnchantableTile.Util.initConsumer(stack);
            Optional.ofNullable((TileQuarry)worldIn.func_175625_s(pos)).ifPresent(consumer.andThen(TileQuarry.requestTicket));
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        if (!worldIn.field_72995_K) {
            Optional.ofNullable((TileQuarry)worldIn.func_175625_s(pos)).ifPresent(TileQuarry::G_renew_powerConfigure);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{BlockStateProperties.field_208155_H, QPBlock.WORKING()});
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return Holder.quarryTileType().func_200968_a();
    }
}

