/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.quarry;

import com.yogpc.qp.compat.BuildcraftHelper;
import com.yogpc.qp.machines.base.QPBlock;
import com.yogpc.qp.machines.quarry.TileQuarry;
import com.yogpc.qp.machines.quarry.TileSolidQuarry;
import com.yogpc.qp.utils.Holder;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import scala.Symbol;

public class BlockSolidQuarry
extends QPBlock {
    public static final Symbol SYMBOL = Symbol.apply((String)"SolidFuelQuarry");

    public BlockSolidQuarry() {
        super(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(1.5f, 10.0f).func_200947_a(SoundType.field_185851_d), "solidquarry", ItemBlock::new);
        this.func_180632_j((IBlockState)((IBlockState)((IBlockState)this.func_176194_O().func_177621_b()).func_206870_a((IProperty)BlockStateProperties.field_208155_H, (Comparable)EnumFacing.NORTH)).func_206870_a((IProperty)QPBlock.WORKING(), (Comparable)Boolean.valueOf(false)));
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (!worldIn.field_72995_K) {
            EnumFacing facing = placer.func_174811_aO().func_176734_d();
            worldIn.func_180501_a(pos, (IBlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208155_H, (Comparable)facing), 2);
            Optional.ofNullable((TileSolidQuarry)worldIn.func_175625_s(pos)).ifPresent(t -> {
                t.G_ReInit();
                TileSolidQuarry.requestTicket.accept(t);
            });
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{BlockStateProperties.field_208155_H, QPBlock.WORKING()});
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        if (!worldIn.field_72995_K) {
            Optional.ofNullable((TileSolidQuarry)worldIn.func_175625_s(pos)).ifPresent(TileQuarry::G_renew_powerConfigure);
        }
    }

    @Override
    public boolean func_196250_a(IBlockState state, World worldIn, BlockPos pos, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (super.func_196250_a(state, worldIn, pos, playerIn, hand, side, hitX, hitY, hitZ)) {
            return true;
        }
        ItemStack stack = playerIn.func_184586_b(hand);
        if (BuildcraftHelper.isWrench(playerIn, hand, stack, new RayTraceResult(new Vec3d((double)hitX, (double)hitY, (double)hitZ), side, pos))) {
            Optional.ofNullable((TileSolidQuarry)worldIn.func_175625_s(pos)).ifPresent(TileQuarry::G_ReInit);
            return true;
        }
        if (!playerIn.func_70093_af()) {
            if (!worldIn.field_72995_K) {
                Optional.ofNullable((TileSolidQuarry)worldIn.func_175625_s(pos)).ifPresent(t -> NetworkHooks.openGui((EntityPlayerMP)((EntityPlayerMP)playerIn), (IInteractionObject)t, (BlockPos)pos));
            }
            return true;
        }
        return false;
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return Holder.solidQuarryType().func_200968_a();
    }
}

