/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.quarry;

import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.compat.InvUtils;
import com.yogpc.qp.machines.PowerManager;
import com.yogpc.qp.machines.base.APacketTile;
import com.yogpc.qp.machines.base.APowerTile;
import com.yogpc.qp.machines.base.EnergyUsage;
import com.yogpc.qp.machines.base.HasInv;
import com.yogpc.qp.machines.base.IAttachable;
import com.yogpc.qp.machines.base.IAttachment;
import com.yogpc.qp.machines.base.IEnchantableTile;
import com.yogpc.qp.machines.pump.TilePump;
import com.yogpc.qp.machines.quarry.QuarryFakePlayer;
import com.yogpc.qp.machines.workbench.BlockData;
import com.yogpc.qp.utils.NBTBuilder;
import com.yogpc.qp.utils.NoDuplicateList;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jp.t2v.lab.syntax.MapStreamSyntax;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.crafting.VanillaRecipeTypes;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public abstract class TileBasic
extends APowerTile
implements IEnchantableTile,
HasInv,
IAttachable {
    private static final Set<IAttachment.Attachments<?>> VALID_ATTACHMENTS = IAttachment.Attachments.ALL;
    protected final Map<IAttachment.Attachments<?>, EnumFacing> facingMap = new HashMap();
    public NoDuplicateList<BlockData> fortuneList = NoDuplicateList.create(ArrayList::new);
    public NoDuplicateList<BlockData> silktouchList = NoDuplicateList.create(ArrayList::new);
    public boolean fortuneInclude;
    public boolean silktouchInclude;
    protected byte unbreaking;
    protected byte fortune;
    protected boolean silktouch;
    protected byte efficiency;
    protected final LinkedList<ItemStack> cacheItems = new LinkedList();
    protected final IItemHandler handler = this.createHandler();
    protected Map<ResourceLocation, Integer> ench = new HashMap<ResourceLocation, Integer>();
    public int yLevel = 1;
    public static final Method createStackedBlock = ObfuscationReflectionHelper.findMethod(Block.class, (String)"getSilkTouchDrop", (Class[])new Class[]{IBlockState.class});

    public TileBasic(TileEntityType<?> type) {
        super(type);
    }

    public abstract void G_renew_powerConfigure();

    protected abstract void G_destroy();

    @Override
    public final void onChunkUnloaded() {
        this.G_destroy();
        super.onChunkUnloaded();
    }

    protected void S_pollItems() {
        ItemStack is;
        while (null != (is = this.cacheItems.poll())) {
            ItemStack stack = InvUtils.injectToNearTile(this.field_145850_b, this.func_174877_v(), is);
            if (stack.func_190916_E() <= 0) continue;
            this.cacheItems.add(stack);
            break;
        }
    }

    protected boolean S_breakBlock(int x, int y, int z, IBlockState replace) {
        ArrayList<ItemStack> dropped = new ArrayList<ItemStack>(2);
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState blockState = this.field_145850_b.func_180495_p(pos);
        if (blockState.func_177230_c().isAir(blockState, (IBlockReader)this.field_145850_b, pos)) {
            return true;
        }
        BI bi = this.S_addDroppedItems(dropped, blockState, pos);
        if (!PowerManager.useEnergyBreak(this, blockState.func_185887_b((IBlockReader)this.field_145850_b, pos), bi.b, this.unbreaking, bi.b1)) {
            return false;
        }
        Optional.ofNullable(this.facingMap.get(IAttachment.Attachments.EXP_PUMP)).map(arg_0 -> ((BlockPos)this.func_174877_v()).func_177972_a(arg_0)).map(arg_0 -> ((World)this.field_145850_b).func_175625_s(arg_0)).flatMap(IAttachment.Attachments.EXP_PUMP).ifPresent(t -> {
            long expEnergy = t.getEnergyUse(bi.i);
            if (this.useEnergy(expEnergy, expEnergy, false, EnergyUsage.PUMP_EXP) == expEnergy) {
                this.useEnergy(expEnergy, expEnergy, true, EnergyUsage.PUMP_EXP);
                t.addXp(bi.i);
            }
        });
        this.cacheItems.addAll(dropped);
        if (this.facingMap.containsKey(IAttachment.Attachments.FLUID_PUMP) && TilePump.isLiquid(blockState)) {
            TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(this.facingMap.get(IAttachment.Attachments.FLUID_PUMP)));
            if (!(te instanceof TilePump)) {
                this.facingMap.remove(IAttachment.Attachments.FLUID_PUMP);
                this.G_renew_powerConfigure();
                return true;
            }
            boolean b = ((TilePump)te).S_removeLiquids(this, x, y, z);
            if (blockState.func_185904_a().func_76224_d()) {
                return b;
            }
        }
        this.field_145850_b.func_175718_b(2001, pos, Block.func_196246_j((IBlockState)blockState));
        this.field_145850_b.func_180501_a(pos, replace, 3);
        return true;
    }

    @Override
    public boolean connectAttachment(EnumFacing facing, IAttachment.Attachments<? extends APacketTile> attachments, boolean simulate) {
        TileEntity entity;
        if (this.facingMap.containsKey(attachments) && attachments.test(entity = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(this.facingMap.get(attachments)))) && this.facingMap.get(attachments) != facing) {
            return false;
        }
        if (!simulate) {
            this.facingMap.put(attachments, facing);
            this.G_renew_powerConfigure();
        }
        return true;
    }

    @Override
    public boolean isValidAttachment(IAttachment.Attachments<? extends APacketTile> attachments) {
        return VALID_ATTACHMENTS.contains(attachments);
    }

    public void setYLevel(int yLevel) {
        this.yLevel = yLevel;
        QuarryPlus.LOGGER.debug("Quarry yLevel is set to " + yLevel + ".");
    }

    private BI S_addDroppedItems(Collection<ItemStack> collection, IBlockState state, BlockPos pos) {
        int i;
        Block block = state.func_177230_c();
        int xp = 0;
        QuarryFakePlayer fakePlayer = QuarryFakePlayer.get((WorldServer)this.field_145850_b);
        fakePlayer.func_184611_a(EnumHand.MAIN_HAND, this.getEnchantedPickaxe());
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(this.field_145850_b, pos, state, (EntityPlayer)fakePlayer);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (!event.isCanceled()) {
            HashSet<ItemStack> rawItems;
            if (block.canSilkHarvest(state, (IWorldReader)this.field_145850_b, pos, (EntityPlayer)fakePlayer) && this.silktouch && this.silktouchList.contains(new BlockData(state)) == this.silktouchInclude) {
                NonNullList list = NonNullList.func_191196_a();
                list.add(TileBasic.invoke(createStackedBlock, block, state));
                rawItems = new HashSet(list);
                ForgeEventFactory.fireBlockHarvesting((NonNullList)list, (World)this.field_145850_b, (BlockPos)pos, (IBlockState)state, (int)0, (float)1.0f, (boolean)true, (EntityPlayer)fakePlayer);
                collection.addAll((Collection<ItemStack>)list);
                i = -1;
            } else {
                boolean b = this.fortuneList.contains(new BlockData(state)) == this.fortuneInclude;
                int fortuneLevel = b ? this.fortune : 0;
                NonNullList list = NonNullList.func_191196_a();
                block.getDrops(state, list, this.field_145850_b, pos, fortuneLevel);
                rawItems = new HashSet<ItemStack>((Collection<ItemStack>)list);
                ForgeEventFactory.fireBlockHarvesting((NonNullList)list, (World)this.field_145850_b, (BlockPos)pos, (IBlockState)state, (int)fortuneLevel, (float)1.0f, (boolean)false, (EntityPlayer)fakePlayer);
                collection.addAll((Collection<ItemStack>)list);
                i = fortuneLevel;
            }
            if (this.facingMap.containsKey(IAttachment.Attachments.EXP_PUMP)) {
                xp += event.getExpToDrop();
                if (InvUtils.hasSmelting(fakePlayer.func_184614_ca())) {
                    xp += this.getSmeltingXp(collection, rawItems);
                }
            }
        } else {
            i = -2;
        }
        fakePlayer.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
        return new BI((byte)i, xp, this.facingMap.containsKey(IAttachment.Attachments.REPLACER));
    }

    public int getSmeltingXp(Collection<ItemStack> stacks, Collection<ItemStack> raw) {
        InventoryBasic basic = new InventoryBasic((ITextComponent)new TextComponentString("Dummy"), 2);
        return stacks.stream().filter(MapStreamSyntax.not(raw::contains)).mapToInt(stack -> {
            basic.func_70299_a(0, stack);
            Optional<IRecipe> recipe = Optional.ofNullable(this.field_145850_b.func_199532_z().getRecipe((IInventory)basic, this.field_145850_b, VanillaRecipeTypes.SMELTING));
            return TileBasic.floorFloat(recipe.map(FurnaceRecipe::func_201831_g).orElse(Float.valueOf(0.0f)).floatValue() * (float)stack.func_190916_E());
        }).sum();
    }

    static int floorFloat(float value) {
        int i = MathHelper.func_76141_d((float)value);
        return i + (Math.random() < (double)(value - (float)i) ? 1 : 0);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.silktouch = nbt.func_74767_n("silktouch");
        this.fortune = nbt.func_74771_c("fortune");
        this.efficiency = nbt.func_74771_c("efficiency");
        this.unbreaking = nbt.func_74771_c("unbreaking");
        this.fortuneInclude = nbt.func_74767_n("fortuneInclude");
        this.silktouchInclude = nbt.func_74767_n("silktouchInclude");
        this.yLevel = Math.max(nbt.func_74762_e("yLevel"), 1);
        this.fortuneList = nbt.func_150295_c("fortuneList", 10).stream().map(NBTTagCompound.class::cast).map(BlockData::read).collect(Collectors.toCollection(NoDuplicateList::create));
        this.silktouchList = nbt.func_150295_c("silktouchList", 10).stream().map(NBTTagCompound.class::cast).map(BlockData::read).collect(Collectors.toCollection(NoDuplicateList::create));
        this.ench = nbt.func_150295_c("enchList", 10).stream().map(NBTTagCompound.class::cast).map(MapStreamSyntax.toEntry(n -> n.func_74779_i("id"), n -> n.func_74762_e("value"))).map(MapStreamSyntax.keys(ResourceLocation::new)).filter(MapStreamSyntax.byKey(arg_0 -> ((IForgeRegistry)ForgeRegistries.ENCHANTMENTS).containsKey(arg_0))).collect(MapStreamSyntax.entryToMap());
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74757_a("silktouch", this.silktouch);
        nbt.func_74774_a("fortune", this.fortune);
        nbt.func_74774_a("efficiency", this.efficiency);
        nbt.func_74774_a("unbreaking", this.unbreaking);
        nbt.func_74757_a("fortuneInclude", this.fortuneInclude);
        nbt.func_74757_a("silktouchInclude", this.silktouchInclude);
        nbt.func_74782_a("fortuneList", (INBTBase)this.fortuneList.stream().map(BlockData::toNbt).collect(Collectors.toCollection(NBTTagList::new)));
        nbt.func_74782_a("silktouchList", (INBTBase)this.silktouchList.stream().map(BlockData::toNbt).collect(Collectors.toCollection(NBTTagList::new)));
        nbt.func_74768_a("yLevel", this.yLevel);
        nbt.func_74782_a("enchList", (INBTBase)this.ench.entrySet().stream().map(MapStreamSyntax.keys(ResourceLocation::toString)).map(MapStreamSyntax.values(NBTTagInt::new)).collect(NBTBuilder.toNBTTag()));
        return super.func_189515_b(nbt);
    }

    @Override
    @Nonnull
    public Map<ResourceLocation, Integer> getEnchantments() {
        HashMap<ResourceLocation, Integer> ret = new HashMap<ResourceLocation, Integer>(this.ench);
        if (this.efficiency > 0) {
            ret.put(EfficiencyID, Integer.valueOf(this.efficiency));
        }
        if (this.fortune > 0) {
            ret.put(FortuneID, Integer.valueOf(this.fortune));
        }
        if (this.unbreaking > 0) {
            ret.put(UnbreakingID, Integer.valueOf(this.unbreaking));
        }
        if (this.silktouch) {
            ret.put(SilktouchID, 1);
        }
        return ret;
    }

    @Override
    public void setEnchantment(ResourceLocation id, short val) {
        if (id.equals((Object)EfficiencyID)) {
            this.efficiency = (byte)val;
        } else if (id.equals((Object)FortuneID)) {
            this.fortune = (byte)val;
        } else if (id.equals((Object)UnbreakingID)) {
            this.unbreaking = (byte)val;
        } else if (id.equals((Object)SilktouchID)) {
            boolean bl = this.silktouch = val > 0;
        }
        if (val > 0) {
            this.ench.put(id, Integer.valueOf(val));
        }
    }

    @Override
    public int func_70302_i_() {
        return Math.max(1, this.cacheItems.size());
    }

    @Override
    @Nonnull
    public ItemStack func_70301_a(int i) {
        return i < 0 || i >= this.cacheItems.size() ? ItemStack.field_190927_a : this.cacheItems.get(i);
    }

    @Override
    @Nonnull
    public ItemStack func_70298_a(int index, int count) {
        if (index < 0 || index >= this.cacheItems.size()) {
            return ItemStack.field_190927_a;
        }
        ItemStack from = this.cacheItems.get(index);
        ItemStack res = new ItemStack((IItemProvider)from.func_77973_b(), Math.min(count, from.func_190916_E()));
        Optional.ofNullable(from.func_77978_p()).map(NBTTagCompound::func_74737_b).ifPresent(arg_0 -> ((ItemStack)res).func_77982_d(arg_0));
        from.func_190918_g(res.func_190916_E());
        if (from.func_190926_b()) {
            this.cacheItems.remove(index);
        }
        return res;
    }

    @Override
    @Nonnull
    public ItemStack func_70304_b(int index) {
        return index < 0 || index >= this.cacheItems.size() ? ItemStack.field_190927_a : this.cacheItems.remove(index);
    }

    @Override
    public void func_70299_a(int index, ItemStack stack) {
        if (!stack.func_190926_b()) {
            QuarryPlus.LOGGER.warn("QuarryPlus WARN: call setInventorySlotContents with non null ItemStack.");
        }
        this.func_70304_b(index);
    }

    public ITextComponent func_200200_C_() {
        return new TextComponentString("container.yog.basic");
    }

    @Override
    public boolean func_70300_a(EntityPlayer player) {
        return false;
    }

    @Override
    public boolean func_191420_l() {
        return this.cacheItems.isEmpty();
    }

    @Override
    public void func_174888_l() {
        this.cacheItems.clear();
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable EnumFacing side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(cap, LazyOptional.of(() -> this.handler));
        }
        return super.getCapability(cap, side);
    }

    private static class BI {
        final byte b;
        final int i;
        final boolean b1;

        private BI(byte b, int i, boolean b1) {
            this.b = b;
            this.i = i;
            this.b1 = b1;
        }
    }
}

